/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSchemaFieldsUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    public static final Logger log = LoggerFactory.getLogger(AddSchemaFieldsUpdateProcessorFactory.class);
    private static final String TYPE_MAPPING_PARAM = "typeMapping";
    private static final String VALUE_CLASS_PARAM = "valueClass";
    private static final String FIELD_TYPE_PARAM = "fieldType";
    private static final String DEFAULT_FIELD_TYPE_PARAM = "defaultFieldType";
    private List<TypeMapping> typeMappings = Collections.emptyList();
    private FieldMutatingUpdateProcessorFactory.SelectorParams inclusions = new FieldMutatingUpdateProcessorFactory.SelectorParams();
    private Collection<FieldMutatingUpdateProcessorFactory.SelectorParams> exclusions = new ArrayList<FieldMutatingUpdateProcessorFactory.SelectorParams>();
    private FieldMutatingUpdateProcessor.FieldNameSelector selector = null;
    private String defaultFieldType;

    protected final FieldMutatingUpdateProcessor.FieldNameSelector getSelector() {
        if (null != this.selector) {
            return this.selector;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "selector was never initialized, inform(SolrCore) never called???");
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new AddSchemaFieldsUpdateProcessor(next);
    }

    @Override
    public void init(NamedList args) {
        this.inclusions = FieldMutatingUpdateProcessorFactory.parseSelectorParams(args);
        this.validateSelectorParams(this.inclusions);
        this.inclusions.fieldNameMatchesSchemaField = false;
        this.exclusions = FieldMutatingUpdateProcessorFactory.parseSelectorExclusionParams(args);
        for (FieldMutatingUpdateProcessorFactory.SelectorParams exclusion : this.exclusions) {
            this.validateSelectorParams(exclusion);
        }
        Object defaultFieldTypeParam = args.remove(DEFAULT_FIELD_TYPE_PARAM);
        if (null == defaultFieldTypeParam) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init param 'defaultFieldType'");
        }
        if (!(defaultFieldTypeParam instanceof CharSequence)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'defaultFieldType' must be a <str>");
        }
        this.defaultFieldType = defaultFieldTypeParam.toString();
        this.typeMappings = AddSchemaFieldsUpdateProcessorFactory.parseTypeMappings(args);
        super.init(args);
    }

    @Override
    public void inform(SolrCore core) {
        this.selector = FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, this.inclusions, this.getDefaultSelector(core));
        for (FieldMutatingUpdateProcessorFactory.SelectorParams exc : this.exclusions) {
            this.selector = FieldMutatingUpdateProcessor.wrap(this.selector, FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, exc, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS));
        }
        for (TypeMapping typeMapping : this.typeMappings) {
            typeMapping.populateValueClasses(core);
        }
    }

    private FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(final SolrCore core) {
        return new FieldMutatingUpdateProcessor.FieldNameSelector(){

            @Override
            public boolean shouldMutate(String fieldName) {
                return null == core.getLatestSchema().getFieldTypeNoEx(fieldName);
            }
        };
    }

    private static List<TypeMapping> parseTypeMappings(NamedList args) {
        ArrayList<TypeMapping> typeMappings = new ArrayList<TypeMapping>();
        List typeMappingsParams = args.getAll(TYPE_MAPPING_PARAM);
        for (Object typeMappingObj : typeMappingsParams) {
            if (null == typeMappingObj) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeMapping' init param cannot be null");
            }
            if (!(typeMappingObj instanceof NamedList)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeMapping' init param must be a <lst>");
            }
            NamedList typeMappingNamedList = (NamedList)typeMappingObj;
            Object fieldTypeObj = typeMappingNamedList.remove(FIELD_TYPE_PARAM);
            if (null == fieldTypeObj) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'typeMapping' <lst/> must contain a 'fieldType' <str>");
            }
            if (!(fieldTypeObj instanceof CharSequence)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'fieldType' init param must be a <str>");
            }
            if (null != typeMappingNamedList.get(FIELD_TYPE_PARAM)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'typeMapping' <lst/> may contain only one 'fieldType' <str>");
            }
            String fieldType = fieldTypeObj.toString();
            Collection<String> valueClasses = typeMappingNamedList.removeConfigArgs(VALUE_CLASS_PARAM);
            if (valueClasses.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each 'typeMapping' <lst/> must contain at least one 'valueClass' <str>");
            }
            typeMappings.add(new TypeMapping(fieldType, valueClasses));
            if (0 != typeMappingNamedList.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected 'typeMapping' init sub-param(s): '" + typeMappingNamedList.toString() + "'");
            }
            args.remove(TYPE_MAPPING_PARAM);
        }
        return typeMappings;
    }

    private void validateSelectorParams(FieldMutatingUpdateProcessorFactory.SelectorParams params) {
        if (!params.typeName.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeName' init param is not allowed in this processor");
        }
        if (!params.typeClass.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'typeClass' init param is not allowed in this processor");
        }
        if (null != params.fieldNameMatchesSchemaField) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'fieldNameMatchesSchemaField' init param is not allowed in this processor");
        }
    }

    private class AddSchemaFieldsUpdateProcessor
    extends UpdateRequestProcessor {
        public AddSchemaFieldsUpdateProcessor(UpdateRequestProcessor next) {
            super(next);
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            if (!cmd.getReq().getCore().getLatestSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            SolrInputDocument doc = cmd.getSolrInputDocument();
            SolrCore core = cmd.getReq().getCore();
            while (true) {
                IndexSchema oldSchema = core.getLatestSchema();
                ArrayList<SchemaField> newFields = new ArrayList<SchemaField>();
                for (String fieldName : doc.getFieldNames()) {
                    if (!AddSchemaFieldsUpdateProcessorFactory.this.selector.shouldMutate(fieldName)) continue;
                    String fieldTypeName = this.mapValueClassesToFieldType(doc.getField(fieldName));
                    newFields.add(oldSchema.newField(fieldName, fieldTypeName, Collections.emptyMap()));
                }
                if (newFields.isEmpty()) {
                    log.debug("No fields to add to the schema.");
                    break;
                }
                if (log.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Fields to be added to the schema: [");
                    boolean isFirst = true;
                    for (SchemaField field : newFields) {
                        builder.append(isFirst ? "" : ",");
                        isFirst = false;
                        builder.append(field.getName());
                        builder.append("{type=").append(field.getType().getTypeName()).append("}");
                    }
                    builder.append("]");
                    log.debug(builder.toString());
                }
                try {
                    IndexSchema newSchema = oldSchema.addFields(newFields);
                    cmd.getReq().getCore().setLatestSchema(newSchema);
                    cmd.getReq().updateSchemaToLatest();
                    log.debug("Successfully added field(s) to the schema.");
                }
                catch (ManagedIndexSchema.FieldExistsException e) {
                    log.debug("At least one field to be added already exists in the schema - retrying.");
                    continue;
                }
                break;
            }
            super.processAdd(cmd);
        }

        private String mapValueClassesToFieldType(SolrInputField field) {
            block0: for (TypeMapping typeMapping : AddSchemaFieldsUpdateProcessorFactory.this.typeMappings) {
                block1: for (Object fieldValue : field.getValues()) {
                    for (Class<?> valueClass : typeMapping.valueClasses) {
                        if (!valueClass.isInstance(fieldValue)) continue;
                        continue block1;
                    }
                    continue block0;
                }
                return typeMapping.fieldTypeName;
            }
            return AddSchemaFieldsUpdateProcessorFactory.this.defaultFieldType;
        }
    }

    private static class TypeMapping {
        public String fieldTypeName;
        public Collection<String> valueClassNames;
        public Set<Class<?>> valueClasses;

        public TypeMapping(String fieldTypeName, Collection<String> valueClassNames) {
            this.fieldTypeName = fieldTypeName;
            this.valueClassNames = valueClassNames;
        }

        public void populateValueClasses(SolrCore core) {
            IndexSchema schema = core.getLatestSchema();
            ClassLoader loader = core.getResourceLoader().getClassLoader();
            if (null == schema.getFieldTypeByName(this.fieldTypeName)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "fieldType '" + this.fieldTypeName + "' not found in the schema");
            }
            this.valueClasses = new HashSet();
            for (String valueClassName : this.valueClassNames) {
                try {
                    this.valueClasses.add(loader.loadClass(valueClassName));
                }
                catch (ClassNotFoundException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "valueClass '" + valueClassName + "' not found for fieldType '" + this.fieldTypeName + "'");
                }
            }
        }
    }
}

