/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.internal.BaseView;
import org.jclouds.location.Provider;
import org.jclouds.rest.Utils;

@Singleton
public class BlobStoreContextImpl
extends BaseView
implements BlobStoreContext {
    private final AsyncBlobStore ablobStore;
    private final BlobStore blobStore;
    private final ConsistencyModel consistencyModel;
    private final Utils utils;
    private final BlobRequestSigner blobRequestSigner;

    @Inject
    public BlobStoreContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, Utils utils, ConsistencyModel consistencyModel, AsyncBlobStore ablobStore, BlobStore blobStore, BlobRequestSigner blobRequestSigner) {
        super(backend, backendType);
        this.consistencyModel = (ConsistencyModel)((Object)Preconditions.checkNotNull((Object)((Object)consistencyModel), (Object)"consistencyModel"));
        this.ablobStore = (AsyncBlobStore)Preconditions.checkNotNull((Object)ablobStore, (Object)"ablobStore");
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore, (Object)"blobStore");
        this.utils = (Utils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
        this.blobRequestSigner = (BlobRequestSigner)Preconditions.checkNotNull((Object)blobRequestSigner, (Object)"blobRequestSigner");
    }

    @Override
    public ConsistencyModel getConsistencyModel() {
        return this.consistencyModel;
    }

    @Override
    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    @Override
    public AsyncBlobStore getAsyncBlobStore() {
        return this.ablobStore;
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public BlobRequestSigner getSigner() {
        return this.blobRequestSigner;
    }

    @Override
    public void close() {
        Closeables.closeQuietly((Closeable)this.delegate());
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public String toString() {
        return this.delegate().toString();
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

