/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.HashBasedRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;

public class CompositeIdRouter
extends HashBasedRouter {
    public static final String NAME = "compositeId";
    public static final String SEPARATOR = "!";
    public static final int bitsSeparator = 47;
    private int bits = 16;

    @Override
    public int sliceHash(String id, SolrInputDocument doc, SolrParams params, DocCollection collection) {
        String shardFieldName = this.getRouteField(collection);
        if (shardFieldName != null && doc != null) {
            Object o = doc.getFieldValue(shardFieldName);
            if (o == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No value for :" + shardFieldName + ". Unable to identify shard");
            }
            id = o.toString();
        }
        if (id.indexOf(SEPARATOR) < 0) {
            return Hash.murmurhash3_x86_32(id, 0, id.length(), 0);
        }
        return new KeyParser(id).getHash();
    }

    @Override
    public Slice getTargetSlice(String id, SolrInputDocument sdoc, String route, SolrParams params, DocCollection collection) {
        String shardFieldName;
        if (sdoc == null && route == null && (shardFieldName = this.getRouteField(collection)) != null) {
            return null;
        }
        return super.getTargetSlice(id, sdoc, route, params, collection);
    }

    public DocRouter.Range keyHashRange(String routeKey) {
        if (routeKey.indexOf(SEPARATOR) < 0) {
            int hash = this.sliceHash(routeKey, null, null, null);
            return new DocRouter.Range(hash, hash);
        }
        return new KeyParser(routeKey).getRange();
    }

    @Override
    public DocRouter.Range getSearchRangeSingle(String shardKey, SolrParams params, DocCollection collection) {
        if (shardKey == null) {
            return this.fullRange();
        }
        if (shardKey.indexOf(SEPARATOR) < 0) {
            int hash = Hash.murmurhash3_x86_32(shardKey, 0, shardKey.length(), 0);
            return new DocRouter.Range(hash, hash);
        }
        return new KeyParser(shardKey).getRange();
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String shardKey, SolrParams params, DocCollection collection) {
        if (shardKey == null) {
            return collection.getActiveSlices();
        }
        String id = shardKey;
        if (shardKey.indexOf(SEPARATOR) < 0) {
            return Collections.singletonList(this.hashToSlice(Hash.murmurhash3_x86_32(id, 0, id.length(), 0), collection));
        }
        DocRouter.Range completeRange = new KeyParser(id).getRange();
        ArrayList<Slice> targetSlices = new ArrayList<Slice>(1);
        for (Slice slice : collection.getActiveSlicesArr()) {
            DocRouter.Range range = slice.getRange();
            if (range == null || !range.overlaps(completeRange)) continue;
            targetSlices.add(slice);
        }
        return targetSlices;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<DocRouter.Range> partitionRangeByKey(String key, DocRouter.Range range) {
        ArrayList<DocRouter.Range> result = new ArrayList<DocRouter.Range>(3);
        DocRouter.Range keyRange = this.keyHashRange(key);
        if (!keyRange.overlaps(range)) {
            throw new IllegalArgumentException("Key range does not overlap given range");
        }
        if (keyRange.equals(range)) {
            return Collections.singletonList(keyRange);
        }
        if (keyRange.isSubsetOf(range)) {
            result.add(new DocRouter.Range(range.min, keyRange.min - 1));
            result.add(keyRange);
            result.add(new DocRouter.Range(keyRange.max + 1, range.max));
        } else if (range.includes(keyRange.max)) {
            result.add(new DocRouter.Range(range.min, keyRange.max));
            result.add(new DocRouter.Range(keyRange.max + 1, range.max));
        } else {
            result.add(new DocRouter.Range(range.min, keyRange.min - 1));
            result.add(new DocRouter.Range(keyRange.min, range.max));
        }
        return result;
    }

    @Override
    public List<DocRouter.Range> partitionRange(int partitions, DocRouter.Range range) {
        boolean round;
        long targetStart;
        long start;
        int min = range.min;
        int max = range.max;
        assert (max >= min);
        if (partitions == 0) {
            return Collections.emptyList();
        }
        long rangeSize = (long)max - (long)min;
        long rangeStep = Math.max(1L, rangeSize / (long)partitions);
        ArrayList<DocRouter.Range> ranges = new ArrayList<DocRouter.Range>(partitions);
        long end = start = (long)min;
        long targetEnd = targetStart = (long)min;
        int mask = 65535;
        boolean bl = round = rangeStep >= (long)((1 << this.bits) * 16);
        while (end < (long)max) {
            end = targetEnd = targetStart + rangeStep;
            if (round && (end & (long)mask) != (long)mask) {
                int increment = 1 << this.bits;
                long roundDown = (end | (long)mask) - (long)increment;
                long roundUp = (end | (long)mask) + (long)increment;
                end = end - roundDown < roundUp - end && roundDown > start ? roundDown : roundUp;
            }
            if (ranges.size() == partitions - 1) {
                end = max;
            }
            ranges.add(new DocRouter.Range((int)start, (int)end));
            start = end + 1L;
            targetStart = targetEnd + 1L;
        }
        return ranges;
    }

    static class KeyParser {
        String key;
        int[] numBits;
        int[] hashes;
        int[] masks;
        boolean triLevel;
        int pieces;

        public KeyParser(String key) {
            this.key = key;
            ArrayList<String> partsList = new ArrayList<String>(3);
            int firstSeparatorPos = key.indexOf(CompositeIdRouter.SEPARATOR);
            if (-1 == firstSeparatorPos) {
                partsList.add(key);
            } else {
                partsList.add(key.substring(0, firstSeparatorPos));
                int lastPos = key.length() - 1;
                if (firstSeparatorPos < lastPos) {
                    int secondSeparatorPos = key.indexOf(CompositeIdRouter.SEPARATOR, firstSeparatorPos + 1);
                    if (-1 == secondSeparatorPos) {
                        partsList.add(key.substring(firstSeparatorPos + 1));
                    } else if (secondSeparatorPos == lastPos) {
                        if (firstSeparatorPos < secondSeparatorPos - 1) {
                            partsList.add(key.substring(firstSeparatorPos + 1, secondSeparatorPos));
                        }
                    } else {
                        partsList.add(key.substring(firstSeparatorPos + 1, secondSeparatorPos));
                        partsList.add(key.substring(secondSeparatorPos + 1));
                    }
                }
            }
            this.pieces = partsList.size();
            String[] parts = partsList.toArray(new String[this.pieces]);
            this.numBits = new int[2];
            if (key.endsWith(CompositeIdRouter.SEPARATOR) && this.pieces < 3) {
                ++this.pieces;
            }
            this.hashes = new int[this.pieces];
            if (this.pieces == 3) {
                this.numBits[0] = 8;
                this.numBits[1] = 8;
                this.triLevel = true;
            } else {
                this.numBits[0] = 16;
                this.triLevel = false;
            }
            for (int i = 0; i < this.pieces; ++i) {
                int commaIdx;
                if (i < this.pieces - 1 && (commaIdx = parts[i].indexOf(47)) > 0) {
                    this.numBits[i] = this.getNumBits(parts[i], commaIdx);
                    parts[i] = parts[i].substring(0, commaIdx);
                }
                this.hashes[i] = i >= parts.length ? Hash.murmurhash3_x86_32("", 0, "".length(), 0) : Hash.murmurhash3_x86_32(parts[i], 0, parts[i].length(), 0);
            }
            this.masks = this.getMasks();
        }

        DocRouter.Range getRange() {
            int upperBound;
            int lowerBound;
            if (this.triLevel) {
                lowerBound = this.hashes[0] & this.masks[0] | this.hashes[1] & this.masks[1];
                upperBound = lowerBound | this.masks[2];
            } else {
                lowerBound = this.hashes[0] & this.masks[0];
                upperBound = lowerBound | this.masks[1];
            }
            if (this.masks[0] == 0 && !this.triLevel || this.masks[0] == 0 && this.masks[1] == 0 && this.triLevel) {
                lowerBound = Integer.MIN_VALUE;
                upperBound = Integer.MAX_VALUE;
            }
            DocRouter.Range r = new DocRouter.Range(lowerBound, upperBound);
            return r;
        }

        private int[] getMasks() {
            int[] masks = this.triLevel ? this.getBitMasks(this.numBits[0], this.numBits[1]) : this.getBitMasks(this.numBits[0]);
            return masks;
        }

        private int[] getBitMasks(int firstBits, int secondBits) {
            int[] masks = new int[3];
            masks[0] = firstBits == 0 ? 0 : -1 << 32 - firstBits;
            masks[1] = firstBits + secondBits == 0 ? 0 : -1 << 32 - firstBits - secondBits;
            masks[1] = masks[0] ^ masks[1];
            masks[2] = firstBits + secondBits == 32 ? 0 : ~(masks[0] | masks[1]);
            return masks;
        }

        private int getNumBits(String firstPart, int commaIdx) {
            int v = 0;
            for (int idx = commaIdx + 1; idx < firstPart.length(); ++idx) {
                char ch = firstPart.charAt(idx);
                if (ch < '0' || ch > '9') {
                    return -1;
                }
                v = v * 10 + (ch - 48);
            }
            return v > 32 ? -1 : v;
        }

        private int[] getBitMasks(int firstBits) {
            int[] masks = new int[]{firstBits == 0 ? 0 : -1 << 32 - firstBits, firstBits == 32 ? 0 : -1 >>> firstBits};
            return masks;
        }

        int getHash() {
            int result = this.hashes[0] & this.masks[0];
            for (int i = 1; i < this.pieces; ++i) {
                result |= this.hashes[i] & this.masks[i];
            }
            return result;
        }
    }
}

