/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.SecurityAwareZkACLProvider;
import org.apache.solr.common.cloud.VMParamsSingleSetCredentialsDigestZkCredentialsProvider;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

public class VMParamsAllAndReadonlyDigestZkACLProvider
extends SecurityAwareZkACLProvider {
    public static final String DEFAULT_DIGEST_READONLY_USERNAME_VM_PARAM_NAME = "zkDigestReadonlyUsername";
    public static final String DEFAULT_DIGEST_READONLY_PASSWORD_VM_PARAM_NAME = "zkDigestReadonlyPassword";
    final String zkDigestAllUsernameVMParamName;
    final String zkDigestAllPasswordVMParamName;
    final String zkDigestReadonlyUsernameVMParamName;
    final String zkDigestReadonlyPasswordVMParamName;
    final Properties credentialsProps;

    public VMParamsAllAndReadonlyDigestZkACLProvider() {
        this("zkDigestUsername", "zkDigestPassword", DEFAULT_DIGEST_READONLY_USERNAME_VM_PARAM_NAME, DEFAULT_DIGEST_READONLY_PASSWORD_VM_PARAM_NAME);
    }

    public VMParamsAllAndReadonlyDigestZkACLProvider(String zkDigestAllUsernameVMParamName, String zkDigestAllPasswordVMParamName, String zkDigestReadonlyUsernameVMParamName, String zkDigestReadonlyPasswordVMParamName) {
        this.zkDigestAllUsernameVMParamName = zkDigestAllUsernameVMParamName;
        this.zkDigestAllPasswordVMParamName = zkDigestAllPasswordVMParamName;
        this.zkDigestReadonlyUsernameVMParamName = zkDigestReadonlyUsernameVMParamName;
        this.zkDigestReadonlyPasswordVMParamName = zkDigestReadonlyPasswordVMParamName;
        String pathToFile = System.getProperty("zkDigestCredentialsFile");
        this.credentialsProps = pathToFile != null ? VMParamsSingleSetCredentialsDigestZkCredentialsProvider.readCredentialsFile(pathToFile) : System.getProperties();
    }

    @Override
    protected List<ACL> createNonSecurityACLsToAdd() {
        return this.createACLsToAdd(true);
    }

    @Override
    protected List<ACL> createSecurityACLsToAdd() {
        return this.createACLsToAdd(false);
    }

    protected List<ACL> createACLsToAdd(boolean includeReadOnly) {
        String digestAllUsername = this.credentialsProps.getProperty(this.zkDigestAllUsernameVMParamName);
        String digestAllPassword = this.credentialsProps.getProperty(this.zkDigestAllPasswordVMParamName);
        String digestReadonlyUsername = this.credentialsProps.getProperty(this.zkDigestReadonlyUsernameVMParamName);
        String digestReadonlyPassword = this.credentialsProps.getProperty(this.zkDigestReadonlyPasswordVMParamName);
        return this.createACLsToAdd(includeReadOnly, digestAllUsername, digestAllPassword, digestReadonlyUsername, digestReadonlyPassword);
    }

    protected List<ACL> createACLsToAdd(boolean includeReadOnly, String digestAllUsername, String digestAllPassword, String digestReadonlyUsername, String digestReadonlyPassword) {
        try {
            ArrayList result = new ArrayList(2);
            if (!StringUtils.isEmpty(digestAllUsername) && !StringUtils.isEmpty(digestAllPassword)) {
                result.add(new ACL(31, new Id("digest", DigestAuthenticationProvider.generateDigest((String)(digestAllUsername + ":" + digestAllPassword)))));
            }
            if (includeReadOnly && !StringUtils.isEmpty(digestReadonlyUsername) && !StringUtils.isEmpty(digestReadonlyPassword)) {
                result.add(new ACL(1, new Id("digest", DigestAuthenticationProvider.generateDigest((String)(digestReadonlyUsername + ":" + digestReadonlyPassword)))));
            }
            if (result.isEmpty()) {
                result = ZooDefs.Ids.OPEN_ACL_UNSAFE;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JVM mis-configured: missing SHA-1 algorithm", e);
        }
    }
}

