/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.Partition;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.SqlNewHadoopPartition;
import org.apache.spark.rdd.SqlNewHadoopRDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.DirectParquetOutputCommitter;
import org.apache.spark.sql.execution.datasources.parquet.MutableRowWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRelation$$anonfun$buildScan$1$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.execution.datasources.parquet.RowWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.RowWriteSupport$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.HadoopFsRelation;
import org.apache.spark.sql.sources.OutputWriter;
import org.apache.spark.sql.sources.OutputWriterFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.spark-project.guava.base.Objects;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\rMe!B\u0001\u0003\u0001!\u0001\"a\u0004)beF,X\r\u001e*fY\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011a\u00029beF,X\r\u001e\u0006\u0003\u000b\u0019\t1\u0002Z1uCN|WO]2fg*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h'\r\u0001\u0011c\u0006\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tqa]8ve\u000e,7/\u0003\u0002\u0017'\t\u0001\u0002*\u00193p_B45OU3mCRLwN\u001c\t\u00031ei\u0011AC\u0005\u00035)\u0011q\u0001T8hO&tw\r\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0011\u001f\u0003\u0015\u0001\u0018\r\u001e5t\u0007\u0001)\u0012a\b\t\u0004A\r*S\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019JcB\u0001\u0011(\u0013\tA\u0013%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015\"\u0011!i\u0003A!A!\u0002\u0013y\u0012A\u00029bi\"\u001c\b\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u00031\u0003=i\u0017-\u001f2f\t\u0006$\u0018mU2iK6\fW#A\u0019\u0011\u0007\u0001\u0012D'\u0003\u00024C\t1q\n\u001d;j_:\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0005\u0002\u000bQL\b/Z:\n\u0005e2$AC*ueV\u001cG\u000fV=qK\"A1\b\u0001B\u0001B\u0003%\u0011'\u0001\tnCf\u0014W\rR1uCN\u001b\u0007.Z7bA!AQ\b\u0001BC\u0002\u0013%a(\u0001\nnCf\u0014W\rU1si&$\u0018n\u001c8Ta\u0016\u001cW#A \u0011\u0007\u0001\u0012\u0004\t\u0005\u0002B\u00056\tA!\u0003\u0002D\t\ti\u0001+\u0019:uSRLwN\\*qK\u000eD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0014[\u0006L(-\u001a)beRLG/[8o'B,7\r\t\u0005\t\u000f\u0002\u0011)\u0019!C!a\u0005YRo]3s\t\u00164\u0017N\\3e!\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]ND\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006I!M\u0001\u001dkN,'\u000fR3gS:,G\rU1si&$\u0018n\u001c8D_2,XN\\:!\u0011!Y\u0005A!A!\u0002\u0013a\u0015A\u00039be\u0006lW\r^3sgB!a%T\u0013&\u0013\tq5FA\u0002NCBD\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!U\u0001\u000bgFd7i\u001c8uKb$X#\u0001*\u0011\u0005M#V\"\u0001\u0005\n\u0005UC!AC*R\u0019\u000e{g\u000e^3yi\"Aq\u000b\u0001B\u0001B\u0003%!+A\u0006tc2\u001cuN\u001c;fqR\u0004\u0003\"B-\u0001\t\u0003Q\u0016A\u0002\u001fj]&$h\b\u0006\u0004\\?\u0002\f'm\u0019\u000b\u00039z\u0003\"!\u0018\u0001\u000e\u0003\tAQ\u0001\u0015-A\u0002ICQ\u0001\b-A\u0002}AQa\f-A\u0002EBQ!\u0010-A\u0002}BQa\u0012-A\u0002EBQa\u0013-A\u00021Ca!\u0017\u0001\u0005\u0002!)G#\u00024iS*\\GC\u0001/h\u0011\u0015\u0001F\r1\u0001S\u0011\u0015aB\r1\u0001 \u0011\u0015yC\r1\u00012\u0011\u0015iD\r1\u0001@\u0011\u0015YE\r1\u0001M\u0011\u001di\u0007A1A\u0005\n9\f!c\u001d5pk2$W*\u001a:hKN\u001b\u0007.Z7bgV\tq\u000e\u0005\u0002!a&\u0011\u0011/\t\u0002\b\u0005>|G.Z1o\u0011\u0019\u0019\b\u0001)A\u0005_\u0006\u00192\u000f[8vY\u0012lUM]4f'\u000eDW-\\1tA!9Q\u000f\u0001b\u0001\n\u0013q\u0017!F7fe\u001e,'+Z:qK\u000e$8+^7nCJLWm\u001d\u0005\u0007o\u0002\u0001\u000b\u0011B8\u0002-5,'oZ3SKN\u0004Xm\u0019;Tk6l\u0017M]5fg\u0002Bq!\u001f\u0001C\u0002\u0013%\u0001'\u0001\u000bnCf\u0014W-T3uCN$xN]3TG\",W.\u0019\u0005\u0007w\u0002\u0001\u000b\u0011B\u0019\u0002+5\f\u0017PY3NKR\f7\u000f^8sKN\u001b\u0007.Z7bA!AQ\u0010\u0001EC\u0002\u0013%a0A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0002\u007fB!\u0011\u0011AA\u0002\u001b\u0005\u0001aABA\u0003\u0001\u0011\t9AA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\n\u0005\u0003\u0007\tI\u0001E\u0002!\u0003\u0017I1!!\u0004\"\u0005\u0019\te.\u001f*fM\"9\u0011,a\u0001\u0005\u0002\u0005EA#A@\t\u0019\u0005U\u00111\u0001a\u0001\u0002\u0004%I!a\u0006\u0002!5,G/\u00193bi\u0006\u001cF/\u0019;vg\u0016\u001cXCAA\r!\u0011\u00013%a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005\u0011am\u001d\u0006\u0004\u0003Ka\u0011A\u00025bI>|\u0007/\u0003\u0003\u0002*\u0005}!A\u0003$jY\u0016\u001cF/\u0019;vg\"a\u0011QFA\u0002\u0001\u0004\u0005\r\u0011\"\u0003\u00020\u0005!R.\u001a;bI\u0006$\u0018m\u0015;biV\u001cXm]0%KF$B!!\r\u00028A\u0019\u0001%a\r\n\u0007\u0005U\u0012E\u0001\u0003V]&$\bBCA\u001d\u0003W\t\t\u00111\u0001\u0002\u001a\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005u\u00121\u0001Q!\n\u0005e\u0011!E7fi\u0006$\u0017\r^1Ti\u0006$Xo]3tA!a\u0011\u0011IA\u0002\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\u000512m\\7n_:lU\r^1eCR\f7\u000b^1ukN,7\u000f\u0003\u0007\u0002F\u0005\r\u0001\u0019!a\u0001\n\u0013\t9%\u0001\u000ed_6lwN\\'fi\u0006$\u0017\r^1Ti\u0006$Xo]3t?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005%\u0003BCA\u001d\u0003\u0007\n\t\u00111\u0001\u0002\u001a!I\u0011QJA\u0002A\u0003&\u0011\u0011D\u0001\u0018G>lWn\u001c8NKR\fG-\u0019;b'R\fG/^:fg\u0002BA\"!\u0015\u0002\u0004\u0001\u0007\t\u0019!C\u0001\u0003/\tA\u0002Z1uCN#\u0018\r^;tKNDA\"!\u0016\u0002\u0004\u0001\u0007\t\u0019!C\u0001\u0003/\n\u0001\u0003Z1uCN#\u0018\r^;tKN|F%Z9\u0015\t\u0005E\u0012\u0011\f\u0005\u000b\u0003s\t\u0019&!AA\u0002\u0005e\u0001\"CA/\u0003\u0007\u0001\u000b\u0015BA\r\u00035!\u0017\r^1Ti\u0006$Xo]3tA!Q\u0011\u0011MA\u0002\u0001\u0004%\t!a\u0019\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-F\u00015\u0011)\t9'a\u0001A\u0002\u0013\u0005\u0011\u0011N\u0001\u000fI\u0006$\u0018mU2iK6\fw\fJ3r)\u0011\t\t$a\u001b\t\u0013\u0005e\u0012QMA\u0001\u0002\u0004!\u0004\u0002CA8\u0003\u0007\u0001\u000b\u0015\u0002\u001b\u0002\u0017\u0011\fG/Y*dQ\u0016l\u0017\r\t\u0005\r\u0003g\n\u0019\u00011AA\u0002\u0013\u0005\u00111M\u0001\u0007g\u000eDW-\\1\t\u0019\u0005]\u00141\u0001a\u0001\u0002\u0004%\t!!\u001f\u0002\u0015M\u001c\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005m\u0004\"CA\u001d\u0003k\n\t\u00111\u00015\u0011!\ty(a\u0001!B\u0013!\u0014aB:dQ\u0016l\u0017\r\t\u0005\u000b\u0003\u0007\u000b\u0019\u00011A\u0005\u0002\u0005\u0015\u0015\u0001D2bG\",G\rT3bm\u0016\u001cXCAAD!\u00151\u0013\u0011RA\u000e\u0013\r\tYi\u000b\u0002\u0004'\u0016$\bBCAH\u0003\u0007\u0001\r\u0011\"\u0001\u0002\u0012\u0006\u00012-Y2iK\u0012dU-\u0019<fg~#S-\u001d\u000b\u0005\u0003c\t\u0019\n\u0003\u0006\u0002:\u00055\u0015\u0011!a\u0001\u0003\u000fC\u0011\"a&\u0002\u0004\u0001\u0006K!a\"\u0002\u001b\r\f7\r[3e\u0019\u0016\fg/Z:!\u0011!\tY*a\u0001\u0005\u0002\u0005u\u0015a\u0002:fMJ,7\u000f\u001b\u000b\u0003\u0003cA\u0001\"!)\u0002\u0004\u0011%\u00111U\u0001\u000eSN\u001cV/\\7bef4\u0015\u000e\\3\u0015\u0007=\f)\u000b\u0003\u0005\u0002(\u0006}\u0005\u0019AAU\u0003\u00111\u0017\u000e\\3\u0011\t\u0005u\u00111V\u0005\u0005\u0003[\u000byB\u0001\u0003QCRD\u0007\u0002CAY\u0003\u0007!I!a-\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\rF\u00012\u0011%\t9\f\u0001E\u0001B\u0003&q0\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\u00061Q-];bYN$2a\\A`\u0011!\t\t-!/A\u0002\u0005\r\u0017!B8uQ\u0016\u0014\bc\u0001\u0011\u0002F&\u0019\u0011qY\u0011\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002L\u0002!\t%!4\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a4\u0011\u0007\u0001\n\t.C\u0002\u0002T\u0006\u00121!\u00138u\u0011\u001d\t9\u000e\u0001C\u0005\u00033\f\u0001c\u00195fG.\u001cuN\\:ue\u0006Lg\u000e^:\u0015\t\u0005E\u00121\u001c\u0005\b\u0003g\n)\u000e1\u00015\u0011\u001d\t\t\u0007\u0001C!\u0003GB\u0001\"a'\u0001\t\u0003B\u0011Q\u0014\u0005\t\u0003G\u0004!\u0019!C!]\u0006qa.Z3e\u0007>tg/\u001a:tS>t\u0007bBAt\u0001\u0001\u0006Ia\\\u0001\u0010]\u0016,GmQ8om\u0016\u00148/[8oA!9\u00111\u001e\u0001\u0005B\u00055\u0018aC:ju\u0016LeNQ=uKN,\"!a<\u0011\u0007\u0001\n\t0C\u0002\u0002t\u0006\u0012A\u0001T8oO\"9\u0011q\u001f\u0001\u0005B\u0005e\u0018A\u00059sKB\f'/\u001a&pE\u001a{'o\u0016:ji\u0016$B!a?\u0003\u0002A\u0019!#!@\n\u0007\u0005}8CA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010\u0003\u0005\u0003\u0004\u0005U\b\u0019\u0001B\u0003\u0003\rQwN\u0019\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)!!1BA\u0012\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0003\u0003\u0010\t%!a\u0001&pE\"9!1\u0003\u0001\u0005B\tU\u0011!\u00032vS2$7kY1o))\u00119B!\u000b\u0003.\te\"Q\b\t\u0007\u00053\u0011yBa\t\u000e\u0005\tm!b\u0001B\u000f\u0015\u0005\u0019!\u000f\u001a3\n\t\t\u0005\"1\u0004\u0002\u0004%\u0012#\u0005cA*\u0003&%\u0019!q\u0005\u0005\u0003\u0007I{w\u000fC\u0004\u0003,\tE\u0001\u0019A\u0010\u0002\u001fI,\u0017/^5sK\u0012\u001cu\u000e\\;n]ND\u0001Ba\f\u0003\u0012\u0001\u0007!\u0011G\u0001\bM&dG/\u001a:t!\u0011\u00013Ea\r\u0011\u0007I\u0011)$C\u0002\u00038M\u0011aAR5mi\u0016\u0014\b\u0002\u0003B\u001e\u0005#\u0001\r!!\u0007\u0002\u0015%t\u0007/\u001e;GS2,7\u000f\u0003\u0005\u0003@\tE\u0001\u0019\u0001B!\u0003=\u0011'o\\1eG\u0006\u001cH/\u001a3D_:4\u0007C\u0002B\"\u0005\u0013\u0012i%\u0004\u0002\u0003F)\u0019!q\t\u0006\u0002\u0013\t\u0014x.\u00193dCN$\u0018\u0002\u0002B&\u0005\u000b\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\t\t=#QK\u0007\u0003\u0005#R1Aa\u0015\u000b\u0003\u0011)H/\u001b7\n\t\t]#\u0011\u000b\u0002\u001a'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|gn\u0002\u0005\u0003\\\tA\t\u0001\u0003B/\u0003=\u0001\u0016M]9vKR\u0014V\r\\1uS>t\u0007cA/\u0003`\u00199\u0011A\u0001E\u0001\u0011\t\u00054#\u0002B0\u0003\u00139\u0002bB-\u0003`\u0011\u0005!Q\r\u000b\u0003\u0005;B1B!\u001b\u0003`\t\u0007I\u0011\u0001\u0005\u0003l\u0005aQ*\u0012*H\u000b~\u001b6\tS#N\u0003V\u0011!Q\u000e\t\u0005\u0005_\u0012I(\u0004\u0002\u0003r)!!1\u000fB;\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0014\u0001\u00026bm\u0006L1A\u000bB9\u0011%\u0011iHa\u0018!\u0002\u0013\u0011i'A\u0007N\u000bJ;UiX*D\u0011\u0016k\u0015\t\t\u0005\f\u0005\u0003\u0013yF1A\u0005\u0002!\u0011Y'\u0001\tN\u000bR\u000b5\u000bV(S\u000b~\u001b6\tS#N\u0003\"I!Q\u0011B0A\u0003%!QN\u0001\u0012\u001b\u0016#\u0016i\u0015+P%\u0016{6k\u0011%F\u001b\u0006\u0003\u0003\u0002\u0003BE\u0005?\"IAa#\u0002)=4XM\u001d:jI\u0016l\u0015N\\*qY&$8+\u001b>f)\u0019\t\tD!$\u0003\u0012\"A!q\u0012BD\u0001\u0004\ty/\u0001\tqCJ\fX/\u001a;CY>\u001c7nU5{K\"A!1\u0013BD\u0001\u0004\u0011)*\u0001\u0003d_:4\u0007\u0003\u0002BL\u00057k!A!'\u000b\t\tM\u00151E\u0005\u0005\u0005;\u0013IJA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\n\u0005C\u0013y\u0006\"\u0001\u0003\u0005G\u000ba#\u001b8ji&\fG.\u001b>f\u0019>\u001c\u0017\r\u001c&pE\u001a+hn\u0019\u000b\u0015\u0005K\u0013IKa+\u0003.\n=&\u0011\u0017B[\u0005s\u0013iL!1\u0015\t\u0005E\"q\u0015\u0005\t\u0005\u0007\u0011y\n1\u0001\u0003\u0006!9!1\u0006BP\u0001\u0004y\u0002\u0002\u0003B\u0018\u0005?\u0003\rA!\r\t\u000f\u0005\u0005$q\u0014a\u0001i!A!q\u0012BP\u0001\u0004\ty\u000fC\u0004\u00034\n}\u0005\u0019A8\u0002!U\u001cX-T3uC\u0012\fG/Y\"bG\",\u0007b\u0002B\\\u0005?\u0003\ra\\\u0001\u0016a\u0006\u0014\u0018/^3u\r&dG/\u001a:QkNDGi\\<o\u0011\u001d\u0011YLa(A\u0002=\fA#Y:tk6,')\u001b8befL5o\u0015;sS:<\u0007b\u0002B`\u0005?\u0003\ra\\\u0001\u0017CN\u001cX/\\3J]RLd'S:US6,7\u000f^1na\"9!1\u0019BP\u0001\u0004y\u0017a\u00064pY2|w\u000fU1scV,GOR8s[\u0006$8\u000b]3d\u0011%\u00119Ma\u0018\u0005\u0002\t\u0011I-A\u000ej]&$\u0018.\u00197ju\u0016$%/\u001b<feNKG-\u001a&pE\u001a+hn\u0019\u000b\u0007\u0005\u0017\u0014yM!5\u0015\t\u0005E\"Q\u001a\u0005\t\u0005\u0007\u0011)\r1\u0001\u0003\u0006!A!1\bBc\u0001\u0004\tI\u0002\u0003\u0005\u0003\u0010\n\u0015\u0007\u0019AAx\u0011%\t\tLa\u0018\u0005\u0002\t\u0011)\u000eF\u00032\u0005/\u0014y\u0010\u0003\u0005\u0003Z\nM\u0007\u0019\u0001Bn\u0003\u001d1wn\u001c;feN\u0004bA!8\u0003n\nMh\u0002\u0002Bp\u0005StAA!9\u0003h6\u0011!1\u001d\u0006\u0004\u0005Kl\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\r\u0011Y/I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yO!=\u0003\u0007M+\u0017OC\u0002\u0003l\u0006\u0002BA!>\u0003|6\u0011!q\u001f\u0006\u0005\u0003K\u0011IP\u0003\u0002\u0004\u0019%!!Q B|\u0005\u00191un\u001c;fe\"1\u0001Ka5A\u0002IC\u0011ba\u0001\u0003`\u0011\u0005!a!\u0002\u000275,'oZ3NKR\f7\u000f^8sKB\u000b'/];fiN\u001b\u0007.Z7b)\u0015!4qAB\u0006\u0011\u001d\u0019Ia!\u0001A\u0002Q\nq\"\\3uCN$xN]3TG\",W.\u0019\u0005\b\u0007\u001b\u0019\t\u00011\u00015\u00035\u0001\u0018M]9vKR\u001c6\r[3nC\"I1\u0011\u0003B0\t\u0003\u001111C\u0001\u001b[\u0016\u0014x-Z'jgNLgn\u001a(vY2\f'\r\\3GS\u0016dGm\u001d\u000b\u0006i\rU1q\u0003\u0005\b\u0007\u0013\u0019y\u00011\u00015\u0011\u001d\u0019iaa\u0004A\u0002QB\u0001ba\u0007\u0003`\u0011\u00051QD\u0001\u0017[\u0016\u0014x-Z*dQ\u0016l\u0017m]%o!\u0006\u0014\u0018\r\u001c7fYR)\u0011ga\b\u0004&!A1\u0011EB\r\u0001\u0004\u0019\u0019#\u0001\u0007gS2,7\u000fV8U_V\u001c\u0007\u000e\u0005\u0004\u0003^\n5\u00181\u0004\u0005\u0007!\u000ee\u0001\u0019\u0001*\t\u0011\r%\"q\fC\u0001\u0007W\tAC]3bIN\u001b\u0007.Z7b\rJ|WNR8pi\u0016\u0014H#\u0002\u001b\u0004.\rE\u0002\u0002CB\u0018\u0007O\u0001\rAa=\u0002\r\u0019|w\u000e^3s\u0011!\u0019\u0019da\nA\u0002\rU\u0012!C2p]Z,'\u000f^3s!\ri6qG\u0005\u0004\u0007s\u0011!aF\"bi\u0006d\u0017p\u001d;TG\",W.Y\"p]Z,'\u000f^3s\u0011!\u0019iDa\u0018\u0005\n\r}\u0012a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u001c6\r[3nCN#(/\u001b8h)\r\t4\u0011\t\u0005\b\u0007\u0007\u001aY\u00041\u0001&\u00031\u00198\r[3nCN#(/\u001b8h\u0011)\u00199Ea\u0018C\u0002\u0013\u00051\u0011J\u0001\u0014CB\f7\r[3QCJ\fX/\u001a;M_\u001e<WM]\u000b\u0003\u0007\u0017\u0002Ba!\u0014\u0004V5\u00111q\n\u0006\u0005\u0007#\u001a\u0019&A\u0004m_\u001e<\u0017N\\4\u000b\t\tM#QO\u0005\u0005\u0007/\u001ayE\u0001\u0004M_\u001e<WM\u001d\u0005\n\u00077\u0012y\u0006)A\u0005\u0007\u0017\nA#\u00199bG\",\u0007+\u0019:rk\u0016$Hj\\4hKJ\u0004\u0003BCB0\u0005?\u0012\r\u0011\"\u0001\u0004J\u0005i\u0001/\u0019:rk\u0016$Hj\\4hKJD\u0011ba\u0019\u0003`\u0001\u0006Iaa\u0013\u0002\u001dA\f'/];fi2{wmZ3sA!Q1q\rB0\u0005\u0004%\ta!\u001b\u00027I,G-\u001b:fGR\u0004\u0016M]9vKRdunZ:WS\u0006\u001cFJ\u0012\u001bK+\t\t\t\u0004C\u0005\u0004n\t}\u0003\u0015!\u0003\u00022\u0005a\"/\u001a3je\u0016\u001cG\u000fU1scV,G\u000fT8hgZK\u0017m\u0015'Gi)\u0003\u0003BCB9\u0005?\u0012\r\u0011\"\u0001\u0004t\u0005\t3\u000f[8siB\u000b'/];fi\u000e{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cg*Y7fgV\u00111Q\u000f\t\t\u0007o\u001a\tI!\u001c\u0004\u00046\u00111\u0011\u0010\u0006\u0005\u0007w\u001ai(A\u0005j[6,H/\u00192mK*\u00191qP\u0011\u0002\u0015\r|G\u000e\\3di&|g.C\u0002O\u0007s\u0002Ba!\"\u0004\f6\u00111q\u0011\u0006\u0005\u0007\u0013\u001390\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0019iia\"\u0003)\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cg*Y7f\u0011%\u0019\tJa\u0018!\u0002\u0013\u0019)(\u0001\u0012tQ>\u0014H\u000fU1scV,GoQ8naJ,7o]5p]\u000e{G-Z2OC6,7\u000f\t")
public class ParquetRelation
extends HadoopFsRelation {
    private final String[] paths;
    private final Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema;
    private final Option<PartitionSpec> maybePartitionSpec;
    private final Option<StructType> userDefinedPartitionColumns;
    private final SQLContext sqlContext;
    private final boolean org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas;
    private final boolean org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$mergeRespectSummaries;
    private final Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema;
    private MetadataCache org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache;
    private final boolean needConversion;
    private volatile boolean bitmap$0;

    public static Map<String, CompressionCodecName> shortParquetCompressionCodecNames() {
        return ParquetRelation$.MODULE$.shortParquetCompressionCodecNames();
    }

    public static void redirectParquetLogsViaSLF4J() {
        ParquetRelation$.MODULE$.redirectParquetLogsViaSLF4J();
    }

    public static Logger parquetLogger() {
        return ParquetRelation$.MODULE$.parquetLogger();
    }

    public static Logger apacheParquetLogger() {
        return ParquetRelation$.MODULE$.apacheParquetLogger();
    }

    public static StructType readSchemaFromFooter(Footer footer, CatalystSchemaConverter catalystSchemaConverter) {
        return ParquetRelation$.MODULE$.readSchemaFromFooter(footer, catalystSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SQLContext sQLContext) {
        return ParquetRelation$.MODULE$.mergeSchemasInParallel(seq, sQLContext);
    }

    /*
     * WARNING - void declaration
     */
    private MetadataCache org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache$lzycompute() {
        ParquetRelation parquetRelation = this;
        synchronized (parquetRelation) {
            if (!this.bitmap$0) {
                void var2_2;
                MetadataCache meta = new MetadataCache();
                meta.refresh();
                this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache = var2_2;
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache;
        }
    }

    @Override
    public String[] paths() {
        return this.paths;
    }

    public Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema() {
        return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema;
    }

    private Option<PartitionSpec> maybePartitionSpec() {
        return this.maybePartitionSpec;
    }

    @Override
    public Option<StructType> userDefinedPartitionColumns() {
        return this.userDefinedPartitionColumns;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas() {
        return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas;
    }

    public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$mergeRespectSummaries() {
        return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$mergeRespectSummaries;
    }

    public Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema() {
        return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema;
    }

    public MetadataCache org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache() {
        return this.bitmap$0 ? this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache : this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache$lzycompute();
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object other) {
        block7: {
            block4: {
                block6: {
                    block5: {
                        var2_2 = other;
                        if (!(var2_2 instanceof ParquetRelation)) break block4;
                        var3_3 = (ParquetRelation)var2_2;
                        if (!this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas()) break block5;
                        v0 = this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas() == var3_3.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas();
                        break block6;
                    }
                    v1 = this.dataSchema();
                    var4_4 = var3_3.dataSchema();
                    if (v1 != null ? v1.equals(var4_4) == false : var4_4 != null) ** GOTO lbl-1000
                    v2 = this.schema();
                    var5_5 = var3_3.schema();
                    if (!(v2 != null ? v2.equals(var5_5) == false : var5_5 != null)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                schemaEquality = v0;
                v3 = Predef$.MODULE$.refArrayOps((Object[])this.paths()).toSet();
                var7_7 = Predef$.MODULE$.refArrayOps((Object[])var3_3.paths()).toSet();
                if ((v3 != null ? v3.equals(var7_7) == false : var7_7 != null) || !schemaEquality) ** GOTO lbl-1000
                v4 = this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema();
                var8_8 = var3_3.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema();
                if (v4 != null ? v4.equals(var8_8) == false : var8_8 != null) ** GOTO lbl-1000
                v5 = this.partitionColumns();
                var9_9 = var3_3.partitionColumns();
                if (!(v5 != null ? v5.equals(var9_9) == false : var9_9 != null)) {
                    v6 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v6 = false;
                }
                var10_10 = v6;
                break block7;
            }
            var10_10 = false;
        }
        return var10_10;
    }

    public int hashCode() {
        return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas() ? Objects.hashCode((Object[])new Object[]{BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas()), Predef$.MODULE$.refArrayOps((Object[])this.paths()).toSet(), this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema(), this.partitionColumns()}) : Objects.hashCode((Object[])new Object[]{BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas()), Predef$.MODULE$.refArrayOps((Object[])this.paths()).toSet(), this.dataSchema(), this.schema(), this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema(), this.partitionColumns()});
    }

    private void checkConstraints(StructType schema2) {
        if (schema2.fieldNames().length != ((String[])Predef$.MODULE$.refArrayOps((Object[])schema2.fieldNames()).distinct()).length) {
            String duplicateColumns = ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])schema2.fieldNames()).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).collect((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, String[]>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        String[] ys = (String[])A1._2();
                        if (ys.length > 1) {
                            object = new StringBuilder().append((Object)"\"").append((Object)x).append((Object)"\"").toString();
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String[]> x1) {
                    String[] ys;
                    Tuple2<String, String[]> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (String[])tuple2._2()).length > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate column(s) : ", " found, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateColumns}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot save to parquet format"})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType dataSchema() {
        void var1_1;
        StructType schema2 = (StructType)this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetRelation $outer;

            public final StructType apply() {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache().dataSchema();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.checkConstraints(schema2);
        return var1_1;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache().refresh();
    }

    @Override
    public boolean needConversion() {
        return this.needConversion;
    }

    @Override
    public long sizeInBytes() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$metadataCache().dataStatuses()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(FileStatus x$4) {
                return x$4.getLen();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareJobForWrite(Job job) {
        String committerClassname;
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        String string = committerClassname = conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key());
        String string2 = "org.apache.spark.sql.parquet.DirectParquetOutputCommitter";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), DirectParquetOutputCommitter.class.getCanonicalName());
        }
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, ParquetOutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using default output committer for Parquet: ").append((Object)ParquetOutputCommitter.class.getCanonicalName()).toString();
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using user defined output committer for Parquet: ").append((Object)this.committerClass$1.getCanonicalName()).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, ParquetOutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        Class writeSupportClass = ((IterableLike)this.dataSchema().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$5) {
                return x$5.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType ctype) {
                return ParquetTypesConverter$.MODULE$.isPrimitiveType(ctype);
            }
        }) ? MutableRowWriteSupport.class : RowWriteSupport.class;
        ParquetOutputFormat.setWriteSupportClass((Job)job, writeSupportClass);
        RowWriteSupport$.MODULE$.setSchema((Seq<Attribute>)this.dataSchema().toAttributes(), conf);
        conf.set("parquet.compression", ((Enum)ParquetRelation$.MODULE$.shortParquetCompressionCodecNames().getOrElse((Object)this.sqlContext().conf().parquetCompressionCodec().toUpperCase(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CompressionCodecName apply() {
                return CompressionCodecName.UNCOMPRESSED;
            }
        })).name());
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }
        };
    }

    @Override
    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters, FileStatus[] inputFiles2, Broadcast<SerializableConfiguration> broadcastedConf) {
        boolean useMetadataCache = BoxesRunTime.unboxToBoolean((Object)this.sqlContext().getConf(SQLConf$.MODULE$.PARQUET_CACHE_METADATA()));
        boolean parquetFilterPushDown = this.sqlContext().conf().parquetFilterPushDown();
        boolean assumeBinaryIsString = this.sqlContext().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = this.sqlContext().conf().isParquetINT96AsTimestamp();
        boolean followParquetFormatSpec = this.sqlContext().conf().followParquetFormatSpec();
        long parquetBlockSize = ParquetOutputFormat.getLongBlockSize((Configuration)((SerializableConfiguration)broadcastedConf.value()).value());
        StructType structType = this.dataSchema();
        Serializable initLocalJobFuncOpt = new Serializable(this, requiredColumns, filters, useMetadataCache, parquetFilterPushDown, assumeBinaryIsString, assumeInt96IsTimestamp, followParquetFormatSpec, parquetBlockSize, structType){
            public static final long serialVersionUID = 0L;
            private final String[] requiredColumns$1;
            private final Filter[] filters$1;
            private final boolean useMetadataCache$1;
            private final boolean parquetFilterPushDown$1;
            private final boolean assumeBinaryIsString$1;
            private final boolean assumeInt96IsTimestamp$1;
            private final boolean followParquetFormatSpec$1;
            private final long parquetBlockSize$1;
            private final StructType eta$0$1$1;

            public final void apply(Job job) {
                ParquetRelation$.MODULE$.initializeLocalJobFunc(this.requiredColumns$1, this.filters$1, this.eta$0$1$1, this.parquetBlockSize$1, this.useMetadataCache$1, this.parquetFilterPushDown$1, this.assumeBinaryIsString$1, this.assumeInt96IsTimestamp$1, this.followParquetFormatSpec$1, job);
            }
            {
                this.requiredColumns$1 = requiredColumns$1;
                this.filters$1 = filters$1;
                this.useMetadataCache$1 = useMetadataCache$1;
                this.parquetFilterPushDown$1 = parquetFilterPushDown$1;
                this.assumeBinaryIsString$1 = assumeBinaryIsString$1;
                this.assumeInt96IsTimestamp$1 = assumeInt96IsTimestamp$1;
                this.followParquetFormatSpec$1 = followParquetFormatSpec$1;
                this.parquetBlockSize$1 = parquetBlockSize$1;
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
        Serializable setInputPaths = new Serializable(this, inputFiles2, parquetBlockSize){
            public static final long serialVersionUID = 0L;
            private final FileStatus[] inputFiles$1;
            private final long parquetBlockSize$1;

            public final void apply(Job job) {
                ParquetRelation$.MODULE$.initializeDriverSideJobFunc(this.inputFiles$1, this.parquetBlockSize$1, job);
            }
            {
                this.inputFiles$1 = inputFiles$1;
                this.parquetBlockSize$1 = parquetBlockSize$1;
            }
        };
        return (RDD)Utils$.MODULE$.withDummyCallSite(this.sqlContext().sparkContext(), (Function0)new Serializable(this, inputFiles2, broadcastedConf, useMetadataCache, (Function1)initLocalJobFuncOpt, (Function1)setInputPaths){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetRelation $outer;
            public final FileStatus[] inputFiles$1;
            public final Broadcast broadcastedConf$1;
            public final boolean useMetadataCache$1;
            public final Function1 initLocalJobFuncOpt$1;
            public final Function1 setInputPaths$1;

            public final RDD<Row> apply() {
                return new SqlNewHadoopRDD<InternalRow>(this){
                    private final boolean cacheMetadata;
                    private final transient Seq<FileStatus> cachedStatuses;

                    public boolean cacheMetadata() {
                        return this.cacheMetadata;
                    }

                    public Seq<FileStatus> cachedStatuses() {
                        return this.cachedStatuses;
                    }

                    public Path org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$anonfun$$anon$$escapePathUserInfo(Path path) {
                        URI uri = path.toUri();
                        return new Path(new URI(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
                    }

                    public Partition[] getPartitions() {
                        ParquetInputFormat<InternalRow> inputFormat = new ParquetInputFormat<InternalRow>(this){
                            private final /* synthetic */ $anonfun$buildScan$1$$anon$1 $outer;

                            public List<FileStatus> listStatus(JobContext jobContext) {
                                return this.$outer.cacheMetadata() ? JavaConversions$.MODULE$.seqAsJavaList(this.$outer.cachedStatuses()) : super.listStatus(jobContext);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        };
                        JobContext jobContext = this.newJobContext(this.getConf(true), this.jobId());
                        List rawSplits = inputFormat.getSplits(jobContext);
                        return (Partition[])Array$.MODULE$.tabulate(rawSplits.size(), (Function1)new Serializable(this, rawSplits){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildScan$1$$anon$1 $outer;
                            private final List rawSplits$1;

                            public final SqlNewHadoopPartition apply(int i) {
                                return new SqlNewHadoopPartition(this.$outer.id(), i, (InputSplit)JavaConversions$.MODULE$.asScalaBuffer(this.rawSplits$1).apply(i));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.rawSplits$1 = rawSplits$1;
                            }
                        }, ClassTag$.MODULE$.apply(Partition.class));
                    }
                    {
                        super($outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$anonfun$$$outer().sqlContext().sparkContext(), $outer.broadcastedConf$1, (Option)new Some((Object)$outer.setInputPaths$1), (Option)new Some((Object)$outer.initLocalJobFuncOpt$1), ParquetInputFormat.class, InternalRow.class, ClassTag$.MODULE$.apply(InternalRow.class));
                        this.cacheMetadata = $outer.useMetadataCache$1;
                        this.cachedStatuses = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$outer.inputFiles$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildScan$1$$anon$1 $outer;

                            public final FileStatus apply(FileStatus f) {
                                Path pathWithEscapedAuthority = this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$anonfun$$anon$$escapePathUserInfo(f.getPath());
                                return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), pathWithEscapedAuthority);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))).toSeq();
                    }
                };
            }

            public /* synthetic */ ParquetRelation org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.inputFiles$1 = inputFiles$1;
                this.broadcastedConf$1 = broadcastedConf$1;
                this.useMetadataCache$1 = useMetadataCache$1;
                this.initLocalJobFuncOpt$1 = initLocalJobFuncOpt$1;
                this.setInputPaths$1 = setInputPaths$1;
            }
        });
    }

    public ParquetRelation(String[] paths, Option<StructType> maybeDataSchema, Option<PartitionSpec> maybePartitionSpec, Option<StructType> userDefinedPartitionColumns, Map<String, String> parameters, SQLContext sqlContext) {
        this.paths = paths;
        this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema = maybeDataSchema;
        this.maybePartitionSpec = maybePartitionSpec;
        this.userDefinedPartitionColumns = userDefinedPartitionColumns;
        this.sqlContext = sqlContext;
        super(maybePartitionSpec);
        this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)ParquetRelation$.MODULE$.MERGE_SCHEMA()).map((Function1)new $anonfun$3(this)).getOrElse((Function0)new $anonfun$1(this)));
        this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$mergeRespectSummaries = BoxesRunTime.unboxToBoolean((Object)sqlContext.conf().getConf(SQLConf$.MODULE$.PARQUET_SCHEMA_RESPECT_SUMMARIES()));
        this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema = parameters.get((Object)ParquetRelation$.MODULE$.METASTORE_SCHEMA()).map((Function1)new $anonfun$4(this));
        this.needConversion = false;
    }

    public ParquetRelation(String[] paths, Option<StructType> maybeDataSchema, Option<PartitionSpec> maybePartitionSpec, Map<String, String> parameters, SQLContext sqlContext) {
        this(paths, maybeDataSchema, maybePartitionSpec, (Option<StructType>)maybePartitionSpec.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(PartitionSpec x$1) {
                return x$1.partitionColumns();
            }
        }), parameters, sqlContext);
    }

    public class MetadataCache {
        private FileStatus[] org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses;
        private FileStatus[] commonMetadataStatuses;
        private FileStatus[] dataStatuses;
        private StructType dataSchema;
        private StructType schema;
        private Set<FileStatus> cachedLeaves;

        public FileStatus[] org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses() {
            return this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses;
        }

        private void org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses_$eq(FileStatus[] x$1) {
            this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses = x$1;
        }

        private FileStatus[] commonMetadataStatuses() {
            return this.commonMetadataStatuses;
        }

        private void commonMetadataStatuses_$eq(FileStatus[] x$1) {
            this.commonMetadataStatuses = x$1;
        }

        public FileStatus[] dataStatuses() {
            return this.dataStatuses;
        }

        public void dataStatuses_$eq(FileStatus[] x$1) {
            this.dataStatuses = x$1;
        }

        public StructType dataSchema() {
            return this.dataSchema;
        }

        public void dataSchema_$eq(StructType x$1) {
            this.dataSchema = x$1;
        }

        public StructType schema() {
            return this.schema;
        }

        public void schema_$eq(StructType x$1) {
            this.schema = x$1;
        }

        public Set<FileStatus> cachedLeaves() {
            return this.cachedLeaves;
        }

        public void cachedLeaves_$eq(Set<FileStatus> x$1) {
            this.cachedLeaves = x$1;
        }

        public void refresh() {
            boolean leafStatusesChanged;
            Set<FileStatus> currentLeafStatuses = this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().cachedLeafStatuses();
            boolean bl = leafStatusesChanged = this.cachedLeaves() == null || !this.cachedLeaves().equals(currentLeafStatuses);
            if (leafStatusesChanged) {
                this.cachedLeaves_$eq((Set<FileStatus>)currentLeafStatuses.toIterator().toSet());
                FileStatus[] leaves = (FileStatus[])((TraversableOnce)currentLeafStatuses.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final boolean apply(FileStatus f) {
                        return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$isSummaryFile(f.getPath()) || !f.getPath().getName().startsWith("_") && !f.getPath().getName().startsWith(".");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
                this.dataStatuses_$eq((FileStatus[])Predef$.MODULE$.refArrayOps((Object[])leaves).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final boolean apply(FileStatus f) {
                        return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$isSummaryFile(f.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses_$eq((FileStatus[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$6) {
                        String string = x$6.getPath().getName();
                        String string2 = "_metadata";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                }));
                this.commonMetadataStatuses_$eq((FileStatus[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$7) {
                        String string = x$7.getPath().getName();
                        String string2 = "_common_metadata";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                }));
                StructType dataSchema0 = (StructType)this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema().orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final Option<StructType> apply() {
                        return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$readSchema();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final Option<StructType> apply() {
                        return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final Nothing$ apply() {
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to discover schema of Parquet file(s) in the following location(s):\\n"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().paths()).mkString("\n\t")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.dataSchema_$eq((StructType)this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema().map((Function1)new Serializable(this, dataSchema0){
                    public static final long serialVersionUID = 0L;
                    private final StructType dataSchema0$1;

                    public final StructType apply(StructType x$8) {
                        return ParquetRelation$.MODULE$.mergeMetastoreParquetSchema(x$8, this.dataSchema0$1);
                    }
                    {
                        this.dataSchema0$1 = dataSchema0$1;
                    }
                }).getOrElse((Function0)new Serializable(this, dataSchema0){
                    public static final long serialVersionUID = 0L;
                    private final StructType dataSchema0$1;

                    public final StructType apply() {
                        return this.dataSchema0$1;
                    }
                    {
                        this.dataSchema0$1 = dataSchema0$1;
                    }
                }));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$isSummaryFile(Path file) {
            String string = file.getName();
            String string2 = "_common_metadata";
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = file.getName();
            String string4 = "_metadata";
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        }

        public Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$readSchema() {
            Seq seq;
            if (this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$shouldMergeSchemas()) {
                Seq needMerged = this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$mergeRespectSummaries() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : Predef$.MODULE$.wrapRefArray((Object[])this.dataStatuses());
                seq = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.commonMetadataStatuses()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))).$plus$plus((GenTraversableOnce)needMerged, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))).toSeq();
            } else {
                seq = Option$.MODULE$.option2Iterable(Predef$.MODULE$.refArrayOps((Object[])this.commonMetadataStatuses()).headOption().orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final Option<FileStatus> apply() {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$metadataStatuses()).headOption();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataCache $outer;

                    public final Option<FileStatus> apply() {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.dataStatuses()).headOption();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).toSeq();
            }
            Seq filesToTouch = seq;
            Predef$.MODULE$.assert(filesToTouch.nonEmpty() || this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeDataSchema().isDefined() || this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$$maybeMetastoreSchema().isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MetadataCache $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"No predefined schema found, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and no Parquet data files or summary files found under ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().paths()).mkString(", ")}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return ParquetRelation$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, this.org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer().sqlContext());
        }

        public /* synthetic */ ParquetRelation org$apache$spark$sql$execution$datasources$parquet$ParquetRelation$MetadataCache$$$outer() {
            return ParquetRelation.this;
        }

        public MetadataCache() {
            if (ParquetRelation.this == null) {
                throw new NullPointerException();
            }
            this.dataSchema = null;
            this.cachedLeaves = null;
        }
    }
}

