/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$ReceiverState$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\tMcAB\u0001\u0003\u0003\u0003!AB\u0001\nSK\u000e,\u0017N^3s'V\u0004XM\u001d<jg>\u0014(BA\u0002\u0005\u0003!\u0011XmY3jm\u0016\u0014(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q)R\"\u0001\u0004\n\u0005Y1!a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u00053\r\u0001\u0001G\u0001\u000e!!\rYBDH\u0007\u0002\u0005%\u0011QD\u0001\u0002\t%\u0016\u001cW-\u001b<feB\u0011q\u0004\t\u0007\u0001\t%\ts#!A\u0001\u0002\u000b\u0005!EA\u0002`IE\n\"a\t\u0014\u0011\u00059!\u0013BA\u0013\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0014\n\u0005!z!aA!os\"A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0003d_:4\u0007C\u0001\u000b-\u0013\ticAA\u0005Ta\u0006\u00148nQ8oM\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"2!\r\u001a8!\tY\u0002\u0001C\u0003\u0004]\u0001\u00071\u0007\r\u00025mA\u00191\u0004H\u001b\u0011\u0005}1D!C\u00113\u0003\u0003\u0005\tQ!\u0001#\u0011\u0015Qc\u00061\u0001,\u000f\u0015I\u0004\u0001#\u0001;\u00035\u0011VmY3jm\u0016\u00148\u000b^1uKB\u00111\bP\u0007\u0002\u0001\u0019)Q\b\u0001E\u0001}\ti!+Z2fSZ,'o\u0015;bi\u0016\u001c\"\u0001P \u0011\u00059\u0001\u0015BA!\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b=bD\u0011A\"\u0015\u0003i*A!\u0012\u001f\u0001\r\ny1\t[3dWB|\u0017N\u001c;Ti\u0006$X\r\u0005\u0002H\u00116\tA(\u0003\u0002J\u0001\n)a+\u00197vK\"91\n\u0010b\u0001\n\u0003a\u0015aC%oSRL\u0017\r\\5{K\u0012,\u0012A\u0012\u0005\u0007\u001dr\u0002\u000b\u0011\u0002$\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u000fAc$\u0019!C\u0001\u0019\u000691\u000b^1si\u0016$\u0007B\u0002*=A\u0003%a)\u0001\u0005Ti\u0006\u0014H/\u001a3!\u0011\u001d!FH1A\u0005\u00021\u000bqa\u0015;paB,G\r\u0003\u0004Wy\u0001\u0006IAR\u0001\t'R|\u0007\u000f]3eA!9\u0001\f\u0001b\u0001\n#I\u0016\u0001C:ue\u0016\fW.\u00133\u0016\u0003i\u0003\"AD.\n\u0005q{!aA%oi\"1a\f\u0001Q\u0001\ni\u000b\u0011b\u001d;sK\u0006l\u0017\n\u001a\u0011\t\u000f\u0001\u0004!\u0019!C\u0005C\u0006I1\u000f^8q\u0019\u0006$8\r[\u000b\u0002EB\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u000bG>t7-\u001e:sK:$(BA4i\u0003\u0011)H/\u001b7\u000b\u0003%\fAA[1wC&\u00111\u000e\u001a\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0011\u0019i\u0007\u0001)A\u0005E\u0006Q1\u000f^8q\u0019\u0006$8\r\u001b\u0011\t\u000f=\u0004!\u0019!C\u00053\u0006\u0019B-\u001a4bk2$(+Z:uCJ$H)\u001a7bs\"1\u0011\u000f\u0001Q\u0001\ni\u000bA\u0003Z3gCVdGOU3ti\u0006\u0014H\u000fR3mCf\u0004\u0003\"B:\u0001\r\u0003!\u0018A\u00039vg\"\u001c\u0016N\\4mKR\u0011Q\u000f\u001f\t\u0003\u001dYL!a^\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006sJ\u0004\rAJ\u0001\u0005I\u0006$\u0018\rC\u0003|\u0001\u0019\u0005A0A\u0005qkND')\u001f;fgR1Q/`A\u0006\u0003+AQA >A\u0002}\fQAY=uKN\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bA\u0017a\u00018j_&!\u0011\u0011BA\u0002\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003\u001bQ\b\u0019AA\b\u0003Ay\u0007\u000f^5p]\u0006dW*\u001a;bI\u0006$\u0018\r\u0005\u0003\u000f\u0003#1\u0013bAA\n\u001f\t1q\n\u001d;j_:Dq!a\u0006{\u0001\u0004\tI\"A\bpaRLwN\\1m\u00052|7m[%e!\u0015q\u0011\u0011CA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\r\u000591\u000f^8sC\u001e,\u0017\u0002BA\u0013\u0003?\u0011Qb\u0015;sK\u0006l'\t\\8dW&#\u0007bBA\u0015\u0001\u0019\u0005\u00111F\u0001\raV\u001c\b.\u0013;fe\u0006$xN\u001d\u000b\bk\u00065\u0012\u0011KA*\u0011!\ty#a\nA\u0002\u0005E\u0012\u0001C5uKJ\fGo\u001c:1\t\u0005M\u0012Q\n\t\u0007\u0003k\t)%a\u0013\u000f\t\u0005]\u0012\u0011\t\b\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012bAA\"\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA$\u0003\u0013\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u0007z\u0001cA\u0010\u0002N\u0011Y\u0011qJA\u0017\u0003\u0003\u0005\tQ!\u0001#\u0005\ryFE\r\u0005\t\u0003\u001b\t9\u00031\u0001\u0002\u0010!A\u0011qCA\u0014\u0001\u0004\tI\u0002C\u0004\u0002X\u00011\t!!\u0017\u0002\u001fA,8\u000f[!se\u0006L()\u001e4gKJ$r!^A.\u0003o\nI\b\u0003\u0005\u0002^\u0005U\u0003\u0019AA0\u0003-\t'O]1z\u0005V4g-\u001a:1\t\u0005\u0005\u00141\u000f\t\u0007\u0003G\ni'!\u001d\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nq!\\;uC\ndWMC\u0002\u0002l=\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001a\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004?\u0005MDaCA;\u00037\n\t\u0011!A\u0003\u0002\t\u00121a\u0018\u00134\u0011!\ti!!\u0016A\u0002\u0005=\u0001\u0002CA\f\u0003+\u0002\r!!\u0007\t\u000f\u0005u\u0004A\"\u0001\u0002\u0000\u0005Y!/\u001a9peR,%O]8s)\u0015)\u0018\u0011QAJ\u0011!\t\u0019)a\u001fA\u0002\u0005\u0015\u0015aB7fgN\fw-\u001a\t\u0005\u0003\u000f\u000biID\u0002\u000f\u0003\u0013K1!a#\u0010\u0003\u0019\u0001&/\u001a3fM&!\u0011qRAI\u0005\u0019\u0019FO]5oO*\u0019\u00111R\b\t\u0011\u0005U\u00151\u0010a\u0001\u0003/\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u0005U\u0012\u0011T\u0005\u0005\u00037\u000bIEA\u0005UQJ|w/\u00192mK\"9\u0011q\u0014\u0001\u0005\u0012\u0005\u0005\u0016aB8o'R\f'\u000f\u001e\u000b\u0002k\"9\u0011Q\u0015\u0001\u0005\u0012\u0005\u001d\u0016AB8o'R|\u0007\u000fF\u0003v\u0003S\u000bY\u000b\u0003\u0005\u0002\u0004\u0006\r\u0006\u0019AAC\u0011!\ti+a)A\u0002\u0005=\u0016!B3se>\u0014\b#\u0002\b\u0002\u0012\u0005]\u0005bBAZ\u0001\u0011E\u0011\u0011U\u0001\u0010_:\u0014VmY3jm\u0016\u00148\u000b^1si\"9\u0011q\u0017\u0001\u0005\u0012\u0005e\u0016AD8o%\u0016\u001cW-\u001b<feN#x\u000e\u001d\u000b\u0006k\u0006m\u0016Q\u0018\u0005\t\u0003\u0007\u000b)\f1\u0001\u0002\u0006\"A\u0011QVA[\u0001\u0004\ty\u000bC\u0004\u0002B\u0002!\t!!)\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006!1\u000f^8q)\u0015)\u0018\u0011ZAf\u0011!\t\u0019)a1A\u0002\u0005\u0015\u0005\u0002CAW\u0003\u0007\u0004\r!a,\t\u000f\u0005=\u0007\u0001\"\u0001\u0002\"\u0006i1\u000f^1siJ+7-Z5wKJDq!a5\u0001\t\u0003\t).\u0001\u0007ti>\u0004(+Z2fSZ,'\u000fF\u0003v\u0003/\fI\u000e\u0003\u0005\u0002\u0004\u0006E\u0007\u0019AAC\u0011!\ti+!5A\u0002\u0005=\u0006bBAo\u0001\u0011\u0005\u0011q\\\u0001\u0010e\u0016\u001cH/\u0019:u%\u0016\u001cW-\u001b<feR)Q/!9\u0002d\"A\u00111QAn\u0001\u0004\t)\t\u0003\u0006\u0002.\u0006m\u0007\u0013!a\u0001\u0003_Cq!!8\u0001\t\u0003\t9\u000fF\u0004v\u0003S\fY/!<\t\u0011\u0005\r\u0015Q\u001da\u0001\u0003\u000bC\u0001\"!,\u0002f\u0002\u0007\u0011q\u0016\u0005\b\u0003_\f)\u000f1\u0001[\u0003\u0015!W\r\\1z\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003k\f\u0011#[:SK\u000e,\u0017N^3s'R\f'\u000f^3e)\t\t9\u0010E\u0002\u000f\u0003sL1!a?\u0010\u0005\u001d\u0011un\u001c7fC:Dq!a@\u0001\t\u0003\t)0A\tjgJ+7-Z5wKJ\u001cFo\u001c9qK\u0012DqAa\u0001\u0001\t\u0003\t\t+\u0001\tbo\u0006LG\u000fV3s[&t\u0017\r^5p]\"I!q\u0001\u0001A\u0002\u0013E!\u0011B\u0001\u000egR|\u0007\u000f]5oO\u0016\u0013(o\u001c:\u0016\u0005\u0005]\u0005\"\u0003B\u0007\u0001\u0001\u0007I\u0011\u0003B\b\u0003E\u0019Ho\u001c9qS:<WI\u001d:pe~#S-\u001d\u000b\u0004k\nE\u0001B\u0003B\n\u0005\u0017\t\t\u00111\u0001\u0002\u0018\u0006\u0019\u0001\u0010J\u0019\t\u0011\t]\u0001\u0001)Q\u0005\u0003/\u000bab\u001d;paBLgnZ#se>\u0014\b\u0005\u000b\u0003\u0003\u0016\tm\u0001c\u0001\b\u0003\u001e%\u0019!qD\b\u0003\u0011Y|G.\u0019;jY\u0016D!Ba\t\u0001\u0001\u0004%\t\u0001\u0002B\u0013\u00035\u0011XmY3jm\u0016\u00148\u000b^1uKV\u0011!q\u0005\t\u0004\u0005SAeBA\u001e9\u0011)\u0011i\u0003\u0001a\u0001\n\u0003!!qF\u0001\u0012e\u0016\u001cW-\u001b<feN#\u0018\r^3`I\u0015\fHcA;\u00032!Q!1\u0003B\u0016\u0003\u0003\u0005\rAa\n\t\u0011\tU\u0002\u0001)Q\u0005\u0005O\taB]3dK&4XM]*uCR,\u0007\u0005\u000b\u0003\u00034\tm\u0001\"\u0003B\u001e\u0001E\u0005I\u0011\u0001B\u001f\u0003e\u0011Xm\u001d;beR\u0014VmY3jm\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}\"\u0006BAX\u0005\u0003Z#Aa\u0011\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001bz\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u000bB$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class ReceiverSupervisor
implements Logging {
    private final Receiver<?> receiver;
    private final int streamId;
    private final CountDownLatch stopLatch;
    private final int defaultRestartDelay;
    private volatile Throwable stoppingError;
    private volatile Enumeration.Value receiverState;
    private volatile ReceiverSupervisor$ReceiverState$ ReceiverState$module;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverSupervisor$ReceiverState$ ReceiverState$lzycompute() {
        ReceiverSupervisor receiverSupervisor = this;
        synchronized (receiverSupervisor) {
            if (this.ReceiverState$module != null) return this.ReceiverState$module;
            this.ReceiverState$module = new ReceiverSupervisor$ReceiverState$(this);
            return this.ReceiverState$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverSupervisor$ReceiverState$ ReceiverState() {
        return this.ReceiverState$module == null ? this.ReceiverState$lzycompute() : this.ReceiverState$module;
    }

    public int streamId() {
        return this.streamId;
    }

    private CountDownLatch stopLatch() {
        return this.stopLatch;
    }

    private int defaultRestartDelay() {
        return this.defaultRestartDelay;
    }

    public Throwable stoppingError() {
        return this.stoppingError;
    }

    public void stoppingError_$eq(Throwable x$1) {
        this.stoppingError = x$1;
    }

    public Enumeration.Value receiverState() {
        return this.receiverState;
    }

    public void receiverState_$eq(Enumeration.Value x$1) {
        this.receiverState = x$1;
    }

    public abstract void pushSingle(Object var1);

    public abstract void pushBytes(ByteBuffer var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushIterator(Iterator<Object> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushArrayBuffer(ArrayBuffer<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void reportError(String var1, Throwable var2);

    public void onStart() {
    }

    public void onStop(String message, Option<Throwable> error) {
    }

    public void onReceiverStart() {
    }

    public void onReceiverStop(String message, Option<Throwable> error) {
    }

    public void start() {
        this.onStart();
        this.startReceiver();
    }

    public void stop(String message, Option<Throwable> error) {
        this.stoppingError_$eq((Throwable)error.orNull(Predef$.MODULE$.conforms()));
        this.stopReceiver(message, error);
        this.onStop(message, error);
        this.stopLatch().countDown();
    }

    public synchronized void startReceiver() {
        try {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting receiver";
                }
            });
            this.receiver.onStart();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Called receiver onStart";
                }
            });
            this.onReceiverStart();
            this.receiverState_$eq(this.ReceiverState().Started());
        }
        catch (Throwable throwable) {
            this.stop(new StringBuilder().append((Object)"Error starting receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString(), (Option<Throwable>)new Some((Object)throwable));
        }
    }

    public synchronized void stopReceiver(String message, Option<Throwable> error) {
        try {
            this.logInfo((Function0<String>)new Serializable(this, message, error){
                public static final long serialVersionUID = 0L;
                private final String message$2;
                private final Option error$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopping receiver with message: ").append((Object)this.message$2).append((Object)": ").append(this.error$2.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })).toString();
                }
                {
                    this.message$2 = message$2;
                    this.error$2 = error$2;
                }
            });
            this.receiverState_$eq(this.ReceiverState().Stopped());
            this.receiver.onStop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Called receiver onStop";
                }
            });
            this.onReceiverStop(message, error);
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverSupervisor $outer;
                private final Throwable t$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Error stopping receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).append((Object)Predef$.MODULE$.exceptionWrapper(this.t$1).getStackTraceString()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void restartReceiver(String message, Option<Throwable> error) {
        this.restartReceiver(message, error, this.defaultRestartDelay());
    }

    public void restartReceiver(String message, Option<Throwable> error, int delay) {
        Future$.MODULE$.apply((Function0)new Serializable(this, message, error, delay){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;
            public final String message$1;
            private final Option error$1;
            public final int delay$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).append((Object)" ms: ").append((Object)this.$outer.message$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Throwable)this.error$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                this.$outer.stopReceiver(new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.delay$1)).append((Object)"ms: ").append((Object)this.message$1).toString(), (Option<Throwable>)this.error$1);
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Sleeping for ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Thread.sleep(this.delay$1);
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting receiver again";
                    }
                });
                this.$outer.startReceiver();
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Receiver started again";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.error$1 = error$1;
                this.delay$1 = delay$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<Throwable> restartReceiver$default$2() {
        return None$.MODULE$;
    }

    public boolean isReceiverStarted() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isReceiverStopped() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public void awaitTermination() {
        this.stopLatch().await();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for executor stop is over";
            }
        });
        if (this.stoppingError() == null) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped executor without error";
                }
            });
        } else {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverSupervisor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped executor with error: ").append((Object)this.$outer.stoppingError()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.stoppingError() == null) {
            return;
        }
        throw this.stoppingError();
    }

    public ReceiverSupervisor(Receiver<?> receiver, SparkConf conf) {
        this.receiver = receiver;
        Logging.class.$init$((Logging)this);
        receiver.attachExecutor(this);
        this.streamId = receiver.streamId();
        this.stopLatch = new CountDownLatch(1);
        this.defaultRestartDelay = conf.getInt("spark.streaming.receiverRestartDelay", 2000);
        this.stoppingError = null;
        this.receiverState = this.ReceiverState().Initialized();
    }
}

