/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.Criterion;

public abstract class BaseCmmnXmlConverter {
    public abstract String getXMLElementName();

    public abstract boolean hasChildElements();

    public BaseElement convertToCmmnModel(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        BaseElement baseElement = this.convert(xtr, conversionHelper);
        if (baseElement != null) {
            baseElement.setId(xtr.getAttributeValue(null, "id"));
            Location location = xtr.getLocation();
            baseElement.setXmlRowNumber(location.getLineNumber());
            baseElement.setXmlColumnNumber(location.getColumnNumber());
            if (baseElement instanceof CmmnElement) {
                CmmnElement cmmnElement = (CmmnElement)baseElement;
                conversionHelper.setCurrentCmmnElement(cmmnElement);
            }
            if (baseElement instanceof Criterion) {
                Criterion criterion = (Criterion)baseElement;
                conversionHelper.getCmmnModel().addCriterion(criterion.getId(), criterion);
            }
        }
        return baseElement;
    }

    protected abstract BaseElement convert(XMLStreamReader var1, ConversionHelper var2);

    protected void elementEnd(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        if (this.hasChildElements()) {
            conversionHelper.removeCurrentCmmnElement();
        }
    }
}

