/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl;

import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnMigrationService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.api.DynamicCmmnService;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.CmmnEngines;
import org.flowable.cmmn.engine.impl.cmd.ClearCaseInstanceLockTimesCmd;
import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.api.engine.EngineLifecycleListener;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnEngineImpl
implements CmmnEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnEngineImpl.class);
    protected String name;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnRuntimeService cmmnRuntimeService;
    protected DynamicCmmnService dynamicCmmnService;
    protected CmmnTaskService cmmnTaskService;
    protected CmmnManagementService cmmnManagementService;
    protected CmmnRepositoryService cmmnRepositoryService;
    protected CmmnHistoryService cmmnHistoryService;
    protected CmmnMigrationService cmmnMigrationService;
    protected AsyncExecutor asyncExecutor;
    protected AsyncExecutor asyncHistoryExecutor;

    public CmmnEngineImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
        this.name = cmmnEngineConfiguration.getEngineName();
        this.cmmnRuntimeService = cmmnEngineConfiguration.getCmmnRuntimeService();
        this.dynamicCmmnService = cmmnEngineConfiguration.getDynamicCmmnService();
        this.cmmnTaskService = cmmnEngineConfiguration.getCmmnTaskService();
        this.cmmnManagementService = cmmnEngineConfiguration.getCmmnManagementService();
        this.cmmnRepositoryService = cmmnEngineConfiguration.getCmmnRepositoryService();
        this.cmmnHistoryService = cmmnEngineConfiguration.getCmmnHistoryService();
        this.cmmnMigrationService = cmmnEngineConfiguration.getCmmnMigrationService();
        this.asyncExecutor = cmmnEngineConfiguration.getAsyncExecutor();
        this.asyncHistoryExecutor = cmmnEngineConfiguration.getAsyncHistoryExecutor();
        if (cmmnEngineConfiguration.getSchemaManagementCmd() != null) {
            CommandExecutor commandExecutor = cmmnEngineConfiguration.getCommandExecutor();
            commandExecutor.execute(cmmnEngineConfiguration.getSchemaCommandConfig(), cmmnEngineConfiguration.getSchemaManagementCmd());
        }
        LOGGER.info("CmmnEngine {} created", (Object)this.name);
        CmmnEngines.registerCmmnEngine(this);
        if (cmmnEngineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : cmmnEngineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineBuilt((Engine)this);
            }
        }
    }

    @Override
    public void startExecutors() {
        if (this.asyncExecutor != null && this.asyncExecutor.isAutoActivate()) {
            this.asyncExecutor.start();
        }
        if (this.asyncHistoryExecutor != null && this.asyncHistoryExecutor.isAutoActivate()) {
            this.asyncHistoryExecutor.start();
        }
        if (this.cmmnEngineConfiguration.isEnableHistoryCleaning()) {
            this.cmmnManagementService.handleHistoryCleanupTimerJob();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void close() {
        CmmnEngines.unregister(this);
        if (this.asyncExecutor != null && this.asyncExecutor.isActive()) {
            this.asyncExecutor.shutdown();
            this.cmmnEngineConfiguration.getCommandExecutor().execute((Command)new ClearCaseInstanceLockTimesCmd(this.asyncExecutor.getLockOwner(), this.cmmnEngineConfiguration));
        }
        if (this.asyncHistoryExecutor != null && this.asyncHistoryExecutor.isActive()) {
            this.asyncHistoryExecutor.shutdown();
        }
        this.cmmnEngineConfiguration.close();
        if (this.cmmnEngineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : this.cmmnEngineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineClosed((Engine)this);
            }
        }
    }

    @Override
    public CmmnEngineConfiguration getCmmnEngineConfiguration() {
        return this.cmmnEngineConfiguration;
    }

    public void setCmmnEngineConfiguration(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    @Override
    public CmmnRuntimeService getCmmnRuntimeService() {
        return this.cmmnRuntimeService;
    }

    public void setCmmnRuntimeService(CmmnRuntimeService cmmnRuntimeService) {
        this.cmmnRuntimeService = cmmnRuntimeService;
    }

    @Override
    public DynamicCmmnService getDynamicCmmnService() {
        return this.dynamicCmmnService;
    }

    public void setDynamicCmmnService(DynamicCmmnService dynamicCmmnService) {
        this.dynamicCmmnService = dynamicCmmnService;
    }

    @Override
    public CmmnTaskService getCmmnTaskService() {
        return this.cmmnTaskService;
    }

    public void setCmmnTaskService(CmmnTaskService cmmnTaskService) {
        this.cmmnTaskService = cmmnTaskService;
    }

    @Override
    public CmmnManagementService getCmmnManagementService() {
        return this.cmmnManagementService;
    }

    public void setCmmnManagementService(CmmnManagementService cmmnManagementService) {
        this.cmmnManagementService = cmmnManagementService;
    }

    @Override
    public CmmnRepositoryService getCmmnRepositoryService() {
        return this.cmmnRepositoryService;
    }

    public void setCmmnRepositoryService(CmmnRepositoryService cmmnRepositoryService) {
        this.cmmnRepositoryService = cmmnRepositoryService;
    }

    @Override
    public CmmnHistoryService getCmmnHistoryService() {
        return this.cmmnHistoryService;
    }

    public void setCmmnHistoryService(CmmnHistoryService cmmnHistoryService) {
        this.cmmnHistoryService = cmmnHistoryService;
    }

    @Override
    public CmmnMigrationService getCmmnMigrationService() {
        return this.cmmnMigrationService;
    }

    public void setCmmnMigrationService(CmmnMigrationService cmmnMigrationService) {
        this.cmmnMigrationService = cmmnMigrationService;
    }
}

