/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Task;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class ActivateAsyncPlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    protected String entryCriterionId;

    public ActivateAsyncPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        super(commandContext, planItemInstanceEntity);
        this.entryCriterionId = entryCriterionId;
    }

    @Override
    public String getLifeCycleTransition() {
        return "async-activate";
    }

    @Override
    public String getNewState() {
        return "async-active";
    }

    @Override
    protected void internalExecute() {
        this.planItemInstanceEntity.setLastStartedTime(this.getCurrentTime(this.commandContext));
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceStarted(this.planItemInstanceEntity);
        this.createAsyncJob((Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition());
    }

    protected void createAsyncJob(Task task) {
        Expression categoryExpression;
        Object categoryValue;
        ExtensionElement jobCategoryElement;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        JobService jobService = cmmnEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setJobHandlerType("cmmn-async-activate-plan-item-instance");
        job.setScopeId(this.planItemInstanceEntity.getCaseInstanceId());
        job.setSubScopeId(this.planItemInstanceEntity.getId());
        job.setScopeDefinitionId(this.planItemInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setElementId(task.getId());
        job.setElementName(task.getName());
        job.setJobHandlerConfiguration(this.entryCriterionId);
        List jobCategoryElements = (List)task.getExtensionElements().get("jobCategory");
        if (jobCategoryElements != null && jobCategoryElements.size() > 0 && StringUtils.isNotEmpty((CharSequence)(jobCategoryElement = (ExtensionElement)jobCategoryElements.get(0)).getElementText()) && (categoryValue = (categoryExpression = cmmnEngineConfiguration.getExpressionManager().createExpression(jobCategoryElement.getElementText())).getValue((VariableContainer)this.planItemInstanceEntity)) != null) {
            job.setCategory(categoryValue.toString());
        }
        job.setTenantId(this.planItemInstanceEntity.getTenantId());
        jobService.createAsyncJob(job, task.isExclusive());
        jobService.scheduleAsyncJob(job);
        if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Created async job for " + this.planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskAsyncJob", job, this.planItemInstanceEntity.getPlanItemDefinition(), this.planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
        }
    }

    @Override
    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Async activate PlanItem] ");
        stringBuilder.append(planItem);
        if (this.entryCriterionId != null) {
            stringBuilder.append(" via entry criterion ").append(this.entryCriterionId);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getOperationName() {
        return "[Async activate plan item]";
    }
}

