/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityWithMigrationContextBehavior;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.interceptor.MigrationContext;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class StartPlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    protected String entryCriterionId;
    protected ChildTaskActivityBehavior.VariableInfo childTaskVariableInfo;
    protected MigrationContext migrationContext;

    public StartPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        super(commandContext, planItemInstanceEntity);
        this.entryCriterionId = entryCriterionId;
    }

    public StartPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId, ChildTaskActivityBehavior.VariableInfo childTaskVariableInfo) {
        this(commandContext, planItemInstanceEntity, entryCriterionId);
        this.childTaskVariableInfo = childTaskVariableInfo;
    }

    public StartPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId, MigrationContext migrationContext) {
        this(commandContext, planItemInstanceEntity, entryCriterionId);
        this.migrationContext = migrationContext;
    }

    @Override
    public String getNewState() {
        return "active";
    }

    @Override
    public String getLifeCycleTransition() {
        return "start";
    }

    @Override
    protected void internalExecute() {
        this.removeSentryRelatedData();
        this.planItemInstanceEntity.setEntryCriterionId(this.entryCriterionId);
        this.planItemInstanceEntity.setLastStartedTime(this.getCurrentTime(this.commandContext));
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceStarted(this.planItemInstanceEntity);
        this.executeActivityBehavior();
    }

    protected void executeActivityBehavior() {
        CmmnActivityBehavior activityBehavior = (CmmnActivityBehavior)this.planItemInstanceEntity.getPlanItem().getBehavior();
        if (this.migrationContext != null && activityBehavior instanceof CmmnActivityWithMigrationContextBehavior) {
            ((CmmnActivityWithMigrationContextBehavior)((Object)activityBehavior)).execute(this.commandContext, this.planItemInstanceEntity, this.migrationContext);
        } else if (activityBehavior instanceof ChildTaskActivityBehavior) {
            ((ChildTaskActivityBehavior)activityBehavior).execute(this.commandContext, this.planItemInstanceEntity, this.childTaskVariableInfo);
        } else if (activityBehavior instanceof CoreCmmnActivityBehavior) {
            ((CoreCmmnActivityBehavior)activityBehavior).execute(this.commandContext, this.planItemInstanceEntity);
        } else {
            activityBehavior.execute(this.planItemInstanceEntity);
        }
    }

    @Override
    public String getOperationName() {
        return "[Start plan item]";
    }
}

