/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.cmmn.engine.interceptor.CreateCasePageTaskAfterContext;
import org.flowable.cmmn.engine.interceptor.CreateCasePageTaskBeforeContext;
import org.flowable.cmmn.model.CasePageTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CasePageTaskActivityBehaviour
extends TaskActivityBehavior
implements PlanItemActivityBehavior {
    protected CasePageTask casePageTask;

    public CasePageTaskActivityBehaviour(CasePageTask casePageTask) {
        super(true, null);
        this.casePageTask = casePageTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        CreateCasePageTaskBeforeContext beforeContext = new CreateCasePageTaskBeforeContext(this.casePageTask, planItemInstanceEntity, this.casePageTask.getFormKey(), this.casePageTask.getAssignee(), this.casePageTask.getOwner(), this.casePageTask.getCandidateUsers(), this.casePageTask.getCandidateGroups());
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if (cmmnEngineConfiguration.getCreateCasePageTaskInterceptor() != null) {
            cmmnEngineConfiguration.getCreateCasePageTaskInterceptor().beforeCreateCasePageTask(beforeContext);
        }
        ExpressionManager expressionManager = cmmnEngineConfiguration.getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getFormKey())) {
            planItemInstanceEntity.setFormKey(this.getExpressionValue(beforeContext.getFormKey(), planItemInstanceEntity, expressionManager));
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getAssignee())) {
            IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, this.getExpressionValue(beforeContext.getAssignee(), planItemInstanceEntity, expressionManager), null, "assignee", cmmnEngineConfiguration);
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getOwner())) {
            IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, this.getExpressionValue(beforeContext.getOwner(), planItemInstanceEntity, expressionManager), null, "owner", cmmnEngineConfiguration);
        }
        if (beforeContext.getCandidateUsers() != null && !beforeContext.getCandidateUsers().isEmpty()) {
            for (String candidateUser : beforeContext.getCandidateUsers()) {
                IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, this.getExpressionValue(candidateUser, planItemInstanceEntity, expressionManager), null, "candidate", cmmnEngineConfiguration);
            }
        }
        if (beforeContext.getCandidateGroups() != null && !beforeContext.getCandidateGroups().isEmpty()) {
            for (String candidateGroup : beforeContext.getCandidateGroups()) {
                IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, null, this.getExpressionValue(candidateGroup, planItemInstanceEntity, expressionManager), "candidate", cmmnEngineConfiguration);
            }
        }
        if (cmmnEngineConfiguration.getCreateCasePageTaskInterceptor() != null) {
            CreateCasePageTaskAfterContext afterContext = new CreateCasePageTaskAfterContext(this.casePageTask, planItemInstanceEntity);
            cmmnEngineConfiguration.getCreateCasePageTaskInterceptor().afterCreateCasePageTask(afterContext);
        }
        cmmnEngineConfiguration.getCmmnHistoryManager().recordPlanItemInstanceUpdated(planItemInstanceEntity);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
    }

    protected String getExpressionValue(String value, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager) {
        Object expressionValue = expressionManager.createExpression(value).getValue((VariableContainer)planItemInstanceEntity);
        if (expressionValue != null) {
            return expressionValue.toString();
        }
        throw new FlowableException("Unable to resolve expression value for " + value);
    }
}

