/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationValidationResult;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationManager;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CaseInstanceMigrationValidationCmd
implements Command<CaseInstanceMigrationValidationResult> {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected int caseDefinitionVersion;
    protected String caseDefinitionTenantId;
    protected CaseInstanceMigrationDocument caseInstanceMigrationDocument;

    public CaseInstanceMigrationValidationCmd(String caseInstanceId, CaseInstanceMigrationDocument caseInstanceMigrationDocument, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseInstanceId == null) {
            throw new FlowableException("Must specify a case instance id to migrate");
        }
        if (caseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a case instance migration document to migrate");
        }
        this.caseInstanceId = caseInstanceId;
        this.caseInstanceMigrationDocument = caseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseInstanceMigrationValidationCmd(CaseInstanceMigrationDocument caseInstanceMigrationDocument, String caseDefinitionId, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseDefinitionId == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a case instance migration document to migrate");
        }
        this.caseDefinitionId = null;
        this.caseInstanceMigrationDocument = caseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseInstanceMigrationValidationCmd(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId, CaseInstanceMigrationDocument caseInstanceMigrationDocument, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseDefinitionKey == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseDefinitionTenantId == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a case instance migration document to migrate");
        }
        this.caseDefinitionKey = caseDefinitionKey;
        this.caseDefinitionVersion = caseDefinitionVersion;
        this.caseDefinitionTenantId = caseDefinitionTenantId;
        this.caseInstanceMigrationDocument = caseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseInstanceMigrationValidationResult execute(CommandContext commandContext) {
        CaseInstanceMigrationManager migrationManager = this.cmmnEngineConfiguration.getCaseInstanceMigrationManager();
        if (this.caseInstanceId != null) {
            return migrationManager.validateMigrateCaseInstance(this.caseInstanceId, this.caseInstanceMigrationDocument, commandContext);
        }
        if (this.caseDefinitionId != null) {
            return migrationManager.validateMigrateCaseInstancesOfCaseDefinition(this.caseDefinitionId, this.caseInstanceMigrationDocument, commandContext);
        }
        if (this.caseDefinitionKey != null && this.caseDefinitionVersion >= 0) {
            return migrationManager.validateMigrateCaseInstancesOfCaseDefinition(this.caseDefinitionKey, this.caseDefinitionVersion, this.caseDefinitionTenantId, this.caseInstanceMigrationDocument, commandContext);
        }
        throw new FlowableException("Cannot migrate case(es), not enough information");
    }
}

