/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.JPQLFragment;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;

public abstract class From
implements JPQLFragment {
    abstract void generateFromString(QueryGenerationState var1, boolean var2);

    protected void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        if (preparePhase == Expression.QueryGenerationPreparationPhase.FROM) {
            queryState.generateFromAlias(this);
        }
    }

    public static From forEntity(String entityName) {
        FromEntity from = new FromEntity();
        from.entityName = entityName;
        return from;
    }

    public static From forNavigationalLinks(Expression linksExpr) {
        FromNavigationalLinks from = new FromNavigationalLinks();
        from.links = linksExpr;
        return from;
    }

    public static FromNavigationalLinksLeftOuterJoin forNavigationalLinksLeftOuterJoin(FromNavigationalLinks link) {
        FromNavigationalLinksLeftOuterJoin from = new FromNavigationalLinksLeftOuterJoin();
        from.links = link.links;
        return from;
    }

    public static class FromNavigationalLinksLeftOuterJoin
    extends From {
        public Expression links;

        @Override
        void generateFromString(QueryGenerationState queryState, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " LEFT OUTER JOIN ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
    }

    public static class FromNavigationalLinks
    extends From {
        public Expression links;

        @Override
        void generateFromString(QueryGenerationState queryState, boolean isFirst) {
            if (!isFirst) {
                queryState.queryString = queryState.queryString + " JOIN ";
            }
            this.links.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
    }

    public static class FromEntity
    extends From {
        public String entityName;

        @Override
        void generateFromString(QueryGenerationState queryState, boolean isFirst) {
            queryState.queryString = queryState.queryString + this.entityName;
        }
    }
}

