/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.ExpressionVisitor;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;

public class ParameterExpression
extends Expression {
    private int lambdaIndex;
    private int argIndex;

    public ParameterExpression(int lambdaIndex, int argIndex) {
        this.lambdaIndex = lambdaIndex;
        this.argIndex = argIndex;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        String paramName = queryState.registerParameter((Object)this, this.lambdaIndex, this.argIndex);
        queryState.appendQuery(":" + paramName);
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParameterExpression o = (ParameterExpression)obj;
        return this.lambdaIndex == o.lambdaIndex && this.argIndex == o.argIndex;
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitParameter(this);
    }
}

