/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.ExpressionVisitor;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;

public class ParameterFieldExpression
extends Expression {
    private int lambdaIndex;
    private String fieldName;

    public ParameterFieldExpression(int lambdaIndex, String fieldName) {
        this.lambdaIndex = lambdaIndex;
        this.fieldName = fieldName;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        String paramName = queryState.registerParameter((Object)this, this.lambdaIndex, this.fieldName);
        queryState.appendQuery(":" + paramName);
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParameterFieldExpression o = (ParameterFieldExpression)obj;
        return this.lambdaIndex == o.lambdaIndex && this.fieldName.equals(o.fieldName);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitParameterField(this);
    }
}

