/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.GeneratedQueryParameter;

class QueryGenerationState {
    String queryString = "";
    Map<From, String> fromAliases = new IdentityHashMap<From, String>();
    Map<Object, String> parameterNames = new IdentityHashMap<Object, String>();
    List<GeneratedQueryParameter> parameters = new ArrayList<GeneratedQueryParameter>();
    int nextParam = 0;
    int nextCol = 1;
    int nextTable = 0;
    static final String TableLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    QueryGenerationState() {
    }

    public String generateFromAlias(From from) {
        if (this.fromAliases.containsKey(from)) {
            return this.fromAliases.get(from);
        }
        String alias = this.nextTableAlias();
        this.fromAliases.put(from, alias);
        return alias;
    }

    public String getFromAlias(From from) {
        return this.fromAliases.get(from);
    }

    public String registerParameter(Object paramNode, int lambdaIndex, int argIndex) {
        if (!this.parameterNames.containsKey(paramNode)) {
            String paramName = this.nextParamIndex();
            this.parameterNames.put(paramNode, paramName);
            this.parameters.add(new GeneratedQueryParameter(paramName, lambdaIndex, argIndex));
        }
        return this.parameterNames.get(paramNode);
    }

    public String registerParameter(Object paramNode, int lambdaIndex, String fieldName) {
        if (!this.parameterNames.containsKey(paramNode)) {
            String paramName = this.nextParamIndex();
            this.parameterNames.put(paramNode, paramName);
            this.parameters.add(new GeneratedQueryParameter(paramName, lambdaIndex, fieldName));
        }
        return this.parameterNames.get(paramNode);
    }

    public void appendQuery(String str) {
        this.queryString = this.queryString + str;
    }

    private String nextTableAlias() {
        int toReturn = this.nextTable++;
        return QueryGenerationState.intToTablePrefix(toReturn);
    }

    private String nextColAlias() {
        int toReturn = this.nextCol++;
        return "COL" + toReturn;
    }

    private String nextParamIndex() {
        int toReturn = this.nextParam++;
        return "param" + toReturn;
    }

    static int tablePrefixToInt(String prefix) {
        int num = 0;
        int multiplier = 1;
        for (int n = prefix.length() - 1; n >= 0; --n) {
            int offset = TableLetters.indexOf(prefix.substring(n, n + 1));
            assert (offset != -1);
            num = n == prefix.length() - 1 ? (num += offset * multiplier) : (num += (offset + 1) * multiplier);
            multiplier *= TableLetters.length();
        }
        return num;
    }

    static String intToTablePrefix(int num) {
        String prefix = "";
        ++num;
        while (num > 0) {
            int offset = (num - 1) % TableLetters.length();
            prefix = TableLetters.substring(offset, offset + 1) + prefix;
            num = (num - 1) / TableLetters.length();
        }
        return prefix;
    }
}

