/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import java.util.ArrayList;
import java.util.List;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.GeneratedQueryParameter;
import org.jinq.jpa.jpqlquery.GroupedSelectFromWhere;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.SubqueryExpression;

public class SelectFromWhere<T>
extends SelectOnly<T> {
    public List<From> froms = new ArrayList<From>();
    public Expression where;
    public List<SortingParameters> sort = new ArrayList<SortingParameters>();
    public long limit = -1L;
    public long skip = -1L;
    private String queryString;
    private List<GeneratedQueryParameter> queryParameters;

    protected void generateQuery() {
        QueryGenerationState queryState = new QueryGenerationState();
        this.prepareQueryGeneration(queryState);
        this.queryString = this.generateQueryContents(queryState);
        this.queryParameters = queryState.parameters;
    }

    protected void prepareQueryGeneration(QueryGenerationState queryState) {
        this.prepareQueryGeneration(Expression.QueryGenerationPreparationPhase.FROM, queryState);
    }

    protected void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        for (Expression col : this.cols.columns) {
            col.prepareQueryGeneration(preparePhase, queryState);
        }
        for (From from : this.froms) {
            from.prepareQueryGeneration(preparePhase, queryState);
        }
        if (this.where != null) {
            this.where.prepareQueryGeneration(preparePhase, queryState);
        }
        for (SortingParameters sortParams : this.sort) {
            sortParams.expr.prepareQueryGeneration(preparePhase, queryState);
        }
    }

    protected String generateQueryContents(QueryGenerationState queryState) {
        this.generateSelectFromWhere(queryState);
        this.generateSort(queryState);
        return queryState.queryString;
    }

    protected void generateSelectFromWhere(QueryGenerationState queryState) {
        boolean isFirst;
        if (this.cols.getNumColumns() > 0) {
            queryState.queryString = queryState.queryString + "SELECT ";
            if (this.isDistinct) {
                queryState.queryString = queryState.queryString + "DISTINCT ";
            }
            isFirst = true;
            for (Expression col : this.cols.columns) {
                if (!isFirst) {
                    queryState.queryString = queryState.queryString + ", ";
                }
                isFirst = false;
                col.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            }
        }
        if (this.froms.size() > 0) {
            queryState.queryString = queryState.queryString + " FROM ";
            isFirst = true;
            for (From from : this.froms) {
                if (!(isFirst || from instanceof From.FromNavigationalLinksLeftOuterJoin || from instanceof From.FromNavigationalLinks)) {
                    queryState.queryString = queryState.queryString + ", ";
                }
                from.generateFromString(queryState, isFirst);
                isFirst = false;
                queryState.queryString = queryState.queryString + " " + queryState.getFromAlias(from);
            }
        }
        if (this.where != null) {
            queryState.queryString = queryState.queryString + " WHERE ";
            this.where.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
    }

    protected void generateSort(QueryGenerationState queryState) {
        if (!this.sort.isEmpty()) {
            queryState.queryString = queryState.queryString + " ORDER BY";
            boolean isFirst = true;
            for (SortingParameters sortParams : this.sort) {
                if (!isFirst) {
                    queryState.queryString = queryState.queryString + ",";
                }
                isFirst = false;
                queryState.queryString = queryState.queryString + " ";
                if (sortParams.expr instanceof SubqueryExpression) {
                    queryState.queryString = queryState.queryString + "(";
                }
                sortParams.expr.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_ORDER_BY_UNRESTRICTED_OPERATOR_PRECEDENCE);
                queryState.queryString = queryState.queryString + (sortParams.isAscending ? " ASC" : " DESC");
                if (!(sortParams.expr instanceof SubqueryExpression)) continue;
                queryState.queryString = queryState.queryString + ")";
            }
        }
    }

    @Override
    public String getQueryString() {
        if (this.queryString == null) {
            this.generateQuery();
        }
        return this.queryString;
    }

    @Override
    public List<GeneratedQueryParameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.generateQuery();
        }
        return this.queryParameters;
    }

    @Override
    public RowReader<T> getRowReader() {
        return this.cols.reader;
    }

    @Override
    public boolean isSelectFromWhere() {
        return !this.isAggregated && this.sort.isEmpty() && this.limit < 0L && this.skip < 0L && !this.isDistinct;
    }

    @Override
    public boolean isSelectOnly() {
        return false;
    }

    @Override
    public boolean canSort() {
        return (this.getClass() == SelectFromWhere.class && !this.isAggregated || this instanceof GroupedSelectFromWhere) && this.limit < 0L && this.skip < 0L;
    }

    @Override
    public boolean canDistinct() {
        return this.isSelectFromWhere();
    }

    @Override
    public boolean isValidSubquery() {
        return this.limit < 0L && this.skip < 0L && this.sort.isEmpty();
    }

    public <U> GroupedSelectFromWhere<T, U> shallowCopyWithGrouping() {
        GroupedSelectFromWhere copy = new GroupedSelectFromWhere();
        this.copySelectFromWhereTo(copy);
        return copy;
    }

    protected void copySelectFromWhereTo(SelectFromWhere<T> copy) {
        copy.cols = this.cols;
        copy.froms.addAll(this.froms);
        copy.where = this.where;
        copy.isAggregated = this.isAggregated;
        copy.sort.addAll(this.sort);
        copy.limit = this.limit;
        copy.skip = this.skip;
        copy.isDistinct = this.isDistinct;
    }

    @Override
    public SelectFromWhere<T> shallowCopy() {
        SelectFromWhere<T> copy = new SelectFromWhere<T>();
        this.copySelectFromWhereTo(copy);
        return copy;
    }

    public static class SortingParameters {
        public Expression expr;
        public boolean isAscending;
    }
}

