/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.jpqlquery;

import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.ExpressionVisitor;
import org.jinq.jpa.jpqlquery.OperatorPrecedenceLevel;
import org.jinq.jpa.jpqlquery.QueryGenerationState;

public class UnaryExpression
extends Expression {
    final Expression operand;
    final String prefixOperator;
    final String postfixOperator;

    private UnaryExpression(String prefixOperator, String postfixOperator, Expression operand) {
        this.prefixOperator = prefixOperator;
        this.postfixOperator = postfixOperator;
        this.operand = operand;
    }

    public static UnaryExpression prefix(String operator, Expression operand) {
        return new UnaryExpression(operator, "", operand);
    }

    public static UnaryExpression postfix(String operator, Expression operand) {
        return new UnaryExpression("", operator, operand);
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        OperatorPrecedenceLevel precedence;
        String operator;
        String precedenceString = operator = this.prefixOperator + this.postfixOperator;
        if (operator.equals("-")) {
            precedenceString = "-unary";
        }
        if (!(precedence = OperatorPrecedenceLevel.forOperator(precedenceString)).hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery("(");
        }
        if (!this.prefixOperator.isEmpty()) {
            queryState.appendQuery(this.prefixOperator + " ");
        }
        this.operand.generateQuery(queryState, precedence);
        if (!this.postfixOperator.isEmpty()) {
            queryState.appendQuery(" " + this.postfixOperator);
        }
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery(")");
        }
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.operand.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        UnaryExpression o = (UnaryExpression)obj;
        return this.operand.equals(o.operand) && this.prefixOperator.equals(o.prefixOperator) && this.postfixOperator.equals(o.postfixOperator);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitUnary(this);
    }
}

