/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.MethodAnalysisResults;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisFactory;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSupplementalFactory;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import com.user00.thunk.SerializedLambda;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jinq.jpa.transform.LambdaInfo;
import org.jinq.jpa.transform.MetamodelUtil;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class LambdaAnalysis {
    private int numCapturedArgs;
    private int numLambdaArgs;
    private int lambdaIndex;
    private List<TypedValue> indirectCapturedArgs;
    private Map<String, TypedValue> indirectParamFields;
    private boolean usesParametersAsFields;
    MethodAnalysisResults symbolicAnalysis;

    public static LambdaAnalysis fullyAnalyzeClassAsLambda(LambdaInfo lambdaInfo, LambdaAsClassAnalysisConfig lambdaAsClassConfig, int numLambdaArgs, MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe, boolean throwExceptionOnFailure) {
        try {
            MethodAnalysisResults analysis = LambdaAnalysis.analyzeLambdaClass(lambdaInfo.Lambda.getClass(), metamodel, lambdaAsClassConfig, lambdaInfo.Lambda.getClass().getClassLoader(), isObjectEqualsSafe);
            if (analysis == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not analyze lambda code");
                }
                return null;
            }
            return new LambdaAnalysis(lambdaInfo.Lambda, analysis, numLambdaArgs, lambdaInfo.lambdaIndex);
        }
        catch (Exception e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not analyze lambda code", e);
            }
            return null;
        }
    }

    public static LambdaAnalysis analyzeClassAsLambda(MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe, LambdaAsClassAnalysisConfig lambdaAsClassConfig, String className, Map<String, TypedValue> indirectParamMapping, boolean throwExceptionOnFailure) {
        try {
            Class<?> c = Class.forName(className);
            MethodAnalysisResults analysis = LambdaAnalysis.analyzeLambdaClass(c, metamodel, lambdaAsClassConfig, alternateClassLoader, isObjectEqualsSafe);
            if (analysis == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not analyze lambda code");
                }
                return null;
            }
            return new LambdaAnalysis(analysis, indirectParamMapping, lambdaAsClassConfig.getNumberOfLambdaArguments(c));
        }
        catch (IOException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Encountered problems when trying to load the code for your lambdas. You may need to supply a lambdaClassLoader hint to Jinq to help it find your lambdas.", e);
            }
            return null;
        }
        catch (AnalyzerException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not analyze lambda code", e);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not load the class of the lambda", e);
            }
            return null;
        }
    }

    public static LambdaAnalysis fullyAnalyzeLambda(LambdaInfo lambdaInfo, MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe, boolean throwExceptionOnFailure) {
        SerializedLambda s = lambdaInfo.serializedLambda;
        try {
            if (s == null) {
                return null;
            }
            MethodAnalysisResults analysis = LambdaAnalysis.analyzeLambda(metamodel, alternateClassLoader, isObjectEqualsSafe, s.implClass, s.implMethodName, s.implMethodSignature);
            if (analysis == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not analyze lambda code");
                }
                return null;
            }
            return new LambdaAnalysis(lambdaInfo.Lambda, s, analysis, lambdaInfo.lambdaIndex);
        }
        catch (Exception e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not analyze lambda code", e);
            }
            return null;
        }
    }

    public static LambdaAnalysis analyzeMethod(MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe, Handle lambdaHandle, List<TypedValue> indirectCapturedArgs, boolean throwExceptionOnFailure) {
        try {
            MethodAnalysisResults analysis = LambdaAnalysis.analyzeLambda(metamodel, alternateClassLoader, isObjectEqualsSafe, lambdaHandle.getOwner(), lambdaHandle.getName(), lambdaHandle.getDesc());
            if (analysis == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not analyze lambda code");
                }
                return null;
            }
            return new LambdaAnalysis(analysis, indirectCapturedArgs, Type.getArgumentTypes((String)lambdaHandle.getDesc()).length);
        }
        catch (IOException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Encountered problems when trying to load the code for your lambdas. You may need to supply a lambdaClassLoader hint to Jinq to help it find your lambdas.", e);
            }
            return null;
        }
        catch (AnalyzerException e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not analyze lambda code", e);
            }
            return null;
        }
    }

    private static MethodAnalysisResults analyzeLambda(MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe, String className, String methodName, String methodSignature) throws IOException, AnalyzerException {
        PathAnalysisFactory pathAnalysisFactory = new PathAnalysisFactory((PathAnalysisMethodChecker)metamodel.getMethodChecker(isObjectEqualsSafe));
        TransformationClassAnalyzer classAnalyzer = new TransformationClassAnalyzer(className, alternateClassLoader);
        MethodAnalysisResults analysis = (MethodAnalysisResults)classAnalyzer.analyzeLambdaMethod(methodName, methodSignature, (PathAnalysisSupplementalFactory)pathAnalysisFactory);
        PathAnalysisSimplifier.cleanAndSimplify((MethodAnalysisResults)analysis, metamodel.getComparisonMethods(isObjectEqualsSafe));
        return analysis;
    }

    private static MethodAnalysisResults analyzeLambdaClass(Class<?> lambdaClass, MetamodelUtil metamodel, LambdaAsClassAnalysisConfig lambdaAsClass, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe) throws IOException, AnalyzerException {
        TransformationClassAnalyzer classAnalyzer = new TransformationClassAnalyzer(lambdaClass.getName(), alternateClassLoader);
        Method matchingMethod = lambdaAsClass.findLambdaMethod(lambdaClass);
        if (matchingMethod == null) {
            throw new AnalyzerException(null, "Could not find a lambda method with the expected name in the class");
        }
        PathAnalysisFactory pathAnalysisFactory = new PathAnalysisFactory((PathAnalysisMethodChecker)metamodel.getMethodChecker(isObjectEqualsSafe));
        MethodAnalysisResults analysis = (MethodAnalysisResults)classAnalyzer.analyzeLambdaMethod(matchingMethod.getName(), Type.getMethodDescriptor((Method)matchingMethod), (PathAnalysisSupplementalFactory)pathAnalysisFactory);
        PathAnalysisSimplifier.cleanAndSimplify((MethodAnalysisResults)analysis, metamodel.getComparisonMethods(isObjectEqualsSafe));
        return analysis;
    }

    LambdaAnalysis(Object lambda, SerializedLambda serializedLambda, MethodAnalysisResults symbolicAnalysis, int lambdaIndex) {
        this.numCapturedArgs = serializedLambda.capturedArgs.length;
        this.numLambdaArgs = Type.getArgumentTypes((String)serializedLambda.implMethodSignature).length;
        this.lambdaIndex = lambdaIndex;
        this.symbolicAnalysis = symbolicAnalysis;
        this.indirectCapturedArgs = null;
        this.usesParametersAsFields = false;
    }

    LambdaAnalysis(MethodAnalysisResults symbolicAnalysis, List<TypedValue> indirectCapturedArgs, int numLambdaArgs) {
        this.numCapturedArgs = indirectCapturedArgs.size();
        this.numLambdaArgs = numLambdaArgs;
        this.lambdaIndex = -1;
        this.symbolicAnalysis = symbolicAnalysis;
        this.indirectCapturedArgs = indirectCapturedArgs;
        this.usesParametersAsFields = false;
    }

    LambdaAnalysis(Object lambda, MethodAnalysisResults symbolicAnalysis, int numLambdaArgs, int lambdaIndex) {
        this.numCapturedArgs = 0;
        this.numLambdaArgs = numLambdaArgs;
        this.lambdaIndex = lambdaIndex;
        this.symbolicAnalysis = symbolicAnalysis;
        this.indirectCapturedArgs = null;
        this.usesParametersAsFields = true;
    }

    LambdaAnalysis(MethodAnalysisResults symbolicAnalysis, Map<String, TypedValue> indirectParamFields, int numLambdaArgs) {
        this.numCapturedArgs = 0;
        this.numLambdaArgs = numLambdaArgs;
        this.lambdaIndex = -1;
        this.symbolicAnalysis = symbolicAnalysis;
        this.indirectCapturedArgs = null;
        this.indirectParamFields = indirectParamFields;
        this.usesParametersAsFields = true;
    }

    public boolean usesIndirectArgs() {
        return this.indirectCapturedArgs != null;
    }

    public int getNumCapturedArgs() {
        return this.numCapturedArgs;
    }

    public int getNumLambdaArgs() {
        return this.numLambdaArgs;
    }

    public TypedValue getIndirectCapturedArg(int argIndex) {
        return this.indirectCapturedArgs.get(argIndex);
    }

    public int getLambdaIndex() {
        return this.lambdaIndex;
    }

    public TypedValue getIndirectFieldValue(String name) {
        return this.indirectParamFields.get(name);
    }

    public boolean usesIndirectFields() {
        return this.indirectParamFields != null;
    }

    public boolean usesParametersAsFields() {
        return this.usesParametersAsFields;
    }

    public static class LambdaAsClassAnalysisConfig {
        private static int countObjectParameters(Method m) {
            int count = 0;
            if (m.getReturnType().getName().equals("java.lang.Object")) {
                ++count;
            }
            for (Class<?> c : m.getParameterTypes()) {
                if (!c.getName().equals("java.lang.Object")) continue;
                ++count;
            }
            return count;
        }

        public Method findLambdaMethod(Class<?> lambdaClass) throws AnalyzerException {
            Method[] classMethods;
            String methodName = "apply";
            Method matchingMethod = null;
            for (Method m : classMethods = lambdaClass.getDeclaredMethods()) {
                if (m.getName().matches(methodName + "\\$mc[^$]*\\$sp")) {
                    matchingMethod = m;
                    break;
                }
                if (!m.getName().equals(methodName)) continue;
                if (matchingMethod != null) {
                    int oldCount;
                    int newCount = LambdaAsClassAnalysisConfig.countObjectParameters(m);
                    if (newCount == (oldCount = LambdaAsClassAnalysisConfig.countObjectParameters(matchingMethod))) {
                        throw new AnalyzerException(null, "Multiple methods have the expected name for the lambda");
                    }
                    if (newCount > oldCount) continue;
                }
                matchingMethod = m;
            }
            return matchingMethod;
        }

        public int getNumberOfLambdaArguments(Class<?> c) {
            try {
                if (Class.forName("scala.Function1").isAssignableFrom(c)) {
                    return 1;
                }
                if (Class.forName("scala.Function1").isAssignableFrom(c)) {
                    return 2;
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find Scala classes", e);
            }
            throw new IllegalArgumentException("Cannot determine number of arguments to the lambda function.");
        }
    }
}

