/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import com.user00.thunk.SerializedLambda;
import java.lang.reflect.Field;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.MetamodelUtil;
import org.objectweb.asm.Type;

public class LambdaInfo {
    protected Object Lambda;
    protected SerializedLambda serializedLambda;
    protected int numCapturedArgs;
    protected int numLambdaArgs;
    protected int lambdaIndex;

    public static LambdaInfo analyze(Object lambda, int lambdaIndex, boolean throwExceptionOnFailure) {
        SerializedLambda s;
        try {
            s = SerializedLambda.extractLambda((Object)lambda);
            if (s == null) {
                if (throwExceptionOnFailure) {
                    throw new IllegalArgumentException("Could not extract code from lambda. This error sometimes occurs because your lambda references objects that aren't Serializable.");
                }
                return null;
            }
        }
        catch (Exception e) {
            if (throwExceptionOnFailure) {
                throw new IllegalArgumentException("Could not extract code from lambda. This error sometimes occurs because your lambda references objects that aren't Serializable.");
            }
            return null;
        }
        return new LambdaInfo(lambda, s, lambdaIndex);
    }

    LambdaInfo(Object lambda, SerializedLambda serializedLambda, int lambdaIndex) {
        this.Lambda = lambda;
        this.serializedLambda = serializedLambda;
        this.lambdaIndex = lambdaIndex;
        this.numCapturedArgs = serializedLambda.capturedArgs.length;
        this.numLambdaArgs = Type.getArgumentTypes((String)serializedLambda.implMethodSignature).length;
    }

    protected LambdaInfo(int lambdaIndex, int numCapturedArgs, int numLambdaArgs) {
        this.Lambda = null;
        this.serializedLambda = null;
        this.lambdaIndex = lambdaIndex;
        this.numCapturedArgs = numCapturedArgs;
        this.numLambdaArgs = numLambdaArgs;
    }

    public int getNumCapturedArgs() {
        return this.numCapturedArgs;
    }

    public int getNumLambdaArgs() {
        return this.numLambdaArgs;
    }

    public boolean hasLambdaObject() {
        return this.serializedLambda != null;
    }

    public Object getCapturedArg(int argIndex) {
        return this.serializedLambda.capturedArgs[argIndex];
    }

    public Object getField(String fieldName) {
        try {
            Field field = this.Lambda.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(this.Lambda);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot read field " + fieldName + " of lambda", e);
        }
        catch (Exception e) {
            try {
                return this.Lambda.getClass().getField(fieldName).get(this.Lambda);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Cannot read field " + fieldName + " of lambda", e1);
            }
        }
    }

    public LambdaAnalysis fullyAnalyze(MetamodelUtil metamodel, ClassLoader alternateClassLoader, boolean isObjectEqualsSafe, boolean throwExceptionOnFailure) {
        return LambdaAnalysis.fullyAnalyzeLambda(this, metamodel, alternateClassLoader, isObjectEqualsSafe, throwExceptionOnFailure);
    }

    public String getLambdaSourceString() {
        return this.serializedLambda.implClass + "#" + this.serializedLambda.implMethodName + this.serializedLambda.implMethodSignature;
    }
}

