/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.jinq.jpa.transform.MetamodelUtilAttribute;
import org.jinq.jpa.transform.MethodChecker;
import org.objectweb.asm.Type;

public class MetamodelUtil {
    final Metamodel metamodel;
    private final Set<Class<?>> safeMethodAnnotations;
    final Map<MethodSignature, MetamodelUtilAttribute> fieldMethods;
    final Map<MethodSignature, MetamodelUtilAttribute> nLinkMethods;
    private final Set<MethodSignature> safeMethods;
    private final Set<MethodSignature> safeStaticMethods;
    final Map<String, List<Enum<?>>> enums;
    public final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods;
    public final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethodsWithObjectEquals;
    public static final MethodSignature inQueryStream = new MethodSignature("org/jinq/orm/stream/InQueryStreamSource", "stream", "(Ljava/lang/Class;)Lorg/jinq/orm/stream/JinqStream;");
    public static final Map<MethodSignature, Integer> TUPLE_ACCESSORS = new HashMap<MethodSignature, Integer>();

    public MetamodelUtil(Metamodel metamodel) {
        this.metamodel = metamodel;
        this.enums = new HashMap();
        this.comparisonMethods = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
        this.safeMethodAnnotations = new HashSet();
        this.safeMethodAnnotations.addAll(TransformationClassAnalyzer.SafeMethodAnnotations);
        this.safeMethods = new HashSet<MethodSignature>();
        this.safeMethods.addAll(TransformationClassAnalyzer.KnownSafeMethods);
        this.safeMethods.add(TransformationClassAnalyzer.integerIntValue);
        this.safeMethods.add(TransformationClassAnalyzer.longLongValue);
        this.safeMethods.add(TransformationClassAnalyzer.doubleDoubleValue);
        this.safeMethods.add(TransformationClassAnalyzer.booleanBooleanValue);
        this.safeMethods.add(inQueryStream);
        this.safeStaticMethods = new HashSet<MethodSignature>();
        this.safeStaticMethods.addAll(TransformationClassAnalyzer.KnownSafeStaticMethods);
        this.safeStaticMethods.add(TransformationClassAnalyzer.integerValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.longValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.doubleValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.booleanValueOf);
        this.fieldMethods = new HashMap<MethodSignature, MetamodelUtilAttribute>();
        this.nLinkMethods = new HashMap<MethodSignature, MetamodelUtilAttribute>();
        this.findMetamodelGetters();
        this.safeMethods.addAll(this.fieldMethods.keySet());
        this.safeMethods.addAll(this.nLinkMethods.keySet());
        this.comparisonMethodsWithObjectEquals = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>(this.comparisonMethods);
        this.comparisonMethodsWithObjectEquals.put(MethodChecker.objectEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
    }

    public void insertAssociationAttribute(MethodSignature sig, MetamodelUtilAttribute attribute, boolean isPlural) {
        if (isPlural) {
            this.nLinkMethods.put(sig, attribute);
        } else {
            this.fieldMethods.put(sig, attribute);
        }
        this.safeMethods.add(sig);
    }

    private void findMetamodelGetters() {
        for (EntityType entity : this.metamodel.getEntities()) {
            for (SingularAttribute singularAttrib : entity.getDeclaredSingularAttributes()) {
                Class fieldJavaType = singularAttrib.getJavaType();
                Member javaMember = singularAttrib.getJavaMember();
                String name = javaMember.getName();
                if (javaMember instanceof Field) {
                    name = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                MethodSignature methodSig = new MethodSignature(Type.getInternalName(javaMember.getDeclaringClass()), name, Type.getMethodDescriptor((Type)Type.getType((Class)fieldJavaType), (Type[])new Type[0]));
                if (fieldJavaType.isEnum()) {
                    String enumTypeName = Type.getInternalName((Class)fieldJavaType);
                    this.enums.put(enumTypeName, Arrays.asList(fieldJavaType.getEnumConstants()));
                    MethodSignature eqMethod = new MethodSignature(enumTypeName, "equals", "(Ljava/lang/Object;)Z");
                    this.comparisonMethods.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
                    this.safeMethods.add(eqMethod);
                }
                this.fieldMethods.put(methodSig, new MetamodelUtilAttribute((Attribute<?, ?>)singularAttrib));
            }
            for (PluralAttribute pluralAttrib : entity.getDeclaredPluralAttributes()) {
                Member javaMember = pluralAttrib.getJavaMember();
                String name = javaMember.getName();
                if (javaMember instanceof Field) {
                    name = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                MethodSignature methodSig = new MethodSignature(Type.getInternalName(javaMember.getDeclaringClass()), name, Type.getMethodDescriptor((Type)Type.getType((Class)pluralAttrib.getJavaType()), (Type[])new Type[0]));
                this.nLinkMethods.put(methodSig, new MetamodelUtilAttribute((Attribute<?, ?>)pluralAttrib));
            }
        }
    }

    public <U> String entityNameFromClass(Class<U> entity) {
        EntityType entityType = this.metamodel.entity(entity);
        if (entityType == null) {
            return null;
        }
        return entityType.getName();
    }

    public String entityNameFromClassName(String className) {
        for (EntityType entity : this.metamodel.getEntities()) {
            if (!entity.getJavaType().getName().equals(className)) continue;
            return entity.getName();
        }
        return null;
    }

    public boolean isSingularAttributeFieldMethod(MethodSignature sig) {
        return this.fieldMethods.containsKey(sig);
    }

    public String fieldMethodToFieldName(MethodSignature sig) {
        return this.fieldMethods.get(sig).getName();
    }

    public boolean isFieldMethodAssociationType(MethodSignature sig) {
        return this.fieldMethods.get(sig).isAssociation();
    }

    public boolean isPluralAttributeLinkMethod(MethodSignature sig) {
        return this.nLinkMethods.containsKey(sig);
    }

    public String nLinkMethodToLinkName(MethodSignature sig) {
        return this.nLinkMethods.get(sig).getName();
    }

    public boolean isKnownEnumType(String className) {
        return this.enums.containsKey(className);
    }

    public String getFullEnumConstantName(String className, String name) {
        List<Enum<?>> enumConstants = this.enums.get(className);
        if (enumConstants == null) {
            return null;
        }
        for (Enum<?> e : enumConstants) {
            if (!e.name().equals(name)) continue;
            return className.replace("/", ".") + "." + name;
        }
        return null;
    }

    public Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> getComparisonMethods(boolean withObjectEquals) {
        if (withObjectEquals) {
            return this.comparisonMethodsWithObjectEquals;
        }
        return this.comparisonMethods;
    }

    public Set<Class<?>> getSafeMethodAnnotations() {
        return this.safeMethodAnnotations;
    }

    public Set<MethodSignature> getSafeMethods() {
        return this.safeMethods;
    }

    public Set<MethodSignature> getSafeStaticMethods() {
        return this.safeStaticMethods;
    }

    public MethodChecker getMethodChecker(boolean isObjectEqualsSafe) {
        return new MethodChecker(this.getSafeMethodAnnotations(), this.getSafeMethods(), this.getSafeStaticMethods(), isObjectEqualsSafe);
    }

    static {
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetEight, 8);
    }
}

