/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.BasicSymbolicInterpreter;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MethodChecker
implements PathAnalysisMethodChecker {
    private final Set<Class<?>> safeMethodAnnotations;
    private final Set<MethodSignature> safeMethods;
    private final Set<MethodSignature> safeStaticMethods;
    private final boolean isObjectEqualsSafe;
    public static final MethodSignature objectEquals = new MethodSignature("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature jpqlLike = new MethodSignature("org/jinq/jpa/JPQL", "like", "(Ljava/lang/String;Ljava/lang/String;)Z");
    public static final MethodSignature mathSqrt = new MethodSignature("java/lang/Math", "sqrt", "(D)D");
    public static final MethodSignature mathAbsDouble = new MethodSignature("java/lang/Math", "abs", "(D)D");
    public static final MethodSignature mathAbsInt = new MethodSignature("java/lang/Math", "abs", "(I)I");
    public static final MethodSignature mathAbsLong = new MethodSignature("java/lang/Math", "abs", "(J)J");
    public static final MethodSignature bigDecimalAbs = new MethodSignature("java/math/BigDecimal", "abs", "()Ljava/math/BigDecimal;");
    public static final MethodSignature bigIntegerAbs = new MethodSignature("java/math/BigInteger", "abs", "()Ljava/math/BigInteger;");
    public static final MethodSignature stringToUpper = new MethodSignature("java/lang/String", "toUpperCase", "()Ljava/lang/String;");
    public static final MethodSignature stringToLower = new MethodSignature("java/lang/String", "toLowerCase", "()Ljava/lang/String;");
    public static final MethodSignature stringValueOfObject = new MethodSignature("java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
    public static final MethodSignature stringTrim = new MethodSignature("java/lang/String", "trim", "()Ljava/lang/String;");
    public static final MethodSignature stringLength = new MethodSignature("java/lang/String", "length", "()I");
    public static final MethodSignature stringSubstring = new MethodSignature("java/lang/String", "substring", "(II)Ljava/lang/String;");
    public static final MethodSignature stringIndexOf = new MethodSignature("java/lang/String", "indexOf", "(Ljava/lang/String;)I");
    static final Set<MethodSignature> jpqlFunctionMethods = new HashSet<MethodSignature>();
    static final Set<MethodSignature> jpqlFunctionStaticMethods = new HashSet<MethodSignature>();
    public static final MethodSignature streamSumInt;
    public static final MethodSignature streamSumDouble;
    public static final MethodSignature streamSumLong;
    public static final MethodSignature streamSumBigDecimal;
    public static final MethodSignature streamSumBigInteger;
    public static final MethodSignature streamMax;
    public static final MethodSignature streamMin;
    public static final MethodSignature streamAvg;
    public static final MethodSignature streamCount;
    public static final MethodSignature streamDistinct;
    public static final MethodSignature streamSelect;
    public static final MethodSignature streamWhere;
    public static final MethodSignature streamJoin;
    public static final MethodSignature streamGetOnlyValue;
    private static final Set<MethodSignature> subqueryMethods;

    MethodChecker(Set<Class<?>> safeMethodAnnotations, Set<MethodSignature> safeMethods, Set<MethodSignature> safeStaticMethods, boolean isObjectEqualsSafe) {
        this.safeMethodAnnotations = safeMethodAnnotations;
        this.safeMethods = safeMethods;
        this.safeStaticMethods = safeStaticMethods;
        this.isObjectEqualsSafe = isObjectEqualsSafe;
    }

    public BasicSymbolicInterpreter.OperationSideEffect isStaticMethodSafe(MethodSignature m) {
        return this.safeStaticMethods.contains(m) || jpqlFunctionStaticMethods.contains(m) ? BasicSymbolicInterpreter.OperationSideEffect.NONE : BasicSymbolicInterpreter.OperationSideEffect.UNSAFE;
    }

    public BasicSymbolicInterpreter.OperationSideEffect isMethodSafe(MethodSignature m, TypedValue base, List<TypedValue> args) {
        if (this.isObjectEqualsSafe && objectEquals.equals((Object)m)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        if (this.safeMethods.contains(m) || subqueryMethods.contains(m) || jpqlFunctionMethods.contains(m)) {
            return BasicSymbolicInterpreter.OperationSideEffect.NONE;
        }
        try {
            Method reflectedMethod = Annotations.asmMethodSignatureToReflectionMethod((MethodSignature)m);
            if (Annotations.methodHasSomeAnnotations((Method)reflectedMethod, this.safeMethodAnnotations)) {
                return BasicSymbolicInterpreter.OperationSideEffect.NONE;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            // empty catch block
        }
        return BasicSymbolicInterpreter.OperationSideEffect.UNSAFE;
    }

    public boolean isFluentChaining(MethodSignature sig) {
        return TransformationClassAnalyzer.stringBuilderAppendString.equals((Object)sig);
    }

    public boolean isPutFieldAllowed() {
        return false;
    }

    static {
        jpqlFunctionStaticMethods.add(jpqlLike);
        jpqlFunctionStaticMethods.add(mathSqrt);
        jpqlFunctionStaticMethods.add(mathAbsDouble);
        jpqlFunctionStaticMethods.add(mathAbsInt);
        jpqlFunctionStaticMethods.add(mathAbsLong);
        jpqlFunctionStaticMethods.add(stringValueOfObject);
        jpqlFunctionMethods.add(bigDecimalAbs);
        jpqlFunctionMethods.add(bigIntegerAbs);
        jpqlFunctionMethods.add(stringToUpper);
        jpqlFunctionMethods.add(stringToLower);
        jpqlFunctionMethods.add(stringTrim);
        jpqlFunctionMethods.add(stringLength);
        jpqlFunctionMethods.add(stringSubstring);
        jpqlFunctionMethods.add(stringIndexOf);
        streamSumInt = TransformationClassAnalyzer.streamSumInt;
        streamSumDouble = TransformationClassAnalyzer.streamSumDouble;
        streamSumLong = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumLong", "(Lorg/jinq/orm/stream/JinqStream$CollectLong;)Ljava/lang/Long;");
        streamSumBigDecimal = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumBigDecimal", "(Lorg/jinq/orm/stream/JinqStream$CollectBigDecimal;)Ljava/math/BigDecimal;");
        streamSumBigInteger = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumBigInteger", "(Lorg/jinq/orm/stream/JinqStream$CollectBigInteger;)Ljava/math/BigInteger;");
        streamMax = TransformationClassAnalyzer.streamMax;
        streamMin = TransformationClassAnalyzer.streamMin;
        streamAvg = new MethodSignature("org/jinq/orm/stream/JinqStream", "avg", "(Lorg/jinq/orm/stream/JinqStream$CollectNumber;)Ljava/lang/Double;");
        streamCount = new MethodSignature("org/jinq/orm/stream/JinqStream", "count", "()J");
        streamDistinct = new MethodSignature("org/jinq/orm/stream/JinqStream", "distinct", "()Lorg/jinq/orm/stream/JinqStream;");
        streamSelect = new MethodSignature("org/jinq/orm/stream/JinqStream", "select", "(Lorg/jinq/orm/stream/JinqStream$Select;)Lorg/jinq/orm/stream/JinqStream;");
        streamWhere = new MethodSignature("org/jinq/orm/stream/JinqStream", "where", "(Lorg/jinq/orm/stream/JinqStream$Where;)Lorg/jinq/orm/stream/JinqStream;");
        streamJoin = new MethodSignature("org/jinq/orm/stream/JinqStream", "join", "(Lorg/jinq/orm/stream/JinqStream$Join;)Lorg/jinq/orm/stream/JinqStream;");
        streamGetOnlyValue = new MethodSignature("org/jinq/orm/stream/JinqStream", "getOnlyValue", "()Ljava/lang/Object;");
        subqueryMethods = new HashSet<MethodSignature>();
        subqueryMethods.add(streamSumInt);
        subqueryMethods.add(streamSumDouble);
        subqueryMethods.add(streamSumLong);
        subqueryMethods.add(streamSumBigInteger);
        subqueryMethods.add(streamSumBigDecimal);
        subqueryMethods.add(streamMax);
        subqueryMethods.add(streamMin);
        subqueryMethods.add(streamAvg);
        subqueryMethods.add(streamCount);
        subqueryMethods.add(streamDistinct);
        subqueryMethods.add(streamSelect);
        subqueryMethods.add(streamWhere);
        subqueryMethods.add(streamJoin);
        subqueryMethods.add(streamGetOnlyValue);
    }
}

