/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.FromAliasExpression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ReadFieldExpression;
import org.jinq.jpa.jpqlquery.RecursiveExpressionVisitor;
import org.jinq.jpa.jpqlquery.RowReader;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.TupleRowReader;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JoinTransform;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToSubQuery;

public class OuterJoinTransform
extends JPQLOneLambdaQueryTransform {
    public OuterJoinTransform(JPQLQueryTransformConfiguration config) {
        super(config);
    }

    private boolean isChainedLink(Expression links) {
        if (links instanceof ReadFieldExpression) {
            return ((ReadFieldExpression)links).base instanceof ReadFieldExpression;
        }
        return false;
    }

    private boolean isLeftOuterJoinCompatible(SelectFromWhere<?> toMerge) {
        From from = toMerge.froms.get(0);
        if (!(from instanceof From.FromNavigationalLinks)) {
            return false;
        }
        Expression navLink = ((From.FromNavigationalLinks)from).links;
        while (!(navLink instanceof FromAliasExpression)) {
            if (!(navLink instanceof ReadFieldExpression)) {
                return false;
            }
            navLink = ((ReadFieldExpression)navLink).base;
        }
        return true;
    }

    private void rewriteFromAliases(SelectFromWhere<?> toMerge, final From oldFrom, final From newFrom) {
        for (Expression expr : toMerge.cols.columns) {
            expr.visit(new RecursiveExpressionVisitor(){

                @Override
                public void visitFromAlias(FromAliasExpression expr) {
                    if (expr.from == oldFrom) {
                        expr.from = newFrom;
                    }
                    super.visitFromAlias(expr);
                }
            });
        }
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, false));
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JPQLQuery returnExpr = (JPQLQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods()).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    From from = toMerge.froms.get(0);
                    if (!this.isLeftOuterJoinCompatible(toMerge)) {
                        throw new QueryTransformException("Left outer join must be applied to a navigational link");
                    }
                    From.FromNavigationalLinksLeftOuterJoin outerJoinFrom = From.forNavigationalLinksLeftOuterJoin((From.FromNavigationalLinks)from);
                    if (this.isChainedLink(outerJoinFrom.links)) {
                        ReadFieldExpression outerLinks = (ReadFieldExpression)outerJoinFrom.links;
                        From baseFrom = From.forNavigationalLinks(outerLinks.base);
                        ((SelectFromWhere)toReturn).froms.add(baseFrom);
                        outerJoinFrom.links = new ReadFieldExpression(new FromAliasExpression(baseFrom), outerLinks.field);
                    }
                    ((SelectFromWhere)toReturn).froms.add(outerJoinFrom);
                    this.rewriteFromAliases(toMerge, from, outerJoinFrom);
                    ((SelectFromWhere)toReturn).cols = new ColumnExpressions<U>(this.createPairReader(sfw.cols.reader, toMerge.cols.reader));
                    ((SelectFromWhere)toReturn).cols.columns.addAll(sfw.cols.columns);
                    ((SelectFromWhere)toReturn).cols.columns.addAll(toMerge.cols.columns);
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createPairReader(RowReader<?> a, RowReader<?> b) {
        return TupleRowReader.createReaderForTuple(TupleRowReader.PAIR_CLASS, a, b);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return OuterJoinTransform.class.getName();
    }
}

