/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserInfoInterceptor
extends HandlerInterceptorAdapter {
    private Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(GrantedAuthority.class, (Object)new JsonSerializer<GrantedAuthority>(){

        public JsonElement serialize(GrantedAuthority src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getAuthority());
        }
    }).create();
    @Autowired(required=false)
    private UserInfoService userInfoService;
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof Authentication) {
            request.setAttribute("userAuthorities", (Object)this.gson.toJson((Object)auth.getAuthorities()));
        }
        if (!this.trustResolver.isAnonymous(auth)) {
            UserInfo user;
            if (auth instanceof OIDCAuthenticationToken) {
                OIDCAuthenticationToken oidc = (OIDCAuthenticationToken)auth;
                if (oidc.getUserInfo() != null) {
                    request.setAttribute("userInfo", (Object)oidc.getUserInfo());
                    request.setAttribute("userInfoJson", (Object)oidc.getUserInfo().toJson());
                } else {
                    request.setAttribute("userInfo", null);
                    request.setAttribute("userInfoJson", (Object)"null");
                }
            } else if (auth != null && auth.getName() != null && this.userInfoService != null && (user = this.userInfoService.getByUsername(auth.getName())) != null) {
                request.setAttribute("userInfo", (Object)user);
                request.setAttribute("userInfoJson", (Object)user.toJson());
            }
        }
        return true;
    }
}

