/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.ShortFVComparison;
import org.openimaj.knn.pq.ShortADCNearestNeighbours;
import org.openimaj.knn.pq.ShortProductQuantiser;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

@Reference(type=ReferenceType.Article, author={"Jegou, Herve", "Douze, Matthijs", "Schmid, Cordelia"}, title="Product Quantization for Nearest Neighbor Search", year="2011", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"117", "", "128"}, url="http://dx.doi.org/10.1109/TPAMI.2010.57", month="January", number="1", publisher="IEEE Computer Society", volume="33", customData={"issn", "0162-8828", "numpages", "12", "doi", "10.1109/TPAMI.2010.57", "acmid", "1916695", "address", "Washington, DC, USA", "keywords", "High-dimensional indexing, High-dimensional indexing, image indexing, very large databases, approximate search., approximate search., image indexing, very large databases"})
public class ShortSDCNearestNeighbours
extends ShortADCNearestNeighbours {
    short[][][] distances;

    public ShortSDCNearestNeighbours(ShortProductQuantiser pq, short[][][] pqCentroids, short[][] dataPoints) {
        super(pq, dataPoints);
        this.distances = new short[pq.assigners.length][][];
        for (int i = 0; i < pq.assigners.length; ++i) {
            short[][] centroids = pqCentroids[i];
            this.distances[i] = new short[centroids.length][centroids.length];
            for (int j = 0; j < centroids.length; ++j) {
                for (int k = j; k < centroids.length; ++k) {
                    this.distances[i][j][k] = (short)ShortFVComparison.SUM_SQUARE.compare(centroids[j], centroids[k]);
                    this.distances[i][k][j] = this.distances[i][j][k];
                }
            }
        }
    }

    @Override
    protected void computeDistances(short[] fullQuery, BoundedPriorityQueue<IntFloatPair> queue, IntFloatPair workingPair) {
        byte[] query = this.pq.quantise(fullQuery);
        for (int i = 0; i < this.data.length; ++i) {
            workingPair.first = i;
            workingPair.second = 0.0f;
            for (int j = 0; j < query.length; ++j) {
                workingPair.second += (float)this.distances[j][query[j] + 128][this.data[i][j] + 128];
            }
            workingPair = (IntFloatPair)queue.offerItem((Object)workingPair);
        }
    }
}

