/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.feature.ByteFVComparison;
import org.openimaj.lsh.functions.BytePStableFactory;

public class ByteGaussianFactory
extends BytePStableFactory {
    public ByteGaussianFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng, w);
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected ByteFVComparison fvDistanceFunction() {
        return ByteFVComparison.EUCLIDEAN;
    }

    private class Function
    extends BytePStableFactory.PStableFunction {
        Function(int ndims, MersenneTwister rng) {
            super(ByteGaussianFactory.this, rng);
            Uniform uniform = new Uniform(0.0, ByteGaussianFactory.this.w, (RandomEngine)rng);
            Normal normal = new Normal(0.0, 1.0, (RandomEngine)rng);
            this.b = (float)uniform.nextDouble();
            this.r = new double[ndims];
            for (int i = 0; i < ndims; ++i) {
                this.r[i] = normal.nextDouble();
            }
        }
    }
}

