/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.feature.IntFVComparison;
import org.openimaj.lsh.functions.IntPStableFactory;

public class IntGaussianFactory
extends IntPStableFactory {
    public IntGaussianFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng, w);
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected IntFVComparison fvDistanceFunction() {
        return IntFVComparison.EUCLIDEAN;
    }

    private class Function
    extends IntPStableFactory.PStableFunction {
        Function(int ndims, MersenneTwister rng) {
            super(IntGaussianFactory.this, rng);
            Uniform uniform = new Uniform(0.0, IntGaussianFactory.this.w, (RandomEngine)rng);
            Normal normal = new Normal(0.0, 1.0, (RandomEngine)rng);
            this.b = (float)uniform.nextDouble();
            this.r = new double[ndims];
            for (int i = 0; i < ndims; ++i) {
                this.r[i] = normal.nextDouble();
            }
        }
    }
}

