/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.engine.MersenneTwister;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.lsh.functions.LongHashFunction;
import org.openimaj.lsh.functions.LongHashFunctionFactory;
import org.openimaj.util.array.SparseLongArray;

@Reference(type=ReferenceType.Inproceedings, author={"Datar, Mayur", "Immorlica, Nicole", "Indyk, Piotr", "Mirrokni, Vahab S."}, title="Locality-sensitive hashing scheme based on p-stable distributions", year="2004", booktitle="Proceedings of the twentieth annual symposium on Computational geometry", pages={"253", "", "262"}, url="http://doi.acm.org/10.1145/997817.997857", publisher="ACM", series="SCG '04")
public abstract class LongPStableFactory
extends LongHashFunctionFactory {
    double w;

    public LongPStableFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng);
        this.w = w;
    }

    protected abstract class PStableFunction
    extends LongHashFunction {
        protected double[] r;
        protected double b;

        PStableFunction(MersenneTwister rng) {
            super(rng);
        }

        public final int computeHashCode(long[] point) {
            double val = 0.0;
            for (int i = 0; i < point.length; ++i) {
                val += (double)point[i] * this.r[i];
            }
            val = (val + this.b) / LongPStableFactory.this.w;
            return (int)Math.floor(val);
        }

        @Override
        public int computeHashCode(SparseLongArray array) {
            double val = 0.0;
            for (SparseLongArray.Entry e : array.entries()) {
                val += (double)e.value * this.r[e.index];
            }
            val = (val + this.b) / LongPStableFactory.this.w;
            return (int)Math.floor(val);
        }
    }
}

