/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.sketch;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.util.hash.HashFunction;
import org.openimaj.util.hash.HashFunctionFactory;
import org.openimaj.util.sketch.Sketcher;

public class ByteLSHSketcher<OBJECT>
implements Sketcher<OBJECT, byte[]> {
    List<HashFunction<OBJECT>> hashFunctions;

    public ByteLSHSketcher(List<HashFunction<OBJECT>> functions) {
        this.hashFunctions = functions;
    }

    public ByteLSHSketcher(HashFunction<OBJECT> first, HashFunction<OBJECT> ... remainder) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        this.hashFunctions.add(first);
        for (HashFunction<OBJECT> r : remainder) {
            this.hashFunctions.add(r);
        }
    }

    public ByteLSHSketcher(HashFunctionFactory<OBJECT> factory, int nFuncs) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        for (int i = 0; i < nFuncs; ++i) {
            this.hashFunctions.add(factory.create());
        }
    }

    public byte[] createSketch(OBJECT input) {
        int nele = this.arrayLength();
        byte[] sketch = new byte[nele];
        int j = 0;
        for (int i = 0; i < nele; ++i) {
            for (int k = 0; k < 8; ++k) {
                int hash = this.hashFunctions.get(j++).computeHashCode(input);
                sketch[i] = (byte)(sketch[i] | (byte)hash << k);
            }
        }
        return sketch;
    }

    public int bitLength() {
        return this.hashFunctions.size();
    }

    public int arrayLength() {
        return (int)Math.ceil((double)this.hashFunctions.size() / 8.0);
    }
}

