/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.u.U;

public class BufRange
extends RapidoidThing {
    public static final BufRange NONE = new BufRange();
    public int start = -1;
    public int length = 0;

    public BufRange() {
    }

    public BufRange(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public BufRange reset() {
        this.start = -1;
        this.length = 0;
        return this;
    }

    public int limit() {
        return this.start + this.length;
    }

    public int last() {
        return this.start + this.length - 1;
    }

    public String toString() {
        return this.isEmpty() ? "[]" : "[" + this.start + ":" + this.length + "]";
    }

    public boolean isEmpty() {
        return this.start < 0 || this.length <= 0;
    }

    public void ends(int endPos) {
        this.length = endPos - this.start;
    }

    public void starts(int startPos) {
        this.start = startPos;
    }

    public void set(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public void setInterval(int start, int limit) {
        assert (start <= limit);
        this.start = start;
        this.length = limit - start;
    }

    public String get(String whole) {
        return this.start >= 0 ? whole.substring(this.start, this.start + this.length) : "";
    }

    public byte[] bytes(Buf src) {
        byte[] bytes = new byte[this.length];
        src.get(this, bytes, 0);
        return bytes;
    }

    public long backup() {
        long backup = this.start;
        backup -= Integer.MIN_VALUE;
        backup <<= 32;
        return backup += (long)this.length;
    }

    public void restore(long backup) {
        this.length = (int)backup;
        this.start = (int)(((backup -= (long)this.length) >>> 32) + Integer.MIN_VALUE);
    }

    public boolean sameAs(long backup) {
        int len = (int)backup;
        if (len != this.length) {
            return false;
        }
        int st = (int)(((backup -= (long)len) >>> 32) + Integer.MIN_VALUE);
        return st == this.start;
    }

    public static BufRange fromTo(int from, int to) {
        U.must((from <= to ? 1 : 0) != 0, (String)"Invalid range!");
        return new BufRange(from, to - from);
    }

    public String str(Buf buf) {
        return BytesUtil.get(buf.bytes(), this);
    }

    public String str(Bytes bytes) {
        return BytesUtil.get(bytes, this);
    }

    public void assign(BufRange range) {
        this.set(range.start, range.length);
    }

    public void strip(int left, int right) {
        this.start += left;
        this.length -= left + right;
    }
}

