/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.data;

import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.data.BufRange;
import org.rapidoid.u.U;

public class BufRanges
extends RapidoidThing {
    public final BufRange[] ranges;
    public int count;

    public BufRanges(int capacity) {
        this.ranges = new BufRange[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.ranges[i] = new BufRange();
            this.ranges[i].reset();
        }
    }

    public BufRanges reset() {
        for (int i = 0; i < this.count; ++i) {
            this.ranges[i].reset();
        }
        this.count = 0;
        return this;
    }

    public BufRange getByPrefix(Bytes bytes, byte[] prefix, boolean caseSensitive) {
        return BytesUtil.getByPrefix(bytes, this, prefix, caseSensitive);
    }

    public String toString() {
        return super.toString() + "[" + this.count + "]";
    }

    public int max() {
        return this.ranges.length;
    }

    public String str(Bytes bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("<");
            sb.append(this.ranges[i].str(bytes));
            sb.append(">");
        }
        sb.append("]");
        return sb.toString();
    }

    public String str(Buf buf) {
        return this.str(buf.bytes());
    }

    public int add() {
        if (this.count >= this.max()) {
            throw U.rte((String)"too many key-values!");
        }
        return this.count++;
    }

    public void add(int start, int length) {
        if (this.count >= this.max()) {
            throw U.rte((String)"too many key-values!");
        }
        this.ranges[this.count++].set(start, length);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public List<String> toList(Bytes bytes, int from, int to) {
        List list = U.list();
        for (int i = from; i <= to; ++i) {
            String s = this.ranges[i].str(bytes);
            list.add(s);
        }
        return list;
    }

    public Map<String, String> toMap(Bytes bytes, int from, int to, String separator) {
        Map map = U.map();
        for (int i = from; i <= to; ++i) {
            String s = this.ranges[i].str(bytes);
            String[] kv = s.split(separator, 2);
            map.put(kv[0], kv.length > 1 ? kv[1] : "");
        }
        return map;
    }

    public String getConcatenated(Bytes bytes, int from, int to, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i <= to; ++i) {
            if (i > from && !U.isEmpty((String)separator)) {
                sb.append(separator);
            }
            sb.append(this.ranges[i].str(bytes));
        }
        return sb.toString();
    }

    public BufRange get(int index) {
        assert (index >= 0 && index < this.count);
        return this.ranges[index];
    }

    public BufRange first() {
        return this.get(0);
    }

    public BufRange last() {
        return this.get(this.count - 1);
    }
}

