/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.rapidoid.commons.MediaType;
import org.rapidoid.commons.RapidoidInfo;
import org.rapidoid.config.Conf;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.JobStatusListener;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.data.BinaryMultiData;
import org.rapidoid.data.Data;
import org.rapidoid.data.JSON;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeInternals;
import org.rapidoid.http.HttpHeader;
import org.rapidoid.http.HttpInterception;
import org.rapidoid.http.HttpNotFoundException;
import org.rapidoid.http.HttpOutputStream;
import org.rapidoid.http.HttpProtocol;
import org.rapidoid.http.HttpResponse;
import org.rapidoid.http.HttpResponses;
import org.rapidoid.http.HttpSuccessException;
import org.rapidoid.http.LowLevelHttpExchange;
import org.rapidoid.http.PageStack;
import org.rapidoid.http.Req;
import org.rapidoid.http.Response;
import org.rapidoid.http.Scopes;
import org.rapidoid.http.fast.HttpParser;
import org.rapidoid.http.session.SessionStore;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.plugins.templates.ITemplate;
import org.rapidoid.plugins.templates.Templates;
import org.rapidoid.security.Secure;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.RapidoidConf;
import org.rapidoid.util.UTILS;
import org.rapidoid.webapp.AppCtx;
import org.rapidoid.webapp.WebApp;
import org.rapidoid.wire.Wire;
import org.rapidoid.wrap.BoolWrap;

public class HttpExchangeImpl
extends DefaultExchange<HttpExchangeImpl>
implements LowLevelHttpExchange,
HttpExchangeInternals,
HttpInterception,
Constants,
JobStatusListener {
    public static final String SESSION_COOKIE = "JSESSIONID";
    public static final String COOKIEPACK_COOKIE = "COOKIEPACK";
    private static final String COOKIPACK_SESSION = "_session_";
    private static final HttpParser PARSER = (HttpParser)Wire.singleton(HttpParser.class);
    private static volatile ITemplate PAGE_TEMPLATE;
    private static final byte[] HEADER_SEP;
    final Range rUri = new Range();
    final Range rVerb = new Range();
    final Range rPath = new Range();
    final Range rQuery = new Range();
    final Range rProtocol = new Range();
    final Ranges headers = new Ranges(50);
    private final KeyValueRanges params = new KeyValueRanges(50);
    private final KeyValueRanges headersKV = new KeyValueRanges(50);
    private final KeyValueRanges cookies = new KeyValueRanges(50);
    private final KeyValueRanges posted = new KeyValueRanges(50);
    private final KeyValueRanges files = new KeyValueRanges(50);
    final Range rBody = new Range();
    final Range multipartBoundary = new Range();
    private final Range subpathRange = new Range();
    final BoolWrap isGet = new BoolWrap();
    final BoolWrap isKeepAlive = new BoolWrap();
    private boolean parsedParams;
    private boolean parsedHeaders;
    private boolean parsedBody;
    private int responseBodyPos;
    private int responseContentLengthPos;
    private boolean writesResponseBody;
    private MediaType responseContentType;
    private int responseStartingPos;
    private String path = null;
    private String home = "/";
    private String[] pathSegments;
    private HttpResponses responses;
    private Map<String, Object> data;
    private Map<String, String> errors;
    private Map<String, Object> model;
    private String resourceName;
    private boolean resourceNameHasExtension;
    private Map<String, Serializable> session;
    private Map<String, Serializable> cookiepack;
    private Map<String, Serializable> locals;
    private Map<String, Object> tmps;
    private final Data _body;
    private final Data _uri;
    private final Data _verb;
    private final Data _path;
    private final Data _subpath;
    private final Data _query;
    private final Data _protocol;
    private final MultiData _params;
    private final MultiData _headers;
    private final MultiData _cookies;
    private final BinaryMultiData _files;
    private volatile Map<String, Object> postedData;
    private int responseCode;
    private String redirectUrl;
    private String sessionId;
    private Throwable error;
    private boolean complete;
    private boolean lowLevelProcessing;
    private ClassLoader classLoader;
    private SessionStore sessionStore;
    private Handler handler;
    private final Callable<Map<String, Object>> lazyData = new Callable<Map<String, Object>>(){

        @Override
        public Map<String, Object> call() throws Exception {
            return HttpExchangeImpl.this.data();
        }
    };
    private final Callable<Map<String, byte[]>> lazyFiles = new Callable<Map<String, byte[]>>(){

        @Override
        public Map<String, byte[]> call() throws Exception {
            return HttpExchangeImpl.this.files();
        }
    };
    private final Callable<Map<String, String>> lazyCookies = new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            return HttpExchangeImpl.this.cookies();
        }
    };
    private final Callable<Map<String, String>> lazyHeaders = new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            return HttpExchangeImpl.this.headers();
        }
    };

    public HttpExchangeImpl() {
        this._body = this.data(this.rBody);
        this._uri = this.data(this.rUri);
        this._verb = this.data(this.rVerb);
        this._path = this.decodedData(this.rPath);
        this._subpath = this.decodedData(this.subpathRange);
        this._query = this.decodedData(this.rQuery);
        this._protocol = this.data(this.rProtocol);
        this._params = this.multiData(this.params);
        this._headers = this.multiData(this.headersKV);
        this._cookies = this.multiData(this.cookies);
        this._files = this.binaryMultiData(this.files);
        this.reset();
    }

    public synchronized void reset() {
        super.reset();
        this.isGet.value = false;
        this.isKeepAlive.value = false;
        this.tmps = null;
        this.rVerb.reset();
        this.rUri.reset();
        this.rPath.reset();
        this.rQuery.reset();
        this.rProtocol.reset();
        this.rBody.reset();
        this.multipartBoundary.reset();
        this.params.reset();
        this.headersKV.reset();
        this.headers.reset();
        this.cookies.reset();
        this.posted.reset();
        this.files.reset();
        this.data = null;
        this.model = null;
        this.path = null;
        this.home = "/";
        this.postedData = null;
        this.parsedParams = false;
        this.parsedHeaders = false;
        this.parsedBody = false;
        this.sessionId = null;
        this.classLoader = null;
        this.sessionStore = null;
        this.handler = null;
        this.session = null;
        this.cookiepack = null;
        this.locals = null;
        this.tmps = null;
        this.errors = null;
        this._body.reset();
        this._uri.reset();
        this._verb.reset();
        this._path.reset();
        this._subpath.reset();
        this._query.reset();
        this._protocol.reset();
        this._params.reset();
        this._headers.reset();
        this._cookies.reset();
        this._files.reset();
        this.resetResponse();
    }

    private void resetResponse() {
        this.writesResponseBody = false;
        this.responseBodyPos = -1;
        this.responseContentLengthPos = -1;
        this.responseContentType = null;
        this.responses = null;
        this.responseCode = -1;
        this.redirectUrl = null;
        this.error = null;
        this.complete = false;
        this.lowLevelProcessing = false;
    }

    public void log(String msg) {
        this.conn.log(msg);
    }

    @Override
    public synchronized MultiData params_() {
        if (!this.parsedParams) {
            if (!this.rQuery.isEmpty()) {
                PARSER.parseParams(this.input(), this.params, this.query_().range());
            }
            this.parsedParams = true;
        }
        return this._params;
    }

    @Override
    public synchronized MultiData headers_() {
        if (!this.parsedHeaders) {
            if (!this.headers.isEmpty()) {
                PARSER.parseHeadersIntoKV(this.input(), this.headers, this.headersKV, this.cookies, this.helper());
            }
            this.parsedHeaders = true;
        }
        return this._headers;
    }

    @Override
    public synchronized MultiData cookies_() {
        if (!this.parsedHeaders) {
            if (!this.headers.isEmpty()) {
                PARSER.parseHeadersIntoKV(this.input(), this.headers, this.headersKV, this.cookies, this.helper());
            }
            this.parsedHeaders = true;
        }
        return this._cookies;
    }

    @Override
    public synchronized BinaryMultiData files_() {
        this.doParseBody();
        return this._files;
    }

    private void doParseBody() {
        if (!this.parsedBody) {
            this.parsedBody = true;
            this.postedData = U.map();
            PARSER.parsePosted(this.input(), this.headersKV, this.rBody, this.posted, this.files, this.helper(), this.postedData);
        }
    }

    @Override
    public synchronized Data subpath_() {
        return this._subpath;
    }

    @Override
    public synchronized Data body_() {
        return this._body;
    }

    @Override
    public synchronized Data uri_() {
        return this._uri;
    }

    @Override
    public synchronized Data verb_() {
        return this._verb;
    }

    @Override
    public synchronized Data path_() {
        return this._path;
    }

    @Override
    public synchronized Data protocol_() {
        return this._protocol;
    }

    @Override
    public synchronized Data query_() {
        return this._query;
    }

    public synchronized void setSubpath(int start, int end) {
        this.subpathRange.setInterval(start, end);
    }

    public synchronized HttpExchangeImpl done() {
        if (this.isAsync()) {
            this.completeResponse();
            this.conn.done();
        }
        return this;
    }

    @Override
    public synchronized HttpExchangeImpl send() {
        this.conn.send();
        return this;
    }

    public synchronized String toString() {
        return "HttpExchange [uri=" + this.uri() + "]";
    }

    public synchronized String verb() {
        return this.isGet.value ? "GET" : this.verb_().get();
    }

    public synchronized String uri() {
        return this.uri_().get();
    }

    public synchronized String path() {
        if (this.path == null) {
            this.path = this.path_().get();
        }
        return this.path;
    }

    public synchronized String subpath() {
        String subp = this.subpath_().get();
        return !U.isEmpty((String)subp) ? subp : "/";
    }

    public synchronized String query() {
        return this.query_().get();
    }

    public synchronized String protocol() {
        return this.protocol_().get();
    }

    public synchronized byte[] body() {
        return this.body_().get().getBytes();
    }

    public synchronized Map<String, String> params() {
        Map reqParams = this.params_().get();
        reqParams.remove("_embedded");
        return reqParams;
    }

    public synchronized String param(String name) {
        return (String)U.notNull((Object)this.params_().get(name), (String)"PARAM[%s]", (Object[])new Object[]{name});
    }

    public synchronized String param(String name, String defaultValue) {
        return (String)U.or((Object)this.params_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, String> headers() {
        return this.headers_().get();
    }

    public synchronized String header(String name) {
        return (String)U.notNull((Object)this.headers_().get(name), (String)"HEADERS[%s]", (Object[])new Object[]{name});
    }

    public synchronized String header(String name, String defaultValue) {
        return (String)U.or((Object)this.headers_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, String> cookies() {
        return this.cookies_().get();
    }

    public synchronized String cookie(String name) {
        return (String)U.notNull((Object)this.cookies_().get(name), (String)"COOKIES[%s]", (Object[])new Object[]{name});
    }

    public synchronized String cookie(String name, String defaultValue) {
        return (String)U.or((Object)this.cookies_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, Object> posted() {
        this.doParseBody();
        return this.postedData;
    }

    public synchronized <T extends Serializable> T posted(String name) {
        return (T)((Serializable)U.notNull((Object)this.posted().get(name), (String)"POSTED[%s]", (Object[])new Object[]{name}));
    }

    public synchronized <T extends Serializable> T posted(String name, T defaultValue) {
        return (T)((Serializable)U.or((Object)this.posted().get(name), defaultValue));
    }

    public synchronized Map<String, byte[]> files() {
        return this.files_().get();
    }

    public synchronized byte[] file(String name) {
        return (byte[])U.notNull((Object)this.files_().get(name), (String)"FILE[%s]", (Object[])new Object[]{name});
    }

    public synchronized byte[] file(String name, byte[] defaultValue) {
        return (byte[])U.or((Object)this.files_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, Object> data() {
        if (this.data == null) {
            this.data = U.synchronizedMap();
            this.data.putAll(this.params());
            this.data.putAll(this.posted());
        }
        return this.data;
    }

    public synchronized <T> T data(String name) {
        return (T)U.notNull((Object)this.data().get(name), (String)"DATA[%s]", (Object[])new Object[]{name});
    }

    public synchronized <T> T data(String name, T defaultValue) {
        return (T)U.or((Object)this.data().get(name), defaultValue);
    }

    @Override
    public synchronized Data host_() {
        return this.headers_().get_("host");
    }

    public synchronized String host() {
        return this.headers_().get("host");
    }

    public synchronized HttpExchange addHeader(byte[] name, byte[] value) {
        U.must((!this.writesResponseBody ? 1 : 0) != 0, (String)"Cannot add header because the body is being rendered already!");
        if (this.responseCode <= 0) {
            this.responseCode(200);
        }
        super.write(name);
        super.write(HEADER_SEP);
        super.write(value);
        super.write(CR_LF);
        return this;
    }

    private HttpExchange responseCode(int responseCode) {
        if (this.responseCode > 0) {
            assert (this.responseStartingPos >= 0);
            this.output().deleteAfter(this.responseStartingPos);
        }
        this.responseCode = responseCode;
        this.responseStartingPos = this.output().size();
        HttpResponse resp = this.responses.get(responseCode, this.isKeepAlive.value);
        assert (resp != null);
        this.output().append(resp.bytes());
        this.responseContentLengthPos = this.responseStartingPos + resp.contentLengthPos + 10;
        this.responseContentType = null;
        this.writesResponseBody = false;
        this.responseBodyPos = -1;
        return this;
    }

    public synchronized void completeResponse() {
        if (this.complete) {
            return;
        }
        this.finish();
        if (!this.lowLevelProcessing) {
            U.must((this.responseCode >= 100 ? 1 : 0) != 0, (String)"Invalid response code: %s, URI=%s", (Object)this.responseCode, (Object)this.uri());
            this.write(new byte[0]);
            U.must((this.responseBodyPos >= 0 ? 1 : 0) != 0);
            long responseSize = this.output().size() - this.responseBodyPos;
            U.must((responseSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Response too big!");
            this.output().putNumAsText(this.responseContentLengthPos, responseSize, false);
            this.closeIf(!this.isKeepAlive.value);
        }
        this.complete = true;
    }

    public synchronized HttpExchange addHeader(HttpHeader name, String value) {
        this.addHeader(name.getBytes(), value.getBytes());
        return this;
    }

    public synchronized HttpExchange setCookie(String name, String value, String ... extras) {
        String cookie = name + "=" + value;
        if (extras.length > 0) {
            cookie = cookie + "; " + U.join((String)"; ", (Object[])extras);
        }
        this.addHeader(HttpHeader.SET_COOKIE, cookie);
        return this;
    }

    public synchronized HttpExchange setContentType(MediaType mediaType) {
        U.must((this.responseContentType == null ? 1 : 0) != 0, (String)"Content type was already set!");
        if (mediaType == null) {
            mediaType = MediaType.BINARY;
        }
        this.addHeader(HttpHeader.CONTENT_TYPE.getBytes(), mediaType.getBytes());
        this.responseContentType = mediaType;
        return this;
    }

    public synchronized HttpExchange plain() {
        return this.setContentType(MediaType.PLAIN_TEXT_UTF_8);
    }

    public synchronized HttpExchange html() {
        return this.setContentType(MediaType.HTML_UTF_8);
    }

    public synchronized HttpExchange json() {
        return this.setContentType(MediaType.JSON_UTF_8);
    }

    public synchronized HttpExchange binary() {
        return this.setContentType(MediaType.BINARY);
    }

    public synchronized HttpExchange download(String filename) {
        this.addHeader(HttpHeader.CONTENT_DISPOSITION, "attachment; filename=\"" + filename + "\"");
        this.addHeader(HttpHeader.CACHE_CONTROL, "private");
        return this.binary();
    }

    public synchronized void ensureHeadersComplete() {
        if (!this.writesResponseBody) {
            this.beforeClosingHeaders();
            if (this.responseContentType == null) {
                this.html();
            }
            this.writesResponseBody = true;
            this.write(CR_LF);
            this.responseBodyPos = this.output().size();
        }
    }

    public synchronized HttpExchangeImpl write(String s) {
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.write(s);
    }

    public synchronized HttpExchangeImpl writeln(String s) {
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.writeln(s);
    }

    public synchronized HttpExchangeImpl write(byte[] bytes) {
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.write(bytes);
    }

    public synchronized HttpExchangeImpl write(byte[] bytes, int offset, int length) {
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.write(bytes, offset, length);
    }

    public synchronized HttpExchangeImpl write(ByteBuffer buf) {
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.write(buf);
    }

    public synchronized HttpExchangeImpl write(File file) {
        if (!this.hasContentType()) {
            this.download(file.getName());
        }
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.write(file);
    }

    public synchronized HttpExchangeImpl writeJSON(Object value) {
        if (!this.hasContentType()) {
            this.json();
        }
        this.ensureHeadersComplete();
        return (HttpExchangeImpl)super.writeJSON(value);
    }

    public synchronized boolean isInitial() {
        return this.conn.isInitial();
    }

    public synchronized ConnState state() {
        return this.conn.state();
    }

    public synchronized boolean hasContentType() {
        return this.responseContentType != null;
    }

    public MediaType getResponseContentType() {
        return this.responseContentType;
    }

    public synchronized HttpExchange sendFile(File file) {
        U.must((boolean)file.exists());
        this.setContentType(MediaType.getByFileName((String)file.getAbsolutePath()));
        this.write(file);
        this.done();
        return this;
    }

    public synchronized HttpExchange sendFile(Res resource) {
        U.must((boolean)resource.exists());
        this.setContentType(MediaType.getByFileName((String)resource.getShortName()));
        this.write(resource.getBytes());
        this.done();
        return this;
    }

    public synchronized HttpExchange sendFile(MediaType mediaType, byte[] bytes) {
        this.setContentType(mediaType);
        this.write(bytes);
        this.done();
        return this;
    }

    public synchronized HttpSuccessException redirect(String url) {
        this.responseCode(303);
        this.addHeader(HttpHeader.LOCATION, url);
        this.redirectUrl = url;
        this.ensureHeadersComplete();
        throw this.error();
    }

    public synchronized String redirectUrl() {
        return this.redirectUrl;
    }

    public synchronized HttpExchange response(int httpResponseCode) {
        return this.response(httpResponseCode, null, null);
    }

    public synchronized HttpExchange response(int httpResponseCode, String response) {
        return this.response(httpResponseCode, response, null);
    }

    public synchronized HttpExchange response(int httpResponseCode, String response, Throwable err) {
        this.responseCode(httpResponseCode);
        this.ensureHeadersComplete();
        String title = (String)U.or((Object)response, (Object)"Internal server error!");
        if (err != null) {
            String details = err.getMessage();
            details = U.trimr((String)details, (String)"(<Unknown Source>#1)");
            this.renderPage(U.map((Object)"title", (Object)title, (Object)"error", (Object)true, (Object)"code", (Object)httpResponseCode, (Object)"navbar", (Object)(!U.isEmpty((String)title) ? 1 : 0), (Object)"details", (Object)details));
        } else {
            this.renderPage(U.map((Object)"title", (Object)title, (Object)"code", (Object)httpResponseCode, (Object)"error", (Object)(httpResponseCode >= 400 ? 1 : 0)));
        }
        return this;
    }

    public synchronized HttpExchange startResponse(int httpResponseCode) {
        return this.responseCode(httpResponseCode);
    }

    public synchronized String constructUrl(String path) {
        return (Conf.is((String)"https") ? "https://" : "http://") + this.host() + path;
    }

    public synchronized HttpNotFoundException notFound() {
        this.response(404, "Page not found!");
        throw HttpNotFoundException.get();
    }

    public synchronized UserInfo user() {
        return this.cookiepack != null ? UserInfo.from(this.cookiepack()) : null;
    }

    public synchronized boolean isGetReq() {
        return this.isGet.value;
    }

    public synchronized boolean isPostReq() {
        return !this.isGet.value && this.verb().equals("POST");
    }

    @Override
    public synchronized byte[] serializeLocals() {
        return this.locals != null ? UTILS.serialize(this.locals) : null;
    }

    @Override
    public synchronized void deserializeLocals(byte[] bytes) {
        this.locals = (Map)UTILS.deserialize((byte[])bytes);
    }

    @Override
    public synchronized byte[] serializeCookiepack() {
        return this.cookiepack != null ? UTILS.serialize(this.cookiepack) : null;
    }

    @Override
    public synchronized void deserializeCookiepack(byte[] bytes) {
        this.cookiepack = (Map)UTILS.deserialize((byte[])bytes);
    }

    public synchronized OutputStream outputStream() {
        return new HttpOutputStream(this);
    }

    public synchronized boolean isDevMode() {
        return AppCtx.app().dev();
    }

    public synchronized int responseCode() {
        return this.responseCode;
    }

    @Override
    public synchronized HttpExchange exchange() {
        return this;
    }

    @Override
    public synchronized boolean hasError() {
        return this.error != null;
    }

    @Override
    public synchronized Throwable getError() {
        return this.error;
    }

    public synchronized String pathSegment(int segmentIndex) {
        return this.pathSegments()[segmentIndex];
    }

    public synchronized String[] pathSegments() {
        if (this.pathSegments == null) {
            this.pathSegments = U.triml((String)this.path(), (String)"/").split("/");
        }
        return this.pathSegments;
    }

    public synchronized HttpExchange accessDeniedIf(boolean accessDeniedCondition) {
        if (accessDeniedCondition) {
            throw new SecurityException("Access denied!");
        }
        return this;
    }

    public synchronized HttpExchange error(Throwable err) {
        Throwable cause = UTILS.rootCause((Throwable)err);
        if (cause instanceof HttpSuccessException) {
            return this;
        }
        if (cause instanceof HttpNotFoundException) {
            throw this.notFound();
        }
        if (cause instanceof SecurityException) {
            return this.response(500, "Access Denied!", cause);
        }
        return this.response(500, "Internal server error!", cause);
    }

    public synchronized HttpExchange authorize(Class<?> clazz) {
        return this.accessDeniedIf(!Secure.canAccessClass((String)Ctxs.ctx().username(), clazz));
    }

    public synchronized boolean serveStaticFile() {
        if (this.serveStaticFile(this.name())) {
            return true;
        }
        return !this.resourceNameHasExtension() && this.serveStaticFile(this.name() + ".html");
    }

    public synchronized boolean serveStaticFile(String filename) {
        String firstFile = Conf.staticPath() + "/" + filename;
        String defaultFile = Conf.staticPathDefault() + "/" + filename;
        Res res = Res.from((String)filename, (boolean)true, (String[])new String[]{firstFile, defaultFile});
        if (res.exists()) {
            this.sendFile(res);
            return true;
        }
        return false;
    }

    public synchronized HttpSuccessException goBack(int steps) {
        throw PageStack.goBack(this, steps);
    }

    public synchronized HttpExchange addToPageStack() {
        PageStack.addToPageStack(this);
        return this;
    }

    public synchronized void init(HttpResponses responses, SessionStore sessionStore) {
        this.responses = responses;
        this.sessionStore = sessionStore;
        String cookiepack = this.cookie(COOKIEPACK_COOKIE, null);
        if (!U.isEmpty((String)cookiepack) && !cookiepack.equals("null")) {
            String cpackStr = '\"' + cookiepack + '\"';
            byte[] cpbytes = JSON.parseBytes((String)cpackStr);
            this.deserializeCookiepack(cpbytes);
        }
    }

    public HttpSuccessException error() {
        return HttpSuccessException.get();
    }

    @Override
    public synchronized void lowLevelProcessing() {
        this.lowLevelProcessing = true;
    }

    public synchronized boolean isLowLevelProcessing() {
        return this.lowLevelProcessing;
    }

    public boolean isClosing() {
        return this.conn.isClosing();
    }

    public boolean isClosed() {
        return this.conn.isClosed();
    }

    public void waitUntilClosing() {
        this.conn.waitUntilClosing();
    }

    public String realIpAddress() {
        return this.header("X-Forwarded-For", this.address());
    }

    @Override
    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public synchronized ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public synchronized void setSessionStore(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    public synchronized SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public synchronized boolean hasErrors() {
        return !U.isEmpty(this.errors);
    }

    public synchronized Map<String, String> errors() {
        if (this.errors == null) {
            this.errors = U.synchronizedMap();
        }
        return this.errors;
    }

    public synchronized Map<String, Object> attrs() {
        if (this.tmps == null) {
            this.tmps = U.synchronizedMap();
        }
        return this.tmps;
    }

    public synchronized Map<String, Serializable> cookiepack() {
        if (this.cookiepack == null) {
            this.cookiepack = U.synchronizedMap();
        }
        return this.cookiepack;
    }

    public synchronized Map<String, Serializable> locals() {
        if (this.locals == null) {
            this.locals = U.synchronizedMap();
        }
        return this.locals;
    }

    public synchronized Map<String, Serializable> session() {
        if (this.session == null) {
            if (RapidoidConf.stateless()) {
                this.session = U.synchronizedMap();
                this.cookiepack().put(COOKIPACK_SESSION, UTILS.serializable(this.session));
            } else {
                this.session = this.sessionStore.get(this.sessionId());
            }
        }
        return this.session;
    }

    public synchronized <T extends Serializable> T session(String name, T defaultValue) {
        return Scopes.get("session", this.session, name, defaultValue);
    }

    public synchronized <T extends Serializable> T session(String name) {
        return (T)((Serializable)Scopes.get("session", this.session, name));
    }

    public synchronized <T extends Serializable> T sessionGetOrCreate(String name, Class<T> valueClass, Object ... constructorArgs) {
        return (T)((Serializable)Scopes.getOrCreate("session", this.session(), name, valueClass, constructorArgs));
    }

    public synchronized <T extends Serializable> T cookiepack(String name, T defaultValue) {
        return Scopes.get("cookiepack", this.cookiepack, name, defaultValue);
    }

    public synchronized <T extends Serializable> T cookiepack(String name) {
        return (T)((Serializable)Scopes.get("cookiepack", this.cookiepack, name));
    }

    public synchronized <T extends Serializable> T cookiepackGetOrCreate(String name, Class<T> valueClass, Object ... constructorArgs) {
        return (T)((Serializable)Scopes.getOrCreate("cookiepack", this.cookiepack(), name, valueClass, constructorArgs));
    }

    public synchronized <T extends Serializable> T local(String name, T defaultValue) {
        return Scopes.get("locals", this.locals, name, defaultValue);
    }

    public synchronized <T extends Serializable> T local(String name) {
        return (T)((Serializable)Scopes.get("locals", this.locals, name));
    }

    public synchronized <T extends Serializable> T localGetOrCreate(String name, Class<T> valueClass, Object ... constructorArgs) {
        return (T)((Serializable)Scopes.getOrCreate("locals", this.locals(), name, valueClass, constructorArgs));
    }

    public synchronized <T> T attr(String name, T defaultValue) {
        return Scopes.get("tmps", this.tmps, name, defaultValue);
    }

    public synchronized <T> T attr(String name) {
        return Scopes.get("tmps", this.tmps, name);
    }

    public synchronized <T> T attrGetOrCreate(String name, Class<T> valueClass, Object ... constructorArgs) {
        return Scopes.getOrCreate("tmps", this.attrs(), name, valueClass, constructorArgs);
    }

    public synchronized void finish() {
        this.storeSession();
    }

    @Override
    public synchronized void storeSession() {
        if (this.sessionId != null) {
            this.sessionStore.set(this.sessionId, this.session);
        }
    }

    public synchronized boolean hasSession() {
        if (this.sessionId == null) {
            this.sessionId = this.cookie(SESSION_COOKIE, null);
        }
        return this.sessionId != null;
    }

    public synchronized String sessionId() {
        if (this.sessionId == null) {
            this.sessionId = this.cookie(SESSION_COOKIE, null);
            if (this.sessionId == null) {
                this.sessionId = UUID.randomUUID().toString();
                this.setCookie(SESSION_COOKIE, this.sessionId, "path=/");
            }
        }
        return this.sessionId;
    }

    private void beforeClosingHeaders() {
        byte[] cpack = this.serializeCookiepack();
        if (cpack != null) {
            String json = U.mid((String)JSON.stringify((Object)cpack), (int)1, (int)-1);
            this.setCookie(COOKIEPACK_COOKIE, json, "path=/");
        }
    }

    @Override
    public synchronized void preload() {
        this.uri();
        this.verb();
        this.path();
        this.query();
        this.protocol();
        this.headers();
        this.params();
        this.data();
        this.files();
    }

    @Override
    public void loadState() {
        String state;
        if (this.isPostReq() && !U.isEmpty((String)(state = (String)this.posted("__state", null))) && !state.equals("null")) {
            byte[] bytes = JSON.parseBytes((String)('\"' + state + '\"'));
            this.deserializeLocals(bytes);
        }
    }

    public HttpExchange result(Object res) {
        if (res instanceof byte[]) {
            if (!this.hasContentType()) {
                this.binary();
            }
            this.write((byte[])res);
        } else if (res instanceof String) {
            if (!this.hasContentType()) {
                this.json();
            }
            if (U.eq((Object)this.getResponseContentType(), (Object)MediaType.JSON_UTF_8)) {
                this.writeJSON((String)res);
            } else {
                this.write((String)res);
            }
        } else if (res instanceof ByteBuffer) {
            if (!this.hasContentType()) {
                this.binary();
            }
            this.write((ByteBuffer)res);
        } else if (res instanceof File) {
            File file = (File)res;
            this.sendFile(file);
        } else if (UTILS.isRapidoidType(res.getClass())) {
            this.html().write(res.toString());
        } else {
            if (!this.hasContentType()) {
                this.json();
            }
            if (U.eq((Object)this.getResponseContentType(), (Object)MediaType.JSON_UTF_8)) {
                this.writeJSON(res);
            } else {
                this.write("" + res);
            }
        }
        this.done();
        return this;
    }

    public HttpExchangeImpl async() {
        super.async();
        this.preload();
        return this;
    }

    public void onAsync() {
        this.async();
    }

    public synchronized String name() {
        if (this.resourceName == null) {
            this.resourceName = this.path().substring(1);
            if (this.resourceName.isEmpty()) {
                this.resourceName = "index";
                this.resourceNameHasExtension = false;
            } else {
                if (this.resourceName.endsWith(".html")) {
                    this.resourceName = U.mid((String)this.resourceName, (int)0, (int)-5);
                }
                this.resourceNameHasExtension = this.resourceName.contains(".");
            }
        }
        return this.resourceName;
    }

    public synchronized String verbAndResourceName() {
        return this.verb().toUpperCase() + "/" + this.name();
    }

    public synchronized boolean resourceNameHasExtension() {
        this.name();
        return this.resourceNameHasExtension;
    }

    public HttpExchange render(ITemplate template, Object model) {
        template.render(this.outputStream(), new Object[]{model, this.model()});
        return this;
    }

    public HttpExchange renderPage(Object model) {
        if (!this.hasContentType()) {
            this.html();
        }
        HttpExchangeImpl.pageTemplate().render(this.outputStream(), new Object[]{model, this.model()});
        return this.done();
    }

    public String renderPageToHTML(Object model) {
        return HttpExchangeImpl.pageTemplate().render(new Object[]{model, this.model()});
    }

    private static ITemplate pageTemplate() {
        if (PAGE_TEMPLATE == null) {
            PAGE_TEMPLATE = Templates.fromFile((String)"page.html");
        }
        return PAGE_TEMPLATE;
    }

    public synchronized Map<String, Object> model() {
        if (this.model == null) {
            this.model = U.map((Object)"req", (Object)this, (Object)"data", this.lazyData, (Object)"files", this.lazyFiles, (Object)"cookies", this.lazyCookies, (Object)"headers", this.lazyHeaders);
            this.model.put("verb", this.verb());
            this.model.put("uri", this.uri());
            this.model.put("path", this.path());
            this.model.put("home", this.home());
            this.model.put("host", this.host());
            this.model.put("dev", this.isDevMode());
            WebApp app = AppCtx.app();
            this.model.put("app", app);
            this.model.put("menu", app != null ? app.getMenu() : null);
            List providers = U.list((Object[])new String[]{"google", "facebook", "linkedin", "github"});
            Map oauth = U.map((Object)"popup", (Object)true, (Object)"providers", (Object)providers);
            this.model.put("oauth", oauth);
            boolean loggedIn = Ctxs.ctx().isLoggedIn();
            this.model.put("loggedIn", loggedIn);
            this.model.put("user", loggedIn ? Ctxs.ctx().user() : null);
            this.model.put("version", RapidoidInfo.version());
        }
        return this.model;
    }

    public <T> T persister() {
        return (T)Ctxs.ctx().persister();
    }

    public synchronized String home() {
        return this.home;
    }

    public synchronized HttpExchangeImpl setHome(String home) {
        String uriPath = this.path();
        U.must((boolean)uriPath.startsWith(home));
        this.path = uriPath.substring(home.length());
        if (U.isEmpty((String)this.path)) {
            this.path = "/";
            this.rPath.length = 1;
        } else {
            this.rPath.strip(home.length(), 0);
        }
        this.pathSegments = null;
        this.pathSegments();
        this.home = home;
        return this;
    }

    public synchronized String renderState() {
        try {
            return JSON.stringify((Object)this.serializeLocals());
        }
        catch (Exception e) {
            Log.error((String)"Cannot render state tag!", (Throwable)e);
            return "{}";
        }
    }

    public synchronized Runnable asAsyncJob(Handler handler) {
        this.handler = handler;
        return this.async();
    }

    public synchronized void run() {
        this.runInAsyncContext();
    }

    private void runInAsyncContext() {
        Object result;
        try {
            U.notNull((Object)this.handler, (String)"async handler", (Object[])new Object[0]);
            result = this.handler.handle((HttpExchange)this);
        }
        catch (Throwable e) {
            HttpProtocol.handleError(this, e);
            return;
        }
        if (result != null && !(result instanceof HttpExchange)) {
            HttpProtocol.processResponse(this, result);
        }
    }

    public String dbQuery() {
        String verbResName = this.verbAndResourceName();
        String resName = verbResName + ".(sql|cql|jpql)";
        String concrete = Conf.rootPath() + "/" + verbResName;
        String fallback = Conf.rootPathDefault() + "/" + verbResName;
        String firstSQL = concrete + ".sql";
        String firstCQL = concrete + ".cql";
        String firstJPQL = concrete + ".jpql";
        String defaultSQL = fallback + ".sql";
        String defaultCQL = fallback + ".cql";
        String defaultJPQL = fallback + ".jpql";
        Res res = Res.from((String)resName, (boolean)true, (String[])new String[]{firstSQL, firstCQL, firstJPQL, defaultSQL, defaultCQL, defaultJPQL});
        return res.getContent();
    }

    public String clientIpAddress() {
        return this.address();
    }

    public long connectionId() {
        return this.connId();
    }

    public Response response() {
        throw U.notSupported();
    }

    public String forwardedForAddress() {
        throw U.notSupported();
    }

    public Req verb(String verb) {
        throw U.notSupported();
    }

    public Req uri(String uri) {
        throw U.notSupported();
    }

    public Req path(String path) {
        throw U.notSupported();
    }

    public Req body(byte[] body) {
        throw U.notSupported();
    }

    public OutputStream out() {
        throw U.notSupported();
    }

    static {
        HEADER_SEP = ": ".getBytes();
    }
}

