/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.concurrent.CancellationException;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.data.Range;
import org.rapidoid.http.HTTPInterceptor;
import org.rapidoid.http.HTTPServerImpl;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpNotFoundException;
import org.rapidoid.http.HttpResponses;
import org.rapidoid.http.HttpSuccessException;
import org.rapidoid.http.HttpUpgradeHandler;
import org.rapidoid.http.HttpUpgrades;
import org.rapidoid.http.Router;
import org.rapidoid.http.fast.HttpParser;
import org.rapidoid.http.session.SessionStore;
import org.rapidoid.log.Log;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.ExchangeProtocol;
import org.rapidoid.net.impl.RapidoidConnection;
import org.rapidoid.u.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.util.Usage;
import org.rapidoid.webapp.AppCtx;
import org.rapidoid.webapp.WebApp;
import org.rapidoid.wire.Wire;

public class HttpProtocol
extends ExchangeProtocol<HttpExchangeImpl> {
    private final HttpParser parser = (HttpParser)Wire.singleton(HttpParser.class);
    private final HttpResponses responses;
    private final HttpUpgrades upgrades = new HttpUpgrades();
    private SessionStore sessionStore;
    private HTTPInterceptor interceptor;
    private HTTPServerImpl server;

    public HttpProtocol() {
        super(HttpExchangeImpl.class, true);
        this.responses = new HttpResponses(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Channel ctx, HttpExchangeImpl x) {
        String upgrade;
        U.notNull((Object)this.responses, (String)"responses", (Object[])new Object[0]);
        U.notNull((Object)this.sessionStore, (String)"sessionStore", (Object[])new Object[0]);
        if (ctx.isInitial()) {
            return;
        }
        Usage.touchLastAppUsedOn();
        this.parser.parse(x.input(), x.isGet, x.isKeepAlive, x.rBody, x.rVerb, x.rUri, x.rPath, x.rQuery, x.rProtocol, x.headers, x.helper());
        this.removeTrailingSlash(x);
        if (this.upgradable() && !U.isEmpty((String)(upgrade = x.header("Upgrade", null)))) {
            this.processUpgrade(ctx, x, upgrade);
            return;
        }
        x.init(this.responses, this.sessionStore);
        String err = this.validateRequest(x);
        if (err != null) {
            x.startResponse(404).html().write(err);
            x.completeResponse();
            return;
        }
        Ctxs.open((String)"request");
        Ctxs.ctx().setExchange((Object)x);
        try {
            this.processRequest(x);
        }
        finally {
            Ctxs.close();
        }
    }

    private void removeTrailingSlash(HttpExchangeImpl x) {
        if (x.rPath.length > 1 && x.input().get(x.rPath.last()) == 47) {
            --x.rPath.length;
        }
        if (x.rUri.length > 1 && x.input().get(x.rUri.last()) == 47) {
            --x.rUri.length;
        }
    }

    private String validateRequest(HttpExchangeImpl x) {
        if (x.rVerb.isEmpty()) {
            return "HTTP verb cannot be empty!";
        }
        if (!BytesUtil.isValidURI((Bytes)x.input().bytes(), (Range)x.rUri)) {
            return "Invalid HTTP URI!";
        }
        if (x.isGet.value && !x.rBody.isEmpty()) {
            return "Body is NOT allowed in HTTP GET requests!";
        }
        return null;
    }

    protected boolean upgradable() {
        return false;
    }

    private void processUpgrade(Channel ctx, HttpExchangeImpl x, String upgrade) {
        Log.debug((String)"Starting HTTP protocol upgrade", (String)"upgrade", (Object)upgrade);
        HttpUpgradeHandler upgradeHandler = this.upgrades.getUpgrade(upgrade);
        Protocol upgradeTo = this.upgrades.getProtocol(upgrade);
        U.must((upgradeHandler != null && upgradeTo != null ? 1 : 0) != 0, (String)"Upgrade not supported: %s", (Object)upgrade);
        upgradeHandler.doUpgrade(x);
        RapidoidConnection conn = (RapidoidConnection)ctx;
        conn.setProtocol(upgradeTo);
        conn.setInitial(true);
        upgradeTo.process(ctx);
        conn.setInitial(false);
    }

    private void processRequest(HttpExchangeImpl x) {
        WebApp app = this.getApp(x);
        Ctxs.ctx().setApp((Object)app);
        Ctxs.ctx().setUser(x.user());
        Router router = app.getRouter();
        U.notNull((Object)router, (String)"application router", (Object[])new Object[0]);
        this.executeRequest(router, x);
    }

    private WebApp getApp(HttpExchangeImpl x) {
        String uriContext = "/" + x.pathSegment(0);
        WebApp app = this.server.applications.get(x.host(), uriContext);
        U.must((app != null ? 1 : 0) != 0, (String)("Cannot find matching application in: " + this.server.applications.getName()));
        if (app.getUriContexts().contains(uriContext)) {
            x.setHome(uriContext);
        }
        return app;
    }

    private void executeRequest(Router router, HttpExchangeImpl x) {
        try {
            if (this.interceptor != null) {
                this.interceptor.intercept(x);
            } else {
                router.dispatch(x);
            }
        }
        catch (Throwable e) {
            HttpProtocol.handleError(x, e);
        }
        if (x.hasError()) {
            HttpProtocol.handleError(x, x.getError());
        } else if (!x.isAsync()) {
            x.completeResponse();
        }
    }

    public static void handleError(HttpExchangeImpl x, Throwable e) {
        Throwable cause = UTILS.rootCause((Throwable)e);
        if (cause instanceof HttpSuccessException) {
            x.completeResponse();
        } else if (cause instanceof HttpNotFoundException) {
            if (!x.uri().equals("/favicon.ico") && !x.uri().endsWith(".js.map")) {
                Log.warn((String)"HTTP resource not found!", (String)"app", (Object)AppCtx.app().getId(), (String)"uri", (Object)x.uri());
            }
            x.completeResponse();
        } else if (cause instanceof CancellationException) {
            Log.error((String)"Thread interruption, probably timeout!", (String)"request", (Object)x, (String)"error", (Object)cause);
            x.response(500, "Request timeout!", null);
        } else if (cause instanceof ThreadDeath) {
            Log.error((String)"Thread death, probably timeout!", (String)"request", (Object)x, (String)"error", (Object)cause);
            x.response(500, "Request timeout!", null);
        } else {
            Log.error((String)"Internal server error!", (String)"request", (Object)x, (String)"error", (Object)cause);
            x.error(e);
            x.completeResponse();
        }
        x.done();
    }

    public static void processResponse(HttpExchange xch, Object res) {
        HttpExchangeImpl x = (HttpExchangeImpl)xch;
        if (x.isLowLevelProcessing() || res instanceof HttpExchange) {
            return;
        }
        if (res != null) {
            x.result(res);
        } else if (!x.isAsync()) {
            if (!x.hasContentType()) {
                x.html();
            }
            throw x.notFound();
        }
    }

    public void setSessionStore(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public void setInterceptor(HTTPInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public HTTPInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void addUpgrade(String upgradeName, HttpUpgradeHandler upgrade, Protocol protocol) {
        this.upgrades.add(upgradeName, upgrade, protocol);
    }

    public void setServer(HTTPServerImpl server) {
        this.server = server;
    }
}

