/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.data.Range;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpProtocol;
import org.rapidoid.http.Router;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.SimpleHashTable;
import org.rapidoid.util.SimpleList;

public class HttpRouter
implements Router {
    private final SimpleHashTable<Route> routes = new SimpleHashTable(1000, 1);
    private Handler genericHandler;

    @Override
    public synchronized void generic(Handler handler) {
        this.genericHandler = handler;
    }

    private synchronized void addRoute(String action, String path, Handler handler) {
        assert (action.length() >= 1);
        assert (path.length() >= 1);
        Route route = new Route();
        route.handler = handler;
        route.action = action.getBytes();
        route.path = path.getBytes();
        long hash = this.hash(action, path);
        this.routes.put(hash, (Object)route);
    }

    private long hash(String action, String path) {
        Bytes bytes = BytesUtil.from((String)(action + " " + path));
        Range actionRange = Range.fromTo((int)0, (int)action.length());
        Range pathRange = Range.fromTo((int)(action.length() + 1), (int)bytes.limit());
        return this.hash(bytes, actionRange, pathRange);
    }

    private long hash(Bytes bytes, Range action, Range path) {
        return bytes.get(action.start) * 17 + action.length * 19 + action.length;
    }

    @Override
    public void dispatch(HttpExchangeImpl x) {
        Handler handler = this.findHandler(x);
        this.handle(handler, x);
    }

    public Handler findHandler(Buf buf, Range action, Range path) {
        long hash = this.hash(buf.bytes(), action, path);
        SimpleList candidates = this.routes.get(hash);
        if (candidates != null) {
            for (int i = 0; i < candidates.size(); ++i) {
                Route route = (Route)candidates.get(i);
                if (!BytesUtil.matches((Bytes)buf.bytes(), (Range)action, (byte[])route.action, (boolean)true) || !BytesUtil.startsWith((Bytes)buf.bytes(), (Range)path, (byte[])route.path, (boolean)true)) continue;
                int pos = path.start + route.path.length;
                if (path.limit() != pos && buf.get(pos) != 47) continue;
                return route.handler;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler findHandler(HttpExchangeImpl x) {
        Buf buf = x.input();
        Range action = x.verb_().range();
        Range path = x.path_().range();
        long hash = this.hash(buf.bytes(), action, path);
        HttpRouter httpRouter = this;
        synchronized (httpRouter) {
            SimpleList candidates = this.routes.get(hash);
            candidates = this.routes.get(hash);
            if (candidates != null) {
                for (int i = 0; i < candidates.size(); ++i) {
                    Route route = (Route)candidates.get(i);
                    if (!BytesUtil.matches((Bytes)buf.bytes(), (Range)action, (byte[])route.action, (boolean)true) || !BytesUtil.startsWith((Bytes)buf.bytes(), (Range)path, (byte[])route.path, (boolean)true)) continue;
                    int pos = path.start + route.path.length;
                    if (path.limit() != pos && buf.get(pos) != 47) continue;
                    x.setSubpath(pos, path.limit());
                    return route.handler;
                }
            }
            if (this.genericHandler != null) {
                x.setSubpath(path.start, path.limit());
                return this.genericHandler;
            }
        }
        throw x.notFound();
    }

    private void serveStaticFileIfExists(HttpExchangeImpl x, Buf buf, Range path) {
        if (x.isGetReq() && BytesUtil.find((Bytes)buf.bytes(), (int)(path.start + 1), (int)path.limit(), (byte)46, (boolean)true) >= 0 && x.serveStaticFile()) {
            return;
        }
    }

    private void handle(Handler handler, HttpExchangeImpl x) {
        Object res;
        try {
            res = handler.handle((HttpExchange)x);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        HttpProtocol.processResponse(x, res);
    }

    @Override
    public HttpRouter route(String action, String url, Handler handler) {
        if (!action.matches("[A-Z_][A-Z0-9_]*")) {
            throw new IllegalArgumentException("Only uppercase letters, digits and underscore are allowed! Invalid action: " + action);
        }
        if (!url.matches("[a-zA-Z0-9_/\\.\\-\\~]*")) {
            throw new IllegalArgumentException("Invalid url: " + url);
        }
        if (!(url = U.trimr((String)url, (String)"/")).startsWith("/")) {
            url = "/" + url;
        }
        Log.info((String)"Registering handler", (String)"action", (Object)action, (String)"url", (Object)url);
        this.addRoute(action, url, handler);
        return this;
    }

    @Override
    public HttpRouter route(String cmd, String url, String response) {
        this.route(cmd, url, HttpRouter.contentHandler(response));
        return this;
    }

    @Override
    public HttpRouter serve(Handler handler) {
        this.generic(handler);
        return this;
    }

    @Override
    public HttpRouter serve(String response) {
        return this.serve(HttpRouter.contentHandler(response));
    }

    @Override
    public HttpRouter get(String url, Handler handler) {
        return this.route("GET", url, handler);
    }

    @Override
    public HttpRouter post(String url, Handler handler) {
        return this.route("POST", url, handler);
    }

    @Override
    public HttpRouter put(String url, Handler handler) {
        return this.route("PUT", url, handler);
    }

    @Override
    public HttpRouter delete(String url, Handler handler) {
        return this.route("DELETE", url, handler);
    }

    private static Handler contentHandler(String response) {
        final byte[] bytes = response.getBytes();
        return new Handler(){

            public Object handle(HttpExchange x) {
                x.html();
                return bytes;
            }
        };
    }

    private class Route {
        Handler handler;
        byte[] action;
        byte[] path;

        private Route() {
        }

        public String toString() {
            return new String(this.action) + ":" + new String(this.path);
        }
    }
}

