/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.webapp;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.ctx.Classes;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;
import org.rapidoid.webapp.WebApp;

public class FindClasses {
    private FindClasses() {
    }

    public static List<Class<?>> all() {
        return FindClasses.find(null, null, null, null, null);
    }

    public static List<Class<?>> find(String packageName, String nameRegex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        return FindClasses.scanClasses(packageName, nameRegex, filter, annotated, classLoader);
    }

    public static List<Class<?>> annotated(Class<? extends Annotation> annotated) {
        return FindClasses.scanClasses(null, null, null, annotated, null);
    }

    public static List<Class<?>> annotated(Class<? extends Annotation> annotated, ClassLoader classLoader) {
        return FindClasses.scanClasses(null, null, null, annotated, classLoader);
    }

    public static List<Class<?>> pkg(String packageName) {
        return FindClasses.scanClasses(packageName, null, null, null, null);
    }

    public static List<Class<?>> byName(String simpleName, Predicate<Class<?>> filter, ClassLoader classLoader) {
        return FindClasses.scanClasses(null, "(.*\\.|^)" + simpleName, filter, null, classLoader);
    }

    public static List<Class<?>> bySuffix(String nameSuffix, Predicate<Class<?>> filter, ClassLoader classLoader) {
        return FindClasses.scanClasses(null, ".*\\w" + nameSuffix, filter, null, classLoader);
    }

    private static synchronized List<Class<?>> scanClasses(String packageName, String nameRegex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated, ClassLoader classLoader) {
        packageName = (String)U.or((Object)packageName, (Object)"");
        List cacheKey = null;
        WebApp app = (WebApp)Ctxs.ctx().app();
        Classes appClasses = app.getClasses();
        Map cache = appClasses.getCache();
        List cachedClasses = (List)cache.get(cacheKey = U.list((Object[])new Object[]{packageName, nameRegex, filter, annotated, classLoader}));
        if (cachedClasses != null) {
            return cachedClasses;
        }
        long startingAt = U.time();
        Log.info((String)("Filtering " + appClasses.size() + " classes"), (String)"annotated", annotated, (String)"package", (Object)packageName, (String)"name", (Object)nameRegex);
        Pattern regex = nameRegex != null ? Pattern.compile(nameRegex) : null;
        List<Class<?>> classes = FindClasses.filterClasses(appClasses, packageName, regex, filter, annotated);
        cache.put(cacheKey, classes);
        long timeMs = U.time() - startingAt;
        Log.info((String)"Finished classpath scan", (String)"time", (Object)(timeMs + "ms"), (String)"classes", classes);
        return classes;
    }

    private static List<Class<?>> filterClasses(Classes appClasses, String packageName, Pattern regex, Predicate<Class<?>> filter, Class<? extends Annotation> annotated) {
        List matching = U.list();
        for (Map.Entry e : appClasses.entrySet()) {
            String pkg;
            Class cls = (Class)e.getValue();
            String string = pkg = cls.getPackage() != null ? cls.getPackage().getName() : "";
            if (!U.isEmpty((String)packageName) && !pkg.startsWith(packageName + ".") && !pkg.equals(packageName) || !ClasspathUtil.classMatches((Class)cls, filter, annotated, (Pattern)regex)) continue;
            matching.add(cls);
        }
        return matching;
    }
}

