/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.webapp;

import java.util.Set;
import org.rapidoid.config.Config;
import org.rapidoid.ctx.Classes;
import org.rapidoid.dispatch.PojoDispatcher;
import org.rapidoid.http.HttpRouter;
import org.rapidoid.http.Router;
import org.rapidoid.u.U;
import org.rapidoid.webapp.AppMode;
import org.rapidoid.webapp.WebPojoDispatcher;

public class WebApp {
    private final String id;
    private final Set<String> owners;
    private final Set<String> hostnames;
    private final Set<String> uriContexts;
    private final AppMode mode;
    private final Router router;
    private final PojoDispatcher dispatcher;
    private final Classes classes;
    private final Config config;
    private volatile Object menu;

    public WebApp(String id, Set<String> owners, Set<String> hostnames, Set<String> uriContexts, AppMode mode, Router router, PojoDispatcher dispatcher, Classes classes, Config config) {
        this.id = id;
        this.router = (Router)U.or((Object)router, (Object)new HttpRouter());
        this.dispatcher = (PojoDispatcher)U.or((Object)dispatcher, (Object)((Object)new WebPojoDispatcher(classes)));
        this.owners = U.safe(owners);
        this.hostnames = U.safe(hostnames);
        this.uriContexts = U.safe(uriContexts);
        this.mode = (AppMode)((Object)U.or((Object)((Object)mode), (Object)((Object)AppMode.DEVELOPMENT)));
        this.classes = (Classes)U.or((Object)classes, (Object)new Classes());
        this.config = (Config)U.or((Object)config, (Object)new Config());
    }

    public WebApp(String id, String uriPath, Classes classes) {
        this(id, null, null, uriPath != null ? U.set((Object[])new String[]{uriPath}) : null, AppMode.DEVELOPMENT, null, null, classes, null);
    }

    public WebApp(String id) {
        this(id, "/", null);
    }

    public WebApp() {
        this("app-id");
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.config.option("title", null);
    }

    public void setTitle(String title) {
        this.config.put("title", (Object)title);
    }

    public Set<String> getOwners() {
        return this.owners;
    }

    public Set<String> getHostnames() {
        return this.hostnames;
    }

    public Set<String> getUriContexts() {
        return this.uriContexts;
    }

    public AppMode getMode() {
        return this.mode;
    }

    public Router getRouter() {
        return this.router;
    }

    public PojoDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Classes getClasses() {
        return this.classes;
    }

    public boolean dev() {
        return this.getMode().equals((Object)AppMode.DEVELOPMENT);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setMenu(Object menu) {
        this.menu = menu;
    }

    public Object getMenu() {
        return this.menu;
    }
}

