/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.webapp;

import java.util.Map;
import java.util.Set;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.plugins.Plugin;
import org.rapidoid.plugins.Plugins;
import org.rapidoid.u.U;
import org.rapidoid.webapp.AppClasspathEntitiesPlugin;
import org.rapidoid.webapp.RootWebApp;
import org.rapidoid.webapp.WebApp;

public class WebAppGroup {
    private static final WebAppGroup MAIN = new WebAppGroup("main");
    private final String name;
    private final Map<String, Map<String, WebApp>> appsByURL = U.mapOfMaps();
    private volatile WebApp defaultApp;

    public WebAppGroup(String name) {
        this.name = name;
    }

    public static WebAppGroup main() {
        return MAIN;
    }

    public synchronized void setDefaultApp(WebApp defaultApp) {
        this.defaultApp = defaultApp;
    }

    public synchronized void register(WebApp app) {
        Set hosts = app.getHostnames();
        if (hosts.isEmpty()) {
            hosts = U.set((Object[])new String[]{"*"});
        }
        for (String hostname : hosts) {
            for (String uriPath : app.getUriContexts()) {
                U.must((!this.appsByURL.get(hostname).containsKey(uriPath) ? 1 : 0) != 0, (String)"An WebApp has already been registered with the URI path: %s", (Object)uriPath);
                this.appsByURL.get(hostname).put(uriPath, app);
            }
        }
    }

    public synchronized void unregister(WebApp app) {
        throw U.notReady();
    }

    public WebApp get(String hostname, String uriContext) {
        if (this.appsByURL.containsKey(hostname)) {
            return (WebApp)U.or((Object)this.appsByURL.get(hostname).get(uriContext), (Object)this.defaultApp);
        }
        return (WebApp)U.or((Object)this.appsByURL.get("*").get(uriContext), (Object)this.defaultApp);
    }

    public String toString() {
        return "WebApps [name=" + this.name + ", appsByURL=" + this.appsByURL + ", defaultApp=" + this.defaultApp + "]";
    }

    public static RootWebApp root() {
        return new RootWebApp();
    }

    public static WebApp openRootContext() {
        RootWebApp app = WebAppGroup.root();
        WebAppGroup.main().setDefaultApp(app);
        Ctxs.open((String)"root");
        Ctxs.ctx().setApp((Object)app);
        Plugins.register((Plugin)new AppClasspathEntitiesPlugin());
        return app;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void clear() {
        this.appsByURL.clear();
        this.defaultApp = null;
    }
}

