/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.webapp;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.rapidoid.annotation.Controller;
import org.rapidoid.annotation.Cookie;
import org.rapidoid.annotation.DELETE;
import org.rapidoid.annotation.GET;
import org.rapidoid.annotation.Header;
import org.rapidoid.annotation.POST;
import org.rapidoid.annotation.PUT;
import org.rapidoid.annotation.Page;
import org.rapidoid.aop.AOP;
import org.rapidoid.beany.Metadata;
import org.rapidoid.commons.Arr;
import org.rapidoid.ctx.Classes;
import org.rapidoid.dispatch.DispatchResult;
import org.rapidoid.dispatch.PojoDispatchException;
import org.rapidoid.dispatch.PojoHandlerNotFoundException;
import org.rapidoid.dispatch.PojoRequest;
import org.rapidoid.dispatch.impl.DispatchReq;
import org.rapidoid.dispatch.impl.DispatchReqKind;
import org.rapidoid.dispatch.impl.PojoDispatcherImpl;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.u.U;
import org.rapidoid.webapp.WebReq;

public class WebPojoDispatcher
extends PojoDispatcherImpl {
    public WebPojoDispatcher(Classes components) {
        super((Map)components);
    }

    protected boolean isCustomType(Class<?> type) {
        return Req.class.isAssignableFrom(type) || Resp.class.isAssignableFrom(type) || type.equals(byte[].class) || type.equals(byte[][].class) || super.isCustomType(type);
    }

    protected Object getCustomArg(PojoRequest request, Class<?> type, String[] parts, int paramsFrom, int paramsSize) {
        if (Req.class.isAssignableFrom(type) || Resp.class.isAssignableFrom(type)) {
            return this.exchange(request);
        }
        if (type.equals(byte[].class)) {
            HttpExchange x = this.exchange(request);
            U.must((x.files().size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 file uploaded for the byte[] parameter!");
            return U.single(x.files().values());
        }
        if (type.equals(byte[][].class)) {
            HttpExchange x = this.exchange(request);
            byte[][] files = new byte[x.files().size()][];
            int ind = 0;
            for (byte[] file : x.files().values()) {
                files[ind++] = file;
            }
            return files;
        }
        return super.getCustomArg(request, type, parts, paramsFrom, paramsSize);
    }

    private HttpExchange exchange(PojoRequest request) {
        U.must((boolean)(request instanceof WebReq));
        WebReq webReq = (WebReq)request;
        return webReq.getExchange();
    }

    protected List<String> getComponentNames(Class<?> component) {
        Controller web = (Controller)Metadata.classAnnotation(component, Controller.class);
        if (web != null) {
            return U.list((Object[])new String[]{web.url()});
        }
        return super.getComponentNames(component);
    }

    public DispatchResult dispatch(PojoRequest req) throws PojoHandlerNotFoundException, PojoDispatchException {
        try {
            return super.dispatch(req);
        }
        catch (PojoHandlerNotFoundException e) {
            return this.alternativeDispatch(req);
        }
    }

    private DispatchResult alternativeDispatch(PojoRequest req) throws PojoHandlerNotFoundException, PojoDispatchException {
        Object[] parts = WebPojoDispatcher.uriParts(req.path());
        for (int i = 0; i < parts.length; ++i) {
            try {
                String path = U.join((String)"/", (Object[])Arr.subarray((Object[])parts, (int)0, (int)i));
                return this.process(req, req.command(), path, (String[])parts, i + 1);
            }
            catch (PojoHandlerNotFoundException pojoHandlerNotFoundException) {
                continue;
            }
        }
        throw WebPojoDispatcher.notFound();
    }

    private static String[] uriParts(String uri) {
        if (uri.isEmpty() || uri.equals("/")) {
            return EMPTY_STRING_ARRAY;
        }
        return uri.replaceAll("^/", "").replaceAll("/$", "").split("/");
    }

    protected List<DispatchReq> getMethodActions(String componentPath, Method method) {
        List reqs = U.list();
        for (Annotation ann : method.getAnnotations()) {
            List<DispatchReq> req = this.req(componentPath, ann, method);
            if (req == null) continue;
            reqs.addAll(req);
        }
        return reqs;
    }

    private List<DispatchReq> req(String componentPath, Annotation ann, Method method) {
        String uri;
        Map config = U.synchronizedMap();
        if (ann instanceof GET) {
            uri = ((GET)ann).uri();
        } else if (ann instanceof POST) {
            uri = ((POST)ann).uri();
        } else if (ann instanceof PUT) {
            uri = ((PUT)ann).uri();
        } else if (ann instanceof DELETE) {
            uri = ((DELETE)ann).uri();
        } else if (ann instanceof Page) {
            Page page = (Page)ann;
            uri = page.uri();
            config.put("raw", page.raw());
            config.put("navbar", page.navbar());
            config.put("search", page.search());
            config.put("profile", page.profile());
            config.put("login", page.login());
            if (!page.title().isEmpty()) {
                config.put("title", page.title());
            }
        } else {
            return null;
        }
        String name = this.reqName(method, uri);
        String path = U.uri((String[])new String[]{componentPath, name});
        if (ann instanceof Page) {
            return U.list((Object[])new DispatchReq[]{new DispatchReq("GET", path, DispatchReqKind.PAGE, config), new DispatchReq("POST", path, DispatchReqKind.PAGE, config)});
        }
        String verb = ann.annotationType().getSimpleName().toUpperCase();
        return U.list((Object[])new DispatchReq[]{new DispatchReq(verb, path, DispatchReqKind.SERVICE, config)});
    }

    private String reqName(Method method, String url) {
        return U.isEmpty((String)url) ? method.getName() : url;
    }

    protected void preprocess(PojoRequest req, Method method, Object component, Object[] args) {
    }

    protected Object invoke(PojoRequest req, Method method, Object component, Object[] args) {
        return AOP.invoke(null, (Method)method, (Object)component, (Object[])args);
    }

    protected Object customSimpleArg(PojoRequest request, Annotation[] annotations) {
        Cookie cookie = (Cookie)Metadata.get((Annotation[])annotations, Cookie.class);
        if (cookie != null) {
            HttpExchange x = this.exchange(request);
            return x.cookie(cookie.value(), null);
        }
        Header header = (Header)Metadata.get((Annotation[])annotations, Header.class);
        if (header != null) {
            HttpExchange x = this.exchange(request);
            return x.header(header.value(), null);
        }
        return null;
    }

    protected boolean isCustomSimpleArg(PojoRequest request, Annotation[] annotations) {
        return Metadata.get((Annotation[])annotations, Cookie.class) != null || Metadata.get((Annotation[])annotations, Header.class) != null;
    }
}

