/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.AbstractLoop;

public abstract class AbstractEventLoop<T>
extends AbstractLoop<T> {
    protected final Selector selector;

    public AbstractEventLoop(String name) {
        super(name);
        Selector sel;
        try {
            sel = Selector.open();
        }
        catch (IOException e) {
            Log.severe((String)"Cannot open selector!", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.selector = sel;
    }

    private void processKey(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        if (key.isAcceptable()) {
            Log.debug((String)"accepting", (String)"key", (Object)key);
            try {
                this.acceptOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error((String)("accept IO error for key: " + key), (Throwable)e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error((String)("accept failed for key: " + key), (Throwable)e);
            }
        } else if (key.isConnectable()) {
            Log.debug((String)"connection event", (String)"key", (Object)key);
            try {
                this.connectOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error((String)("connect IO error for key: " + key), (Throwable)e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error((String)("connect failed for key: " + key), (Throwable)e);
            }
        } else if (key.isReadable()) {
            Log.debug((String)"reading", (String)"key", (Object)key);
            try {
                this.readOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error((String)("read IO error for key: " + key), (Throwable)e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error((String)("read failed for key: " + key), (Throwable)e);
            }
        } else if (key.isWritable()) {
            Log.debug((String)"writing", (String)"key", (Object)key);
            try {
                this.writeOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error((String)("write IO error for key: " + key), (Throwable)e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error((String)("write failed for key: " + key), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void insideLoop() {
        try {
            this.doProcessing();
        }
        catch (Throwable e) {
            Log.severe((String)"Event processing error!", (Throwable)e);
        }
        try {
            this.selector.select(50L);
        }
        catch (IOException e) {
            Log.error((String)"Select failed!", (Throwable)e);
        }
        try {
            Set<SelectionKey> selectedKeys;
            Set<SelectionKey> set = selectedKeys = this.selector.selectedKeys();
            synchronized (set) {
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    this.processKey(key);
                }
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
    }

    protected abstract void doProcessing();

    protected void acceptOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Accept operation is not implemented!");
    }

    protected void connectOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Connect operation is not implemented!");
    }

    protected void readOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Accept operation is not implemented!");
    }

    protected void writeOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Accept operation is not implemented!");
    }

    protected void failedOP(SelectionKey key, Throwable e) {
    }
}

