/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.util.Map;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufProvider;
import org.rapidoid.data.BinaryMultiData;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.Range;

public class DefaultBinaryMultiData
implements BinaryMultiData {
    private final BufProvider src;
    private final KeyValueRanges ranges;

    public DefaultBinaryMultiData(BufProvider src, KeyValueRanges ranges) {
        this.src = src;
        this.ranges = ranges;
    }

    public Map<String, byte[]> get() {
        return this.ranges.toBinaryMap(this.src.buffer(), true);
    }

    public KeyValueRanges ranges() {
        return this.ranges;
    }

    public String toString() {
        return "BinaryMultiData [ranges=" + this.ranges + "]";
    }

    public byte[] get(String name) {
        Buf buf = this.src.buffer();
        Range range = this.ranges.get(buf, name.getBytes(), false);
        return range != null ? range.bytes(buf) : null;
    }
}

