/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.util.Map;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufProvider;
import org.rapidoid.data.Data;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.data.Range;
import org.rapidoid.net.impl.DecodedData;
import org.rapidoid.util.UTILS;

public class DefaultMultiData
implements MultiData {
    private final BufProvider src;
    private final KeyValueRanges ranges;

    public DefaultMultiData(BufProvider src, KeyValueRanges ranges) {
        this.src = src;
        this.ranges = ranges;
    }

    public Map<String, String> get() {
        return this.ranges.toMap(this.src.buffer(), true, true);
    }

    public KeyValueRanges ranges() {
        return this.ranges;
    }

    public String toString() {
        return "MultiData [ranges=" + this.ranges + "]";
    }

    public String get(String name) {
        Buf buf = this.src.buffer();
        Range range = this.ranges.get(buf, name.getBytes(), false);
        return range != null ? UTILS.urlDecode((String)range.str(buf)) : null;
    }

    public Data get_(String name) {
        Buf buf = this.src.buffer();
        Range range = this.ranges.get(buf, name.getBytes(), false);
        return range != null ? new DecodedData(this.src, range) : null;
    }
}

