/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import org.rapidoid.buffer.BufGroup;
import org.rapidoid.buffer.IncompleteReadException;
import org.rapidoid.config.Conf;
import org.rapidoid.log.Log;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.impl.AbstractEventLoop;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.CtxListener;
import org.rapidoid.net.impl.ProtocolException;
import org.rapidoid.net.impl.RapidoidChannel;
import org.rapidoid.net.impl.RapidoidConnection;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.pool.ArrayPool;
import org.rapidoid.pool.Pool;
import org.rapidoid.util.AppCtx;
import org.rapidoid.util.SimpleList;
import org.rapidoid.util.U;

public class RapidoidWorker
extends AbstractEventLoop<RapidoidWorker> {
    private final Queue<RapidoidChannel> connected;
    private final SimpleList<RapidoidConnection> done;
    private final Pool<RapidoidConnection> connections;
    private final int maxPipelineSize;
    final Protocol serverProtocol;
    final RapidoidHelper helper;
    private final int bufSize;
    private final boolean noDelay;
    private final BufGroup bufs;
    private volatile long messagesProcessed;

    public RapidoidWorker(String name, BufGroup bufs, Protocol protocol, RapidoidHelper helper, int bufSizeKB, boolean noNelay) {
        super(name);
        this.bufs = bufs;
        this.serverProtocol = protocol;
        this.helper = helper;
        this.maxPipelineSize = Conf.option((String)"pipeline-max", (int)Integer.MAX_VALUE);
        int queueSize = Conf.micro() ? 1000 : 1000000;
        int growFactor = Conf.micro() ? 2 : 10;
        this.connected = new ArrayBlockingQueue<RapidoidChannel>(queueSize);
        this.done = new SimpleList(queueSize / 10, growFactor);
        this.connections = new ArrayPool((Callable)new Callable<RapidoidConnection>(){

            @Override
            public RapidoidConnection call() throws Exception {
                return RapidoidWorker.this.newConnection();
            }
        }, 100000);
        this.bufSize = bufSizeKB * 1024;
        this.noDelay = noNelay;
    }

    public void accept(SocketChannel socketChannel) throws IOException {
        this.configureSocket(socketChannel);
        this.connected.add(new RapidoidChannel(socketChannel, false, this.serverProtocol));
        this.selector.wakeup();
    }

    private void configureSocket(SocketChannel socketChannel) throws IOException, SocketException {
        socketChannel.configureBlocking(false);
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(this.noDelay);
        socket.setReceiveBufferSize(this.bufSize);
        socket.setSendBufferSize(this.bufSize);
        socket.setReuseAddress(true);
    }

    @Override
    protected void readOP(SelectionKey key) throws IOException {
        int read;
        SocketChannel socketChannel = (SocketChannel)key.channel();
        RapidoidConnection conn = (RapidoidConnection)key.attachment();
        try {
            read = conn.input.append((ReadableByteChannel)socketChannel);
        }
        catch (Exception e) {
            read = -1;
        }
        if (read == -1) {
            Log.debug((String)"The other end closed the connection!");
            conn.closing = true;
        }
        this.process(conn);
        if (conn.closing) {
            this.close(key);
        }
    }

    public void process(RapidoidConnection conn) {
        this.messagesProcessed += this.processMsgs(conn);
        conn.completedInputPos = conn.input.position();
    }

    private long processMsgs(RapidoidConnection conn) {
        long reqN;
        for (reqN = 0L; reqN < (long)this.maxPipelineSize && conn.input().hasRemaining() && this.processNext(conn, false); ++reqN) {
        }
        return reqN;
    }

    private boolean processNext(RapidoidConnection conn, boolean initial) {
        conn.log(initial ? "<< INIT >>" : "<< PROCESS >>");
        U.must((initial || conn.input().hasRemaining() ? 1 : 0) != 0);
        int pos = conn.input().position();
        int limit = conn.input().limit();
        int osize = conn.output().size();
        ConnState state = conn.state();
        long stateN = state.n;
        Object stateObj = state.obj;
        try {
            conn.done = false;
            if (AppCtx.hasContext()) {
                AppCtx.delExchange();
                AppCtx.delUser();
            }
            conn.getProtocol().process(conn);
            if (AppCtx.hasContext()) {
                AppCtx.delExchange();
                AppCtx.delUser();
            }
            if (!conn.closed && !conn.isAsync()) {
                conn.done();
            }
            Log.debug((String)"Completed message processing");
            return true;
        }
        catch (IncompleteReadException e) {
            Log.debug((String)"Incomplete message");
            conn.log("<< ROLLBACK >>");
            conn.input().position(pos);
            conn.input().limit(limit);
            conn.output().deleteAfter(osize);
            state.n = stateN;
            state.obj = stateObj;
        }
        catch (ProtocolException e) {
            conn.log("<< PROTOCOL ERROR >>");
            Log.warn((String)"Protocol error", (String)"error", (Object)e);
            conn.output().deleteAfter(osize);
            conn.write((String)U.or((Object)e.getMessage(), (Object)"Protocol error!"));
            conn.error();
            conn.close(true);
        }
        catch (Throwable e) {
            conn.log("<< ERROR >>");
            Log.error((String)"Failed to process message!", (Throwable)e);
            conn.close(true);
        }
        return false;
    }

    public void close(RapidoidConnection conn) {
        this.close(conn.key);
    }

    private void close(SelectionKey key) {
        try {
            RapidoidConnection conn;
            Object attachment = key.attachment();
            this.clearKey(key);
            if (attachment instanceof RapidoidConnection && (conn = (RapidoidConnection)attachment) != null && !conn.closed) {
                Log.trace((String)"Closing connection", (String)"connection", (Object)conn);
                assert (conn.key == key);
                conn.reset();
                this.connections.release((Object)conn);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void clearKey(SelectionKey key) throws IOException {
        if (key.isValid()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            socketChannel.close();
            key.attach(null);
            key.cancel();
        }
    }

    @Override
    protected void writeOP(SelectionKey key) throws IOException {
        RapidoidConnection conn = (RapidoidConnection)key.attachment();
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.checkOnSameThread();
        try {
            boolean complete;
            int wrote = conn.output.writeTo((WritableByteChannel)socketChannel);
            conn.output.deleteBefore(wrote);
            boolean bl = complete = conn.output.size() == 0;
            if (conn.closeAfterWrite() && complete) {
                this.close(conn);
            } else {
                if (complete) {
                    key.interestOps(1);
                } else {
                    key.interestOps(5);
                }
                conn.wrote(complete);
            }
        }
        catch (IOException e) {
            this.close(conn);
        }
    }

    public void wantToWrite(RapidoidConnection conn) {
        if (this.onSameThread()) {
            conn.key.interestOps(4);
        } else {
            this.wantToWriteAsync(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wantToWriteAsync(RapidoidConnection conn) {
        SimpleList<RapidoidConnection> simpleList = this.done;
        synchronized (simpleList) {
            this.done.add((Object)conn);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessing() {
        RapidoidConnection conn;
        RapidoidChannel channel;
        while ((channel = this.connected.poll()) != null) {
            SocketChannel socketChannel = channel.socketChannel;
            Log.debug((String)"connected", (String)"address", (Object)socketChannel.socket().getRemoteSocketAddress());
            try {
                SelectionKey newKey = socketChannel.register(this.selector, 1);
                U.notNull((Object)channel.protocol, (String)"protocol", (Object[])new Object[0]);
                conn = this.attachConn(newKey, channel.protocol);
                conn.setClient(channel.isClient);
                try {
                    this.processNext(conn, true);
                }
                finally {
                    conn.setInitial(false);
                }
            }
            catch (ClosedChannelException e) {
                Log.warn((String)"Closed channel", (Throwable)e);
            }
        }
        SimpleList<RapidoidConnection> simpleList = this.done;
        synchronized (simpleList) {
            for (int i = 0; i < this.done.size(); ++i) {
                conn = (RapidoidConnection)this.done.get(i);
                if (conn.key == null || !conn.key.isValid()) continue;
                conn.key.interestOps(4);
            }
            this.done.clear();
        }
    }

    private RapidoidConnection attachConn(SelectionKey key, Protocol protocol) {
        U.notNull((Object)key, (String)"protocol", (Object[])new Object[0]);
        U.notNull((Object)protocol, (String)"protocol", (Object[])new Object[0]);
        assert (key.attachment() == null);
        RapidoidConnection conn = (RapidoidConnection)this.connections.get();
        conn.reset();
        U.must((boolean)conn.closed);
        conn.closed = false;
        conn.key = key;
        conn.setProtocol(protocol);
        if (protocol instanceof CtxListener) {
            conn.setListener((CtxListener)((Object)protocol));
        }
        key.attach(conn);
        return conn;
    }

    @Override
    protected void failedOP(SelectionKey key, Throwable e) {
        Log.error((String)"Network error", (Throwable)e);
        this.close(key);
    }

    public RapidoidConnection newConnection() {
        return new RapidoidConnection(this, this.bufs);
    }

    public long getMessagesProcessed() {
        return this.messagesProcessed;
    }
}

