/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net;

import javax.net.ssl.SSLContext;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.Server;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.net.impl.RapidoidServerLoop;
import org.rapidoid.net.tls.TLSUtil;
import org.rapidoid.util.MscOpts;

public class ServerBuilder
extends RapidoidThing {
    private volatile String address = (String)Conf.NET.entry("address").or((Object)"0.0.0.0");
    private volatile int port = (Integer)Conf.NET.entry("port").or((Object)8080);
    private volatile int workers = (Integer)Conf.NET.entry("workers").or((Object)Runtime.getRuntime().availableProcessors());
    private volatile int bufSizeKB = (Integer)Conf.NET.entry("bufSizeKB").or((Object)16);
    private volatile boolean noDelay = (Boolean)Conf.NET.entry("noDelay").or((Object)false);
    private volatile boolean syncBufs = (Boolean)Conf.NET.entry("syncBufs").or((Object)true);
    private volatile boolean blockingAccept = (Boolean)Conf.NET.entry("blockingAccept").or((Object)false);
    private volatile Protocol protocol = null;
    private volatile Class<? extends DefaultExchange<?>> exchangeClass = null;
    private volatile Class<? extends RapidoidHelper> helperClass = RapidoidHelper.class;
    private volatile boolean tls = MscOpts.isTLSEnabled();
    private volatile String keystore = (String)Conf.TLS.entry("keystore").or((Object)"");
    private volatile char[] keystorePassword = ((String)Conf.TLS.entry("keystorePassword").or((Object)"")).toCharArray();
    private volatile char[] keyManagerPassword = ((String)Conf.TLS.entry("keyManagerPassword").or((Object)"")).toCharArray();
    private volatile String truststore = (String)Conf.TLS.entry("truststore").or((Object)"");
    private volatile char[] truststorePassword = ((String)Conf.TLS.entry("truststorePassword").or((Object)"")).toCharArray();
    private volatile boolean selfSignedTLS = Conf.TLS.is("selfSigned");
    private volatile SSLContext tlsContext;

    public ServerBuilder address(String address) {
        this.address = address;
        return this;
    }

    public String address() {
        return this.address;
    }

    public ServerBuilder port(int port) {
        this.port = port;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ServerBuilder workers(int workers) {
        this.workers = workers;
        return this;
    }

    public int workers() {
        return this.workers;
    }

    public ServerBuilder protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public ServerBuilder exchangeClass(Class<? extends DefaultExchange<?>> exchangeClass) {
        this.exchangeClass = exchangeClass;
        return this;
    }

    public Class<? extends DefaultExchange<?>> exchangeClass() {
        return this.exchangeClass;
    }

    public ServerBuilder helperClass(Class<? extends RapidoidHelper> helperClass) {
        this.helperClass = helperClass;
        return this;
    }

    public Class<? extends RapidoidHelper> helperClass() {
        return this.helperClass;
    }

    public int bufSizeKB() {
        return this.bufSizeKB;
    }

    public ServerBuilder bufSizeKB(int bufSizeKB) {
        this.bufSizeKB = bufSizeKB;
        return this;
    }

    public boolean noDelay() {
        return this.noDelay;
    }

    public ServerBuilder noDelay(boolean noDelay) {
        this.noDelay = noDelay;
        return this;
    }

    public boolean syncBufs() {
        return this.syncBufs;
    }

    public ServerBuilder syncBufs(boolean syncBufs) {
        this.syncBufs = syncBufs;
        return this;
    }

    public boolean blockingAccept() {
        return this.blockingAccept;
    }

    public ServerBuilder blockingAccept(boolean blockingAccept) {
        this.blockingAccept = blockingAccept;
        return this;
    }

    public boolean tls() {
        return this.tls;
    }

    public ServerBuilder tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public String keystore() {
        return this.keystore;
    }

    public ServerBuilder keystore(String keystore) {
        this.keystore = keystore;
        return this;
    }

    public char[] keystorePassword() {
        return this.keystorePassword;
    }

    public ServerBuilder keystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public char[] keyManagerPassword() {
        return this.keyManagerPassword;
    }

    public ServerBuilder keyManagerPassword(char[] keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
        return this;
    }

    public String truststore() {
        return this.truststore;
    }

    public ServerBuilder truststore(String truststore) {
        this.truststore = truststore;
        return this;
    }

    public char[] truststorePassword() {
        return this.truststorePassword;
    }

    public ServerBuilder truststorePassword(char[] truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public SSLContext tlsContext() {
        return this.tlsContext;
    }

    public ServerBuilder tlsContext(SSLContext tlsContext) {
        this.tlsContext = tlsContext;
        return this;
    }

    public synchronized Server build() {
        if (this.tls && this.tlsContext == null) {
            this.tlsContext = TLSUtil.createContext(this.keystore, this.keystorePassword, this.keyManagerPassword, this.truststore, this.truststorePassword, this.selfSignedTLS);
        }
        SSLContext tlsCtx = this.tls ? this.tlsContext : null;
        return new RapidoidServerLoop(this.protocol, this.exchangeClass, this.helperClass, this.address, this.port, this.workers, this.bufSizeKB, this.noDelay, this.syncBufs, this.blockingAccept, tlsCtx);
    }
}

