/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLContext;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufGroup;
import org.rapidoid.buffer.BufUtil;
import org.rapidoid.buffer.IncompleteReadException;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.Conf;
import org.rapidoid.config.ConfigUtil;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.expire.ExpirationCrawlerThread;
import org.rapidoid.expire.Expire;
import org.rapidoid.log.Log;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.impl.AbstractEventLoop;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.ProtocolException;
import org.rapidoid.net.impl.RapidoidChannel;
import org.rapidoid.net.impl.RapidoidConnection;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.pool.Pool;
import org.rapidoid.pool.Pools;
import org.rapidoid.u.U;
import org.rapidoid.util.SimpleList;

public class RapidoidWorker
extends AbstractEventLoop<RapidoidWorker> {
    public static int MAX_IO_WORKERS = 1024;
    public static boolean EXTRA_SAFE = false;
    private static final ExpirationCrawlerThread idleConnectionsCrawler;
    private static final int connTimeout;
    private final Queue<SocketChannel> connected;
    private final SimpleList<RapidoidConnection> done;
    private final Pool<RapidoidConnection> connections;
    private final Set<RapidoidConnection> allConnections = Coll.concurrentSet();
    private final int maxPipelineSize;
    final Protocol serverProtocol;
    final RapidoidHelper helper;
    private final int bufSize;
    private final boolean noDelay;
    private final BufGroup bufs;
    private volatile long messagesProcessed;
    private final SSLContext sslContext;
    RapidoidWorker next;

    public RapidoidWorker(String name, Protocol protocol, RapidoidHelper helper, int bufSizeKB, boolean noDelay, boolean syncBufs, SSLContext sslContext) {
        super(name);
        this.bufSize = bufSizeKB * 1024;
        this.noDelay = noDelay;
        this.bufs = new BufGroup(this.bufSize, syncBufs);
        this.serverProtocol = protocol;
        this.helper = helper;
        this.sslContext = sslContext;
        this.maxPipelineSize = (Integer)Conf.HTTP.entry("maxPipeline").or((Object)10);
        int queueSize = ConfigUtil.micro() ? 1000 : 1000000;
        int growFactor = ConfigUtil.micro() ? 2 : 10;
        this.connected = new ArrayBlockingQueue<SocketChannel>(queueSize);
        this.done = new SimpleList(queueSize / 10, growFactor);
        this.connections = Pools.create((String)"connections", (Callable)new Callable<RapidoidConnection>(){

            @Override
            public RapidoidConnection call() throws Exception {
                return RapidoidWorker.this.newConnection();
            }
        }, (int)100000);
        if (idleConnectionsCrawler != null) {
            idleConnectionsCrawler.register(this.allConnections);
        }
    }

    public void accept(SocketChannel socketChannel) {
        this.connected.add(socketChannel);
        this.selector.wakeup();
    }

    private void configureSocket(SocketChannel socketChannel) throws IOException {
        socketChannel.configureBlocking(false);
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(this.noDelay);
        socket.setReceiveBufferSize(this.bufSize);
        socket.setSendBufferSize(this.bufSize);
        socket.setReuseAddress(true);
    }

    @Override
    protected void readOP(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        RapidoidConnection conn = (RapidoidConnection)key.attachment();
        this.readInto(socketChannel, conn);
        this.process(conn);
        if (conn.closing) {
            this.close(key);
        }
    }

    private void readInto(SocketChannel socketChannel, RapidoidConnection conn) {
        boolean success;
        int read;
        try {
            read = conn.hasTLS ? (conn.tls.netIn.hasRemaining() ? socketChannel.read(conn.tls.netIn) : 0) : conn.input.append((ReadableByteChannel)socketChannel);
        }
        catch (Exception e) {
            Log.debug((String)"Connection error", (Throwable)e);
            read = -1;
        }
        if (read == -1) {
            Log.debug((String)"The connection was closed!");
            conn.closing = true;
            if (conn.hasTLS) {
                conn.tls.closeInbound();
            }
        } else if (conn.hasTLS && read > 0 && (success = conn.tls.unwrapInput())) {
            this.wantToWrite(conn);
        }
    }

    public void process(RapidoidConnection conn) {
        this.messagesProcessed += this.processMsgs(conn);
        conn.completedInputPos = conn.input.position();
    }

    private long processMsgs(RapidoidConnection conn) {
        long reqN;
        for (reqN = 0L; reqN < (long)this.maxPipelineSize && conn.input().hasRemaining() && this.processNext(conn, false); ++reqN) {
        }
        this.touch(conn);
        return reqN;
    }

    private boolean processNext(RapidoidConnection conn, boolean initial) {
        long seq;
        if (initial) {
            seq = 0L;
            conn.requestId = -1L;
        } else {
            seq = conn.readSeq.incrementAndGet();
            U.must((boolean)conn.input().hasRemaining());
            conn.requestId = this.helper.requestIdGen;
            this.helper.requestIdGen += (long)MAX_IO_WORKERS;
            ++this.helper.requestCounter;
        }
        conn.input().checkpoint(conn.input().position());
        int limit = conn.input().limit();
        int osize = conn.output().size();
        BufUtil.doneWriting((Buf)conn.input());
        ConnState state = conn.state();
        long stateN = state.n;
        Object stateObj = state.obj;
        try {
            conn.done = false;
            conn.async = false;
            if (EXTRA_SAFE) {
                this.processNextExtraSafe(conn);
            } else {
                Protocol protocol = conn.getProtocol();
                if (protocol == null) {
                    return false;
                }
                protocol.process(conn);
            }
            BufUtil.startWriting((Buf)conn.input());
            if (!conn.isAsync()) {
                if (!conn.closed) {
                    conn.done();
                }
                conn.processedSeq(seq);
            }
            conn.input().deleteBefore(conn.input().checkpoint());
            return true;
        }
        catch (IncompleteReadException e) {
            conn.log("<< ROLLBACK >>");
            conn.input().position(conn.input().checkpoint());
            conn.input().limit(limit);
            BufUtil.startWriting((Buf)conn.input());
            state.n = stateN;
            state.obj = stateObj;
            boolean decreased = conn.readSeq.compareAndSet(seq, seq - 1L);
            U.must((boolean)decreased, (String)"Error in the request order control! Handle: %s", (long)seq);
        }
        catch (ProtocolException e) {
            conn.log("<< PROTOCOL ERROR >>");
            Log.warn((String)"Protocol error", (String)"error", (Object)e);
            conn.output().deleteAfter(osize);
            conn.write((String)U.or((Object)e.getMessage(), (Object)"Protocol error!"));
            conn.error();
            conn.processedSeq(seq);
            conn.close(true);
        }
        catch (Throwable e) {
            conn.log("<< ERROR >>");
            Log.error((String)"Failed to process message!", (Throwable)e);
            conn.processedSeq(seq);
            conn.close(true);
        }
        return false;
    }

    private void processNextExtraSafe(RapidoidConnection conn) {
        if (Ctxs.hasContext()) {
            Log.warn((String)"Detected unclosed context before processing message!");
            Ctxs.close();
        }
        try {
            conn.getProtocol().process(conn);
        }
        finally {
            if (Ctxs.hasContext()) {
                Log.warn((String)"Detected unclosed context after processing message!");
                Ctxs.close();
            }
        }
    }

    public void close(RapidoidConnection conn) {
        this.close(conn.key);
    }

    private void close(SelectionKey key) {
        try {
            if (key != null) {
                Object attachment = key.attachment();
                this.clearKey(key);
                if (attachment instanceof RapidoidConnection) {
                    RapidoidConnection conn = (RapidoidConnection)attachment;
                    if (!conn.closed) {
                        Log.trace((String)"Closing connection", (String)"connection", (Object)conn);
                        assert (conn.key == key);
                        conn.reset();
                        this.connections.release((Object)conn);
                    }
                }
            }
        }
        catch (IOException e) {
            Log.warn((String)"Error while closing connection!", (Throwable)e);
        }
    }

    private void clearKey(SelectionKey key) throws IOException {
        if (key.isValid()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            socketChannel.close();
            key.attach(null);
            key.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeOP(SelectionKey key) throws IOException {
        RapidoidConnection conn = (RapidoidConnection)key.attachment();
        SocketChannel socketChannel = (SocketChannel)key.channel();
        this.checkOnSameThread();
        this.touch(conn);
        try {
            RapidoidConnection rapidoidConnection = conn;
            synchronized (rapidoidConnection) {
                Buf buf = conn.outgoing;
                synchronized (buf) {
                    if (conn.hasTLS) {
                        Buf buf2 = conn.output;
                        synchronized (buf2) {
                            conn.tls.wrapToOutgoing();
                        }
                    }
                    this.writeOp(key, conn, socketChannel);
                }
            }
        }
        catch (IOException e) {
            this.close(conn);
        }
        catch (CancelledKeyException cke) {
            Log.debug((String)"Tried to write on canceled selector key!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOp(SelectionKey key, RapidoidConnection conn, SocketChannel socketChannel) throws IOException {
        boolean closeAfterWrite;
        boolean finishedWriting;
        Buf buf = conn.outgoing;
        synchronized (buf) {
            if (conn.outgoing.hasRemaining()) {
                conn.log("WRITING");
                BufUtil.startWriting((Buf)conn.outgoing);
                int wrote = conn.outgoing.writeTo((WritableByteChannel)socketChannel);
                conn.outgoing.deleteBefore(wrote);
                BufUtil.doneWriting((Buf)conn.outgoing);
                conn.log("DONE WRITING");
            }
        }
        RapidoidConnection rapidoidConnection = conn;
        synchronized (rapidoidConnection) {
            finishedWriting = conn.finishedWriting();
            closeAfterWrite = conn.closeAfterWrite();
        }
        if (finishedWriting && closeAfterWrite) {
            this.close(conn);
        } else {
            if (finishedWriting) {
                key.interestOps(1);
            } else {
                key.interestOps(5);
            }
            conn.wrote(finishedWriting);
        }
    }

    public void wantToWrite(RapidoidConnection conn) {
        this.touch(conn);
        if (this.onSameThread()) {
            conn.key.interestOps(4);
        } else {
            this.wantToWriteAsync(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wantToWriteAsync(RapidoidConnection conn) {
        this.touch(conn);
        SimpleList<RapidoidConnection> simpleList = this.done;
        synchronized (simpleList) {
            this.done.add((Object)conn);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessing() {
        SocketChannel schannel;
        while ((schannel = this.connected.poll()) != null) {
            try {
                this.configureSocket(schannel);
            }
            catch (IOException e) {
                Log.error((String)"Cannot configure channel!", (Throwable)e);
                continue;
            }
            RapidoidChannel channel = new RapidoidChannel(schannel, false, this.serverProtocol);
            SocketChannel socketChannel = channel.socketChannel;
            Log.debug((String)"connected", (String)"address", (Object)socketChannel.socket().getRemoteSocketAddress());
            try {
                SelectionKey newKey = socketChannel.register(this.selector, 1);
                U.notNull((Object)channel.protocol, (String)"protocol", (Object[])new Object[0]);
                RapidoidConnection conn = this.attachConn(newKey, channel.protocol);
                conn.setClient(channel.isClient);
                try {
                    this.processNext(conn, true);
                }
                finally {
                    conn.setInitial(false);
                }
            }
            catch (ClosedChannelException e) {
                Log.warn((String)"Closed channel", (Throwable)e);
            }
        }
        SimpleList<RapidoidConnection> simpleList = this.done;
        synchronized (simpleList) {
            for (int i = 0; i < this.done.size(); ++i) {
                RapidoidConnection conn = (RapidoidConnection)this.done.get(i);
                if (conn.key == null || !conn.key.isValid()) continue;
                conn.key.interestOps(4);
            }
            this.done.clear();
        }
    }

    private RapidoidConnection attachConn(SelectionKey key, Protocol protocol) {
        U.notNull((Object)key, (String)"protocol", (Object[])new Object[0]);
        U.notNull((Object)protocol, (String)"protocol", (Object[])new Object[0]);
        assert (key.attachment() == null);
        RapidoidConnection conn = (RapidoidConnection)this.connections.get();
        conn.reset();
        U.must((boolean)conn.closed);
        conn.closed = false;
        conn.key = key;
        conn.setProtocol(protocol);
        key.attach(conn);
        this.touch(conn);
        return conn;
    }

    private void touch(RapidoidConnection conn) {
        conn.setExpiresAt(this.approxTime + (long)connTimeout);
    }

    @Override
    protected void failedOP(SelectionKey key, Throwable e) {
        Log.error((String)"Network error", (Throwable)e);
        this.close(key);
    }

    public RapidoidConnection newConnection() {
        RapidoidConnection conn = new RapidoidConnection(this, this.bufs);
        this.allConnections.add(conn);
        return conn;
    }

    public long getMessagesProcessed() {
        return this.messagesProcessed;
    }

    @Override
    protected synchronized void stopLoop() {
        super.stopLoop();
        this.done.clear();
        this.connected.clear();
        this.connections.clear();
        this.bufs.clear();
    }

    @Override
    public synchronized RapidoidWorker shutdown() {
        this.stopLoop();
        this.waitToStop();
        return this;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    static {
        int timeoutResolution = (Integer)Conf.HTTP.entry("timeoutResolution").or((Object)5000);
        connTimeout = (Integer)Conf.HTTP.entry("timeout").or((Object)30000);
        idleConnectionsCrawler = timeoutResolution > 0 && connTimeout > 0 ? Expire.crawler((String)"idleConnections", (int)timeoutResolution) : null;
    }
}

