/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.rapidoid.RapidoidThing;
import org.rapidoid.io.IO;
import org.rapidoid.lambda.F3;
import org.rapidoid.net.tls.TLSUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.MscOpts;

public class NetUtil
extends RapidoidThing {
    public static <T> T connect(String address, int port, F3<T, InputStream, BufferedReader, DataOutputStream> protocol) {
        return NetUtil.connect(address, port, 0, protocol);
    }

    public static <T> T connect(String address, int port, int timeout, F3<T, InputStream, BufferedReader, DataOutputStream> protocol) {
        return MscOpts.isTLSEnabled() ? NetUtil.connectSSL(address, port, timeout, protocol) : NetUtil.connectNoSSL(address, port, timeout, protocol);
    }

    private static SSLSocket sslSocket(String address, int port, int timeout) throws Exception {
        SSLContext sc = TLSUtil.createTrustingContext();
        SSLSocketFactory ssf = sc.getSocketFactory();
        SSLSocket socket = (SSLSocket)ssf.createSocket(address, port);
        socket.setSoTimeout(timeout);
        socket.startHandshake();
        return socket;
    }

    private static <T> T connectSSL(String address, int port, int timeout, F3<T, InputStream, BufferedReader, DataOutputStream> protocol) {
        T resp;
        try (SSLSocket socket = NetUtil.sslSocket(address, port, timeout);){
            socket.setSoTimeout(timeout);
            resp = NetUtil.communicate(protocol, socket);
            socket.close();
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        return resp;
    }

    private static <T> T connectNoSSL(String address, int port, int timeout, F3<T, InputStream, BufferedReader, DataOutputStream> protocol) {
        T resp;
        try (Socket socket = new Socket(address, port);){
            socket.setSoTimeout(timeout);
            resp = NetUtil.communicate(protocol, socket);
            socket.close();
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        return resp;
    }

    private static <T> T communicate(F3<T, InputStream, BufferedReader, DataOutputStream> protocol, Socket socket) throws Exception {
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        InputStream inputStream = socket.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return (T)protocol.execute((Object)inputStream, (Object)reader, (Object)out);
    }

    public static byte[] writeAndRead(String address, int port, final byte[] req, int timeout) {
        return NetUtil.connect(address, port, timeout, new F3<byte[], InputStream, BufferedReader, DataOutputStream>(){

            public byte[] execute(InputStream in, BufferedReader reader, DataOutputStream out) throws Exception {
                out.write(req);
                return IO.readWithTimeout((InputStream)in);
            }
        });
    }
}

