/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;

public class HashTableDummyOperator
extends Operator<HashTableDummyDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        TableDesc tbl = ((HashTableDummyDesc)this.getConf()).getTbl();
        try {
            Deserializer serde = tbl.getDeserializerClass().newInstance();
            serde.initialize(hconf, tbl.getProperties());
            this.outputObjInspector = serde.getObjectInspector();
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            this.LOG.error((Object)"Generating output obj inspector from dummy object error", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        throw new HiveException();
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
    }

    @Override
    public String getName() {
        return HashTableDummyOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "HASHTABLEDUMMY";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.HASHTABLEDUMMY;
    }
}

