/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.crypto.Mac;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.tez.common.TezUtils;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;

public class HivePreWarmProcessor
implements LogicalIOProcessor {
    private static boolean prewarmed = false;
    private static final Log LOG = LogFactory.getLog(HivePreWarmProcessor.class);
    private Configuration conf;

    public void initialize(TezProcessorContext processorContext) throws Exception {
        byte[] userPayload = processorContext.getUserPayload();
        this.conf = TezUtils.createConfFromUserPayload((byte[])userPayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        if (prewarmed) {
            return;
        }
        for (LogicalInput input : inputs.values()) {
            input.start();
        }
        for (LogicalOutput output : outputs.values()) {
            output.start();
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Mac mac = Mac.getInstance("HmacSHA1");
        ReadaheadPool rpool = ReadaheadPool.getInstance();
        ShimLoader.getHadoopShims();
        URL hiveurl = new URL("jar:" + DagUtils.getInstance().getExecJarPathLocal() + "!/");
        JarURLConnection hiveconn = (JarURLConnection)hiveurl.openConnection();
        JarFile hivejar = hiveconn.getJarFile();
        try {
            Enumeration<JarEntry> classes = hivejar.entries();
            while (classes.hasMoreElements()) {
                String klass;
                JarEntry je = classes.nextElement();
                if (!je.getName().endsWith(".class") || (klass = je.getName().replace(".class", "").replaceAll("/", "\\.")).indexOf("ql.exec") == -1 && klass.indexOf("ql.io") == -1 || klass.indexOf("vector") == -1 && klass.indexOf("Operator") == -1) continue;
                Class.forName(klass);
            }
        }
        finally {
            hivejar.close();
        }
        prewarmed = true;
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws Exception {
    }
}

