/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapOperator;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class MapRecordProcessor
extends RecordProcessor {
    private MapOperator mapOp;
    public static final Log l4j = LogFactory.getLog(MapRecordProcessor.class);
    private final ExecMapperContext execContext = new ExecMapperContext();
    private boolean abort = false;
    protected static final String MAP_PLAN_KEY = "__MAP_PLAN__";
    private MapWork mapWork;

    @Override
    void init(JobConf jconf, TezProcessorContext processorContext, MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.PerfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(jconf, processorContext, mrReporter, inputs, outputs);
        MRInputLegacy mrInput = TezProcessor.getMRInput(inputs);
        Configuration updatedConf = mrInput.getConfigUpdates();
        if (updatedConf != null) {
            for (Map.Entry<String, LogicalOutput> entry : updatedConf) {
                jconf.set(entry.getKey(), (String)entry.getValue());
            }
        }
        this.createOutputMap();
        for (Map.Entry<String, LogicalOutput> outputEntry : outputs.entrySet()) {
            l4j.info((Object)("Starting Output: " + outputEntry.getKey()));
            outputEntry.getValue().start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        ObjectCache cache = ObjectCacheFactory.getCache((Configuration)jconf);
        try {
            this.execContext.setJc(jconf);
            this.mapWork = (MapWork)cache.retrieve(MAP_PLAN_KEY);
            if (this.mapWork == null) {
                this.mapWork = Utilities.getMapWork((Configuration)jconf);
                cache.cache(MAP_PLAN_KEY, this.mapWork);
                l4j.info((Object)("Plan: " + this.mapWork));
                for (String s : this.mapWork.getAliases()) {
                    l4j.info((Object)("Alias: " + s));
                }
            } else {
                Utilities.setMapWork((Configuration)jconf, this.mapWork);
            }
            this.mapOp = this.mapWork.getVectorMode() ? new VectorMapOperator() : new MapOperator();
            this.mapOp.setConf(this.mapWork);
            this.mapOp.setChildren((Configuration)jconf);
            l4j.info((Object)this.mapOp.dump(0));
            MapredContext.init(true, new JobConf((Configuration)jconf));
            ((TezContext)MapredContext.get()).setInputs(inputs);
            this.mapOp.setExecContext(this.execContext);
            this.mapOp.initializeLocalWork((Configuration)jconf);
            this.mapOp.initialize((Configuration)jconf, null);
            List<HashTableDummyOperator> dummyOps = this.mapWork.getDummyOps();
            if (dummyOps != null) {
                for (HashTableDummyOperator dummyOp : dummyOps) {
                    dummyOp.setExecContext(this.execContext);
                    dummyOp.initialize((Configuration)jconf, null);
                }
            }
            OperatorUtils.setChildrenCollector(this.mapOp.getChildOperators(), this.outMap);
            this.mapOp.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    @Override
    void run() throws IOException {
        Object value;
        boolean needMore;
        MRInputLegacy in = TezProcessor.getMRInput(this.inputs);
        KeyValueReader reader = in.getReader();
        while (reader.next() && (needMore = this.processRow(value = reader.getCurrentValue()))) {
        }
    }

    private boolean processRow(Object value) {
        this.execContext.resetRow();
        try {
            if (this.mapOp.getDone()) {
                return false;
            }
            this.mapOp.process((Writable)value);
            if (this.isLogInfoEnabled) {
                this.logProgress();
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.fatal((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (!this.abort) {
            this.abort = this.execContext.getIoCxt().getIOExceptions();
        }
        try {
            this.mapOp.close(this.abort);
            List<HashTableDummyOperator> dummyOps = this.mapWork.getDummyOps();
            if (dummyOps != null) {
                for (HashTableDummyOperator dummyOp : dummyOps) {
                    dummyOp.close(this.abort);
                }
            }
            if (this.isLogInfoEnabled) {
                this.logCloseInfo();
            }
            ExecMapper.reportStats rps = new ExecMapper.reportStats((Reporter)this.reporter);
            this.mapOp.preorderMap(rps);
            return;
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            Utilities.clearWorkMap();
            MapredContext.close();
        }
    }
}

