/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.tools;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordProcessor;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class InputMerger
implements KeyValuesReader {
    public static final Log l4j = LogFactory.getLog(ReduceRecordProcessor.class);
    private PriorityQueue<KeyValuesReader> pQueue = null;
    private KeyValuesReader nextKVReader = null;

    public InputMerger(List<? extends Input> shuffleInputs) throws Exception {
        int initialCapacity = shuffleInputs.size();
        this.pQueue = new PriorityQueue<KeyValuesReader>(initialCapacity, new KVReaderComparator());
        for (Input input : shuffleInputs) {
            this.addToQueue((KeyValuesReader)input.getReader());
        }
    }

    private void addToQueue(KeyValuesReader kvsReadr) throws IOException {
        if (kvsReadr.next()) {
            this.pQueue.add(kvsReadr);
        }
    }

    public boolean next() throws IOException {
        if (this.nextKVReader != null) {
            this.addToQueue(this.nextKVReader);
        }
        this.nextKVReader = this.pQueue.poll();
        return this.nextKVReader != null;
    }

    public Object getCurrentKey() throws IOException {
        return this.nextKVReader.getCurrentKey();
    }

    public Iterable<Object> getCurrentValues() throws IOException {
        return this.nextKVReader.getCurrentValues();
    }

    class KVReaderComparator
    implements Comparator<KeyValuesReader> {
        KVReaderComparator() {
        }

        @Override
        public int compare(KeyValuesReader kvReadr1, KeyValuesReader kvReadr2) {
            try {
                BinaryComparable key1 = (BinaryComparable)kvReadr1.getCurrentKey();
                BinaryComparable key2 = (BinaryComparable)kvReadr2.getCurrentKey();
                return key1.compareTo(key2);
            }
            catch (IOException e) {
                l4j.error((Object)"Caught exception while reading shuffle input", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

