/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class BytesColumnVector
extends ColumnVector {
    public byte[][] vector;
    public int[] start;
    public int[] length;
    private byte[] buffer;
    private int nextFree;
    private final Text textObject = new Text();
    static final int DEFAULT_BUFFER_SIZE = 16384;
    static final float EXTRA_SPACE_FACTOR = 1.2f;

    public BytesColumnVector() {
        this(1024);
    }

    public BytesColumnVector(int size) {
        super(size);
        this.vector = new byte[size][];
        this.start = new int[size];
        this.length = new int[size];
    }

    public void setRef(int elementNum, byte[] sourceBuf, int start, int length) {
        this.vector[elementNum] = sourceBuf;
        this.start[elementNum] = start;
        this.length[elementNum] = length;
    }

    public void initBuffer(int estimatedValueSize) {
        this.nextFree = 0;
        if (this.buffer != null) {
            return;
        }
        int bufferSize = this.vector.length * (int)((float)estimatedValueSize * 1.2f);
        if (bufferSize < 16384) {
            bufferSize = 16384;
        }
        this.buffer = new byte[bufferSize];
    }

    public void initBuffer() {
        this.initBuffer(0);
    }

    public int bufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length;
    }

    public void setVal(int elementNum, byte[] sourceBuf, int start, int length) {
        if (this.nextFree + length > this.buffer.length) {
            this.increaseBufferSpace(length);
        }
        System.arraycopy(sourceBuf, start, this.buffer, this.nextFree, length);
        this.vector[elementNum] = this.buffer;
        this.start[elementNum] = this.nextFree;
        this.length[elementNum] = length;
        this.nextFree += length;
    }

    public void setConcat(int elementNum, byte[] leftSourceBuf, int leftStart, int leftLen, byte[] rightSourceBuf, int rightStart, int rightLen) {
        int newLen = leftLen + rightLen;
        if (this.nextFree + newLen > this.buffer.length) {
            this.increaseBufferSpace(newLen);
        }
        this.vector[elementNum] = this.buffer;
        this.start[elementNum] = this.nextFree;
        this.length[elementNum] = newLen;
        System.arraycopy(leftSourceBuf, leftStart, this.buffer, this.nextFree, leftLen);
        this.nextFree += leftLen;
        System.arraycopy(rightSourceBuf, rightStart, this.buffer, this.nextFree, rightLen);
        this.nextFree += rightLen;
    }

    public void increaseBufferSpace(int nextElemLength) {
        int newLength;
        for (newLength = 2 * this.buffer.length; this.nextFree + nextElemLength > newLength; newLength *= 2) {
        }
        byte[] newBuffer = new byte[newLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.nextFree);
        this.buffer = newBuffer;
    }

    @Override
    public Writable getWritableObject(int index) {
        if (this.isRepeating) {
            index = 0;
        }
        NullWritable result = null;
        if (!this.isNull[index] && this.vector[index] != null) {
            this.textObject.clear();
            this.textObject.append(this.vector[index], this.start[index], this.length[index]);
            result = this.textObject;
        } else {
            result = NullWritable.get();
        }
        return result;
    }

    public void copySelected(boolean selectedInUse, int[] sel, int size, BytesColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.setVal(0, this.vector[0], this.start[0], this.length[0]);
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = sel[j];
                output.setVal(i, this.vector[i], this.start[i], this.length[i]);
            }
        } else {
            for (int i2 = 0; i2 < size; ++i2) {
                output.setVal(i2, this.vector[i2], this.start[i2], this.length[i2]);
            }
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        if (this.isRepeating) {
            this.isRepeating = false;
            if (this.noNulls || !this.noNulls && !this.isNull[0]) {
                if (selectedInUse) {
                    for (int j = 1; j < size; ++j) {
                        int i = sel[j];
                        this.setRef(i, this.vector[0], this.start[0], this.length[0]);
                    }
                } else {
                    for (int i = 1; i < size; ++i) {
                        this.setRef(i, this.vector[0], this.start[0], this.length[0]);
                    }
                }
            }
            this.flattenRepeatingNulls(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    public void fill(byte[] value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.setRef(0, value, 0, value.length);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        BytesColumnVector in = (BytesColumnVector)inputVector;
        this.setVal(outElementNum, in.vector[inputElementNum], in.start[inputElementNum], in.length[outElementNum]);
    }

    @Override
    public void init() {
        this.initBuffer(0);
    }
}

